/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.jaxb.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.spi.Model;
import org.glassfish.hk2.xml.spi.PreGenerationRequirement;
import org.glassfish.hk2.xml.spi.XmlServiceParser;

@Singleton
@Named(value="JAXBXmlParsingService")
@Visibility(value=DescriptorVisibility.LOCAL)
public class JAXBXmlParser
implements XmlServiceParser {
    @Override
    public <T> T parseRoot(Model rootModel, URI location, Unmarshaller.Listener listener) throws Exception {
        Class<?> clazz = rootModel.getProxyAsClass();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setListener(listener);
        Object root = unmarshaller.unmarshal(location.toURL());
        return (T)root;
    }

    @Override
    public <T> T parseRoot(Model rootModel, InputStream input, Unmarshaller.Listener listener) throws Exception {
        Class<?> clazz = rootModel.getProxyAsClass();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        unmarshaller.setListener(listener);
        Object root = unmarshaller.unmarshal(input);
        return (T)root;
    }

    @Override
    public PreGenerationRequirement getPreGenerationRequirement() {
        return PreGenerationRequirement.MUST_PREGENERATE;
    }

    @Override
    public <T> void marshal(OutputStream outputStream, XmlRootHandle<T> rootHandle) throws IOException {
        T root = rootHandle.getRoot();
        if (root == null) {
            return;
        }
        XmlHk2ConfigurationBean xmlBean = (XmlHk2ConfigurationBean)root;
        ModelImpl model = xmlBean._getModel();
        Class<?> clazz = model.getProxyAsClass();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(root, outputStream);
        }
        catch (RuntimeException re) {
            throw new IOException(re);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

