/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.basic;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.api.XmlServiceUtilities;
import org.glassfish.hk2.xml.spi.XmlServiceParser;
import org.glassfish.hk2.xml.test.basic.beans.Commons;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class UnmarshallTest {
    @Test
    public void testInterfaceJaxbUnmarshalling() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        URI uri = url.toURI();
        Commons.testInterfaceJaxbUnmarshalling(locator, uri);
    }

    @Test
    public void testBeanLikeMapOfInterface() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        URI uri = url.toURI();
        Commons.testBeanLikeMapOfInterface(locator, uri);
    }

    @Test
    public void testInterfaceJaxbUnmarshallingWithChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        URI uri = url.toURI();
        Commons.testInterfaceJaxbUnmarshallingWithChildren(locator, uri);
    }

    @Test
    public void testComplexUnmarshalling() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("sample-config.xml");
        URI uri = url.toURI();
        Commons.testComplexUnmarshalling(locator, uri);
    }

    @Test
    public void testUnkeyedChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("sample-config.xml");
        URI uri = url.toURI();
        Commons.testUnkeyedChildren(locator, uri);
    }

    @Test
    public void testSameClassTwoChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("foobar.xml");
        URI uri = url.toURI();
        Commons.testSameClassTwoChildren(locator, uri);
    }

    @Test
    public void testBeanCycle() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("cycle.xml");
        URI uri = url.toURI();
        Commons.testBeanCycle(locator, uri);
    }

    @Test
    public void testEveryType() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("type1.xml");
        URI uri = url.toURI();
        Commons.testEveryType(locator, uri);
    }

    @Test
    public void testAnnotationWithEverythingCopied() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        URI uri = url.toURI();
        Commons.testAnnotationWithEverythingCopied(locator, uri);
    }

    @Test
    public void testEmptyListChildReturnsEmptyList() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        URI uri = url.toURI();
        Commons.testEmptyListChildReturnsEmptyList(locator, uri);
    }

    @Test
    public void testEmptyArrayChildReturnsEmptyArray() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        URI uri = url.toURI();
        Commons.testEmptyArrayChildReturnsEmptyArray(locator, uri);
    }

    @Test
    @Ignore
    public void testByteArrayNonChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme2.xml");
        URI uri = url.toURI();
        Commons.testByteArrayNonChild(locator, uri);
    }

    @Test
    public void testJaxbStyleReference() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("sample-config.xml");
        URI uri = url.toURI();
        Commons.testJaxbStyleReference(locator, uri);
    }

    @Test
    public void testXmlJavaTypeAdapter() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("xmljavatypeadapter/root-bean-with-properties.xml");
        URI uri = url.toURI();
        Commons.testXmlJavaTypeAdapter(locator, uri);
    }

    @Test
    @Ignore
    public void testJaxbStyleForwardReference() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        URL url = this.getClass().getClassLoader().getResource("reference1.xml");
        URI uri = url.toURI();
        Commons.testJaxbStyleForwardReference(locator, uri);
    }

    @Test
    public void testIdempotent() throws Exception {
        ServiceLocator locator = ServiceLocatorFactory.getInstance().create(null, null, Utilities.GENERATOR);
        XmlServiceUtilities.enableXmlService((ServiceLocator)locator);
        XmlServiceUtilities.enableXmlService((ServiceLocator)locator);
        List allXmlServices = locator.getAllServices(XmlService.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)allXmlServices.size());
        List allParsers = locator.getAllServices(XmlServiceParser.class, new Annotation[0]);
        Assert.assertEquals((long)1L, (long)allParsers.size());
        Assert.assertNotNull((Object)locator.getService(XmlService.class, "JAXBXmlParsingService", new Annotation[0]));
        Assert.assertNull((Object)locator.getService(XmlService.class, "StreamXmlParsingService", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(XmlServiceParser.class, "JAXBXmlParsingService", new Annotation[0]));
        Assert.assertNull((Object)locator.getService(XmlServiceParser.class, "StreamXmlParsingService", new Annotation[0]));
        XmlServiceUtilities.enableDomXmlService((ServiceLocator)locator);
        XmlServiceUtilities.enableDomXmlService((ServiceLocator)locator);
        allXmlServices = locator.getAllServices(XmlService.class, new Annotation[0]);
        Assert.assertEquals((long)2L, (long)allXmlServices.size());
        allParsers = locator.getAllServices(XmlServiceParser.class, new Annotation[0]);
        Assert.assertEquals((long)2L, (long)allParsers.size());
        Assert.assertNotNull((Object)locator.getService(XmlService.class, "JAXBXmlParsingService", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(XmlService.class, "StreamXmlParsingService", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(XmlServiceParser.class, "JAXBXmlParsingService", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(XmlServiceParser.class, "StreamXmlParsingService", new Annotation[0]));
    }
}

