/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.marshall;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans2.RefereeBean;
import org.glassfish.hk2.xml.test.beans2.ReferencesBean;
import org.glassfish.hk2.xml.test.dynamic.marshall.KeyedLeafBean;
import org.glassfish.hk2.xml.test.dynamic.marshall.OrderingRootBean;
import org.glassfish.hk2.xml.test.dynamic.marshall.StringArrayBean;
import org.glassfish.hk2.xml.test.dynamic.marshall.UnkeyedLeafBean;
import org.glassfish.hk2.xml.test.dynamic.merge.MergeTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class MarshallTest {
    private static final File OUTPUT_FILE = new File("output.xml");
    private static final String LOOK_FOR_ME = "0.255.255.255";
    public static final String REFEREES1_FILE = "Referees1.xml";
    private static final String REF1 = "<machine>Alice</machine>";
    private static final String REF2 = "<subnetwork>0.255.255.255</subnetwork>";
    private static final String REF3 = "<references first-referee=\"Laird Hayes\" last-referee=\"Boris Cheek\">";
    private static final String A = "A";
    private static final String B = "B";
    private static final String C = "C";
    private static final String D = "D";
    private static final String E = "E";
    private static final String F = "F";
    private static final String G = "G";
    private static final String H = "H";
    private static final String I = "I";
    private static final String J = "J";
    private static final String K = "K";

    @Before
    public void before() {
        if (OUTPUT_FILE.exists()) {
            boolean didDelete = OUTPUT_FILE.delete();
            Assert.assertTrue((boolean)didDelete);
        }
    }

    @After
    public void after() {
        if (OUTPUT_FILE.exists()) {
            OUTPUT_FILE.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testMarshallBackAfterUpdate() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean root = (DomainBean)rootHandle.getRoot();
        root.setSubnetwork(LOOK_FOR_ME);
        FileOutputStream fos = new FileOutputStream(OUTPUT_FILE);
        try {
            rootHandle.marshal((OutputStream)fos);
        }
        finally {
            fos.close();
        }
        this.checkFile(REF1, REF2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFile(String ... strings) throws Exception {
        HashMap<String, Boolean> foundAll = new HashMap<String, Boolean>();
        for (String string : strings) {
            foundAll.put(string, false);
        }
        FileReader reader = new FileReader(OUTPUT_FILE);
        BufferedReader buffered = new BufferedReader(reader);
        try {
            String line;
            while ((line = buffered.readLine()) != null) {
                for (String string : foundAll.keySet()) {
                    if (!line.contains(string)) continue;
                    foundAll.put(string, true);
                }
            }
        }
        finally {
            buffered.close();
            reader.close();
        }
        for (Map.Entry entry : foundAll.entrySet()) {
            String lookingFor = (String)entry.getKey();
            boolean found = (Boolean)entry.getValue();
            Assert.assertTrue((String)("Did not find the string " + lookingFor), (boolean)found);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshallBackAfterUpdateDom() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean root = (DomainBean)rootHandle.getRoot();
        root.setSubnetwork(LOOK_FOR_ME);
        FileOutputStream fos = new FileOutputStream(OUTPUT_FILE);
        try {
            rootHandle.marshal((OutputStream)fos);
        }
        finally {
            fos.close();
        }
        this.checkFile(REF1, REF2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalAttributeReferences() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(REFEREES1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ReferencesBean.class, false, false);
        ReferencesBean references = (ReferencesBean)rootHandle.getRoot();
        RefereeBean hayes = references.getReferees().get(0);
        RefereeBean cheek = references.getReferees().get(1);
        Assert.assertNotNull((Object)hayes);
        Assert.assertNotNull((Object)cheek);
        Assert.assertEquals((Object)hayes, (Object)references.getFirstReferee());
        Assert.assertEquals((Object)cheek, (Object)references.getLastReferee());
        FileOutputStream fos = new FileOutputStream(OUTPUT_FILE);
        try {
            rootHandle.marshal((OutputStream)fos);
        }
        finally {
            fos.close();
        }
        this.checkFile(REF3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalAttributeReferencesUsingXmlService() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(REFEREES1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ReferencesBean.class, false, false);
        ReferencesBean references = (ReferencesBean)rootHandle.getRoot();
        RefereeBean hayes = references.getReferees().get(0);
        RefereeBean cheek = references.getReferees().get(1);
        Assert.assertNotNull((Object)hayes);
        Assert.assertNotNull((Object)cheek);
        Assert.assertEquals((Object)hayes, (Object)references.getFirstReferee());
        Assert.assertEquals((Object)cheek, (Object)references.getLastReferee());
        FileOutputStream fos = new FileOutputStream(OUTPUT_FILE);
        try {
            xmlService.marshal((OutputStream)fos, rootHandle);
        }
        finally {
            fos.close();
        }
        this.checkFile(REF3);
    }

    private static void fillInKeyedLeafBean(KeyedLeafBean klb) {
        klb.setPropertyI(I);
        klb.setPropertyH(H);
    }

    private static void fillInUnkeyedLeafBean(UnkeyedLeafBean ulb) {
        ulb.setPropertyJ(J);
        ulb.setPropertyK(K);
    }

    private static void fillInRootBean(OrderingRootBean orb, XmlService xmlService) {
        KeyedLeafBean propA = orb.addPropertyA(H);
        MarshallTest.fillInKeyedLeafBean(propA);
        UnkeyedLeafBean propB = orb.addPropertyB();
        MarshallTest.fillInUnkeyedLeafBean(propB);
        UnkeyedLeafBean propC = orb.addPropertyC();
        MarshallTest.fillInUnkeyedLeafBean(propC);
        KeyedLeafBean propD = orb.addPropertyD(H);
        MarshallTest.fillInKeyedLeafBean(propD);
        KeyedLeafBean propE = (KeyedLeafBean)xmlService.createBean(KeyedLeafBean.class);
        MarshallTest.fillInKeyedLeafBean(propE);
        orb.setPropertyE(propE);
        UnkeyedLeafBean propF = (UnkeyedLeafBean)xmlService.createBean(UnkeyedLeafBean.class);
        MarshallTest.fillInUnkeyedLeafBean(propF);
        orb.setPropertyF(propF);
        orb.setPropertyG(G);
    }

    @Test
    public void testOrderingSpecifiedWithXmlType() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        this.orderingSpecifiedWithXmlType(locator);
    }

    @Test
    public void testOrderingSpecifiedWithXmlTypeJAXB() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        this.orderingSpecifiedWithXmlType(locator);
    }

    @Test
    public void testMarshalStringArrayJAXB() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService jaxbXmlService = (XmlService)locator.getService(XmlService.class, "JAXBXmlParsingService", new Annotation[0]);
        this.validateStringArray(jaxbXmlService);
    }

    @Test
    public void testMarshalStringArray() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService streamXmlService = (XmlService)locator.getService(XmlService.class, "StreamXmlParsingService", new Annotation[0]);
        this.validateStringArray(streamXmlService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateStringArray(XmlService xmlService) throws Exception {
        XmlRootHandle handle = xmlService.createEmptyHandle(StringArrayBean.class, false, false);
        handle.addRoot();
        StringArrayBean root = (StringArrayBean)handle.getRoot();
        String[] datum = new String[]{"foo", "bar", "baz"};
        root.setData(datum);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            handle.marshal((OutputStream)baos);
        }
        finally {
            baos.close();
        }
        byte[] asBytes = baos.toByteArray();
        String asString = new String(asBytes);
        Assert.assertTrue((String)asString, (boolean)asString.contains("<data>foo</data>"));
        Assert.assertTrue((String)asString, (boolean)asString.contains("<data>bar</data>"));
        Assert.assertTrue((String)asString, (boolean)asString.contains("<data>baz</data>"));
        ByteArrayInputStream bais = new ByteArrayInputStream(asBytes);
        try {
            XmlRootHandle handle2 = xmlService.unmarshal((InputStream)bais, StringArrayBean.class, false, false);
            StringArrayBean root2 = (StringArrayBean)handle2.getRoot();
            Object[] data2 = root2.getData();
            Assert.assertEquals((String)Arrays.toString(data2), (long)3L, (long)data2.length);
            Assert.assertEquals((Object)"foo", (Object)data2[0]);
            Assert.assertEquals((Object)"bar", (Object)data2[1]);
            Assert.assertEquals((Object)"baz", (Object)data2[2]);
        }
        finally {
            bais.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orderingSpecifiedWithXmlType(ServiceLocator locator) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.createEmptyHandle(OrderingRootBean.class);
        rootHandle.addRoot();
        OrderingRootBean root = (OrderingRootBean)rootHandle.getRoot();
        MarshallTest.fillInRootBean(root, xmlService);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            rootHandle.marshal((OutputStream)baos);
        }
        finally {
            baos.close();
        }
        LinkedHashMap<Integer, String> lines = new LinkedHashMap<Integer, String>();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        BufferedReader br = new BufferedReader(new InputStreamReader(bais));
        try {
            String line;
            int lcv = 0;
            while ((line = br.readLine()) != null) {
                lines.put(lcv, line);
                ++lcv;
            }
        }
        finally {
            br.close();
        }
        String failureDocument = baos.toString();
        boolean foundF = false;
        boolean foundG = false;
        boolean foundE = false;
        boolean foundA = false;
        boolean foundC = false;
        boolean foundB = false;
        boolean foundD = false;
        for (Map.Entry lineEntry : lines.entrySet()) {
            String line = (String)lineEntry.getValue();
            int lineNumber = (Integer)lineEntry.getKey();
            if (line.contains("<f>")) {
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundF);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundG);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundE);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundA);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundB);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundD);
                foundF = true;
            }
            if (line.contains("<g>")) {
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundF);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundG);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundE);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundA);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundC);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundB);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundD);
                foundG = true;
            }
            if (line.contains("<e>")) {
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundF);
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundG);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundE);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundA);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundC);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundB);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundD);
                foundE = true;
            }
            if (line.contains("<a>")) {
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundF);
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundG);
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundE);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundA);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundC);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundB);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundD);
                foundA = true;
            }
            if (line.contains("<c>")) {
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundF);
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundG);
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundE);
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundA);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundC);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundB);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundD);
                foundC = true;
            }
            if (line.contains("<b>")) {
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundF);
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundG);
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundE);
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundA);
                Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundC);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundB);
                Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundD);
                foundB = true;
            }
            if (!line.contains("<d>")) continue;
            Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundF);
            Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundG);
            Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundE);
            Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundA);
            Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundC);
            Assert.assertTrue((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundB);
            Assert.assertFalse((String)("Order wrong on line " + lineNumber + " of\n" + failureDocument), (boolean)foundD);
            foundD = true;
        }
        Assert.assertTrue((boolean)foundD);
    }
}

