/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.elementwrapper;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.elementwrapper.beans.WrapperLeafBean;
import org.glassfish.hk2.xml.test.elementwrapper.beans.WrapperMiddleBean;
import org.glassfish.hk2.xml.test.elementwrapper.beans.WrapperRootBean;
import org.junit.Assert;

public class XmlElementWrapperCommon {
    private static final String WRAPPER_FILE1 = "elementwrapper/ElementWrapper1.xml";
    private static final String ALICE = "Alice";
    private static final String BOB = "Bob";

    public static void testReadOneOfEachElement(ServiceLocator locator, ClassLoader cl) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = cl.getResource(WRAPPER_FILE1);
        URI uri = url.toURI();
        XmlRootHandle handle = xmlService.unmarshal(uri, WrapperRootBean.class, true, true);
        WrapperRootBean root = (WrapperRootBean)handle.getRoot();
        Assert.assertNotNull((Object)root);
        List<WrapperMiddleBean> middles = root.getMiddle();
        Assert.assertEquals((long)1L, (long)middles.size());
        WrapperMiddleBean middle = middles.get(0);
        Assert.assertEquals((Object)ALICE, (Object)middle.getName());
        XmlHk2ConfigurationBean middleConfigBean = (XmlHk2ConfigurationBean)middle;
        Assert.assertEquals((Object)"/wrapper-root/middles/middle", (Object)middleConfigBean._getXmlPath());
        Assert.assertEquals((Object)"wrapper-root.middles.Alice", (Object)middleConfigBean._getInstanceName());
        Assert.assertEquals((Object)ALICE, (Object)middleConfigBean._getKeyValue());
        List<WrapperLeafBean> leaves = middle.getLeaves();
        Assert.assertEquals((long)1L, (long)leaves.size());
        WrapperLeafBean leaf = leaves.get(0);
        Assert.assertEquals((Object)BOB, (Object)leaf.getData());
        XmlHk2ConfigurationBean leafConfigBean = (XmlHk2ConfigurationBean)leaf;
        Assert.assertEquals((Object)"/wrapper-root/middles/middle/leaves/leaf", (Object)leafConfigBean._getXmlPath());
        String instanceName = leafConfigBean._getInstanceName();
        Assert.assertNull((Object)leafConfigBean._getKeyPropertyName());
        String keyValue = leafConfigBean._getKeyValue();
        Assert.assertNotNull((Object)keyValue);
        String fullKeyName = "wrapper-root.middles.Alice.leaves." + keyValue;
        Assert.assertEquals((Object)fullKeyName, (Object)instanceName);
    }
}

