/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.validation;

import java.beans.VetoableChangeListener;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.glassfish.hk2.xml.test.validation.BeanToValidate1Bean;
import org.glassfish.hk2.xml.test.validation.CaptureRootChangeListener;
import org.glassfish.hk2.xml.test.validation.ConstraintRootBean;
import org.glassfish.hk2.xml.test.validation.HasChildWithNameValidator;
import org.glassfish.hk2.xml.test.validation.NamedBean;
import org.glassfish.hk2.xml.test.validation.ValidationChildArrayBean;
import org.glassfish.hk2.xml.test.validation.ValidationChildBean;
import org.glassfish.hk2.xml.test.validation.ValidationChildDirectBean;
import org.glassfish.hk2.xml.test.validation.ValidationRootBean;
import org.junit.Assert;
import org.junit.Test;

public class ValidationTest {
    private static final String VALID1_FILE = "valid1.xml";
    private static final String VALID2_FILE = "valid2.xml";
    private static final String INVALID1_FILE = "invalid1.xml";
    private static final String INVALID2_FILE = "invalid2.xml";
    private static final String INVALID3_FILE = "invalid3.xml";
    private static final String INVALID4_FILE = "invalid4.xml";
    private static final String E1 = "E1";
    private static final String ALICE = "Alice";
    private static final String BOB = "Bob";

    @Test
    public void testValidDocument() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(VALID1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ValidationRootBean.class);
        Assert.assertFalse((boolean)rootHandle.isValidating());
        rootHandle.startValidating();
        Assert.assertTrue((boolean)rootHandle.isValidating());
        rootHandle.stopValidating();
        Assert.assertFalse((boolean)rootHandle.isValidating());
    }

    @Test
    public void testInvalidDocument() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(INVALID1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ValidationRootBean.class);
        ValidationRootBean validationRoot = (ValidationRootBean)rootHandle.getRoot();
        Assert.assertNull((Object)validationRoot.getElementOne());
        try {
            rootHandle.startValidating();
            Assert.fail((String)"Should have failed");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    private static void checkMultiException(MultiException me, String expectedConstraintMessage) {
        ConstraintViolationException found = null;
        for (Throwable th : me.getErrors()) {
            if (!(th instanceof ConstraintViolationException)) continue;
            found = (ConstraintViolationException)th;
            break;
        }
        Assert.assertNotNull(found);
        boolean foundMessage = false;
        Set violations = found.getConstraintViolations();
        for (ConstraintViolation violation : violations) {
            if (!expectedConstraintMessage.equals(violation.getMessage())) continue;
            foundMessage = true;
            break;
        }
        Assert.assertTrue((String)("Did not find expected exception in " + (Object)((Object)me) + " was looking for " + expectedConstraintMessage), (boolean)foundMessage);
    }

    @Test
    public void testBadSet() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(VALID1_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ValidationRootBean.class);
        rootHandle.startValidating();
        ValidationRootBean root = (ValidationRootBean)rootHandle.getRoot();
        Assert.assertEquals((Object)E1, (Object)root.getElementOne());
        try {
            root.setElementOne(null);
            Assert.fail((String)"Should not have worked because validation is on");
        }
        catch (MultiException e) {
            ValidationTest.checkMultiException(e, "may not be null");
        }
        Assert.assertEquals((Object)E1, (Object)root.getElementOne());
    }

    @Test
    public void testValidDocumentWithChildren() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(VALID2_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ValidationRootBean.class);
        rootHandle.startValidating();
    }

    @Test
    public void testValidDocumentWithInvalidListChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(INVALID2_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ValidationRootBean.class);
        try {
            rootHandle.startValidating();
            Assert.fail((String)"Should have failed");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testValidDocumentWithInvalidArrayChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(INVALID3_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ValidationRootBean.class);
        try {
            rootHandle.startValidating();
            Assert.fail((String)"Should have failed");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testValidDocumentWithInvalidDirectChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(INVALID4_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ValidationRootBean.class);
        try {
            rootHandle.startValidating();
            Assert.fail((String)"Should have failed");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    @Test
    public void testAddInvalidListChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(VALID2_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ValidationRootBean.class);
        rootHandle.startValidating();
        ValidationChildBean listChild = (ValidationChildBean)xmlService.createBean(ValidationChildBean.class);
        ValidationRootBean root = (ValidationRootBean)rootHandle.getRoot();
        try {
            root.addListChild(listChild);
            Assert.fail((String)"Add of invalid bean should have failed");
        }
        catch (MultiException me) {
            ValidationTest.checkMultiException(me, "may not be null");
        }
        List<ValidationChildBean> listChildren = root.getListChildren();
        Assert.assertEquals((long)1L, (long)listChildren.size());
    }

    @Test
    public void testAddInvalidArrayChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(VALID2_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ValidationRootBean.class);
        rootHandle.startValidating();
        ValidationChildArrayBean arrayChild = (ValidationChildArrayBean)xmlService.createBean(ValidationChildArrayBean.class);
        ValidationRootBean root = (ValidationRootBean)rootHandle.getRoot();
        try {
            root.addArrayChild(arrayChild);
            Assert.fail((String)"Add of invalid array child should have failed");
        }
        catch (MultiException me) {
            ValidationTest.checkMultiException(me, "may not be null");
        }
        ValidationChildArrayBean[] arrayChildren = root.getArrayChildren();
        Assert.assertEquals((long)2L, (long)arrayChildren.length);
    }

    @Test
    public void testAddInvalidDirectChild() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource(VALID2_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), ValidationRootBean.class);
        rootHandle.startValidating();
        ValidationChildDirectBean directChild = (ValidationChildDirectBean)xmlService.createBean(ValidationChildDirectBean.class);
        ValidationRootBean root = (ValidationRootBean)rootHandle.getRoot();
        root.setDirectChild(null);
        try {
            root.setDirectChild(directChild);
            Assert.fail((String)"Add of invalid array child should have failed");
        }
        catch (MultiException me) {
            ValidationTest.checkMultiException(me, "may not be null");
        }
        Assert.assertNull((Object)root.getDirectChild());
    }

    private static void isConstraintViolationException(MultiException me) {
        for (Throwable th : me.getErrors()) {
            if (!(th instanceof ConstraintViolationException)) continue;
            return;
        }
        throw me;
    }

    @Test
    public void testBasicConstraint() {
        ServiceLocator locator = Utilities.createDomLocator(CaptureRootChangeListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle handle = xmlService.createEmptyHandle(ConstraintRootBean.class);
        handle.addChangeListener(new VetoableChangeListener[]{(VetoableChangeListener)locator.getService(CaptureRootChangeListener.class, new Annotation[0])});
        HasChildWithNameValidator.setRootListener((CaptureRootChangeListener)locator.getService(CaptureRootChangeListener.class, new Annotation[0]));
        handle.startValidating();
        handle.addRoot();
        ConstraintRootBean crb = (ConstraintRootBean)handle.getRoot();
        NamedBean namedBeanAlice = (NamedBean)xmlService.createBean(NamedBean.class);
        namedBeanAlice.setName(ALICE);
        namedBeanAlice = crb.addNamed(namedBeanAlice);
        BeanToValidate1Bean aliceBean = (BeanToValidate1Bean)xmlService.createBean(BeanToValidate1Bean.class);
        aliceBean.setNameReference(ALICE);
        crb.addValid1(aliceBean);
        BeanToValidate1Bean bobBean = (BeanToValidate1Bean)xmlService.createBean(BeanToValidate1Bean.class);
        bobBean.setNameReference(BOB);
        try {
            crb.addValid1(bobBean);
            Assert.fail((String)"Should have failed as there is no BOB bean");
        }
        catch (MultiException me) {
            ValidationTest.isConstraintViolationException(me);
        }
    }
}

