/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.basic;

import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.test.basic.beans.Commons;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Test;

public class UnmarshallXMLStreamTest {
    private final XMLInputFactory xif = XMLInputFactory.newInstance();

    private InputStream getStream(String fileName) throws Exception {
        URL url = this.getClass().getClassLoader().getResource(fileName);
        InputStream is = url.openStream();
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterfaceJaxbUnmarshalling() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("museum1.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testInterfaceJaxbUnmarshalling(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterfaceJaxbUnmarshallingStream() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("museum1.xml");
        try {
            Commons.testInterfaceJaxbUnmarshalling(locator, is);
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanLikeMapOfInterface() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("Acme1.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testBeanLikeMapOfInterface(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterfaceJaxbUnmarshallingWithChildren() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("Acme1.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testInterfaceJaxbUnmarshallingWithChildren(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplexUnmarshalling() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("sample-config.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testComplexUnmarshalling(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnkeyedChildren() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("sample-config.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testUnkeyedChildren(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSameClassTwoChildren() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("foobar.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testSameClassTwoChildren(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanCycle() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("cycle.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testBeanCycle(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEveryType() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("type1.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testEveryType(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnnotationWithEverythingCopied() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("Acme1.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testAnnotationWithEverythingCopied(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyListChildReturnsEmptyList() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("Acme1.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testEmptyListChildReturnsEmptyList(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyArrayChildReturnsEmptyArray() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("Acme1.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testEmptyArrayChildReturnsEmptyArray(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testByteArrayNonChild() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("Acme2.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testByteArrayNonChild(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJaxbStyleReference() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("sample-config.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testJaxbStyleReference(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJaxbStyleForwardReference() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("reference1.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testJaxbStyleForwardReference(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXmlJavaTypeAdapter() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        InputStream is = this.getStream("xmljavatypeadapter/root-bean-with-properties.xml");
        try {
            XMLStreamReader reader = this.xif.createXMLStreamReader(is);
            try {
                Commons.testXmlJavaTypeAdapter(locator, reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            is.close();
        }
    }
}

