/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.negative.ea;

import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.negative.ea.ElementAttributeLeaf;
import org.glassfish.hk2.xml.test.negative.ea.ElementAttributeRoot;
import org.junit.Assert;

public class ElementAttributeCommon {
    private static final String GOOD_FILE = "ea/ea1.xml";
    private static final String WHOLLY_MIXED_FILE = "ea/ea2.xml";
    private static final String BOTH_ATTRIBUTES_FILE = "ea/ea3.xml";
    private static final String BOTH_ELEMENTS_FILE = "ea/ea4.xml";
    private static final String ATTRIBUTE_VALUE = "attribute";
    private static final String ELEMENT_VALUE = "element";

    public static void testReadGoodFile(ServiceLocator locator, ClassLoader cl) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = cl.getResource(GOOD_FILE);
        URI uri = url.toURI();
        XmlRootHandle handle = xmlService.unmarshal(uri, ElementAttributeRoot.class, false, false);
        ElementAttributeRoot root = (ElementAttributeRoot)handle.getRoot();
        Assert.assertNotNull((Object)root);
        List<ElementAttributeLeaf> leaves = root.getLeaves();
        Assert.assertEquals((long)1L, (long)leaves.size());
        ElementAttributeLeaf leaf = leaves.get(0);
        Assert.assertEquals((Object)ATTRIBUTE_VALUE, (Object)leaf.getAttribute());
        Assert.assertEquals((Object)ELEMENT_VALUE, (Object)leaf.getElement());
    }

    public static void testReadWhollyMixedFile(ServiceLocator locator, ClassLoader cl) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = cl.getResource(WHOLLY_MIXED_FILE);
        URI uri = url.toURI();
        XmlRootHandle handle = xmlService.unmarshal(uri, ElementAttributeRoot.class, false, false);
        ElementAttributeRoot root = (ElementAttributeRoot)handle.getRoot();
        Assert.assertNotNull((Object)root);
        List<ElementAttributeLeaf> leaves = root.getLeaves();
        Assert.assertEquals((long)1L, (long)leaves.size());
        ElementAttributeLeaf leaf = leaves.get(0);
        Assert.assertNull((Object)leaf.getAttribute());
        Assert.assertNull((Object)leaf.getElement());
    }

    public static void testReadBothAttributes(ServiceLocator locator, ClassLoader cl) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = cl.getResource(BOTH_ATTRIBUTES_FILE);
        URI uri = url.toURI();
        XmlRootHandle handle = xmlService.unmarshal(uri, ElementAttributeRoot.class, false, false);
        ElementAttributeRoot root = (ElementAttributeRoot)handle.getRoot();
        Assert.assertNotNull((Object)root);
        List<ElementAttributeLeaf> leaves = root.getLeaves();
        Assert.assertEquals((long)1L, (long)leaves.size());
        ElementAttributeLeaf leaf = leaves.get(0);
        Assert.assertEquals((Object)ATTRIBUTE_VALUE, (Object)leaf.getAttribute());
        Assert.assertNull((Object)leaf.getElement());
    }

    public static void testReadBothElements(ServiceLocator locator, ClassLoader cl) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = cl.getResource(BOTH_ELEMENTS_FILE);
        URI uri = url.toURI();
        XmlRootHandle handle = xmlService.unmarshal(uri, ElementAttributeRoot.class, false, false);
        ElementAttributeRoot root = (ElementAttributeRoot)handle.getRoot();
        Assert.assertNotNull((Object)root);
        List<ElementAttributeLeaf> leaves = root.getLeaves();
        Assert.assertEquals((long)1L, (long)leaves.size());
        ElementAttributeLeaf leaf = leaves.get(0);
        Assert.assertNull((Object)leaf.getAttribute());
        Assert.assertEquals((Object)ELEMENT_VALUE, (Object)leaf.getElement());
    }
}

