/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal.alt.papi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltMethod;
import org.glassfish.hk2.xml.internal.alt.clazz.ClassAltClassImpl;
import org.glassfish.hk2.xml.internal.alt.papi.AnnotationMirrorAltAnnotationImpl;
import org.glassfish.hk2.xml.internal.alt.papi.ElementAltMethodImpl;

public class TypeElementAltClassImpl
implements AltClass {
    private final TypeElement clazz;
    private final ProcessingEnvironment processingEnv;
    private List<AltMethod> methods;
    private List<AltAnnotation> annotations;
    private static final Set<String> POSSIBLE_NO_HANDLE = new HashSet<String>(Arrays.asList("getClass", "hashCode", "equals", "toString", "notify", "notifyAll", "wait"));

    public TypeElementAltClassImpl(TypeElement clazz, ProcessingEnvironment processingEnv) {
        this.clazz = clazz;
        this.processingEnv = processingEnv;
    }

    @Override
    public String getName() {
        return Utilities.convertNameToString(this.processingEnv.getElementUtils().getBinaryName(this.clazz));
    }

    @Override
    public String getSimpleName() {
        return Utilities.convertNameToString(this.clazz.getSimpleName());
    }

    @Override
    public synchronized List<AltAnnotation> getAnnotations() {
        if (this.annotations != null) {
            return this.annotations;
        }
        List<? extends AnnotationMirror> annoMirrors = this.processingEnv.getElementUtils().getAllAnnotationMirrors(this.clazz);
        ArrayList<AnnotationMirrorAltAnnotationImpl> retVal = new ArrayList<AnnotationMirrorAltAnnotationImpl>(annoMirrors.size());
        for (AnnotationMirror annotationMirror : annoMirrors) {
            AnnotationMirrorAltAnnotationImpl anno = new AnnotationMirrorAltAnnotationImpl(annotationMirror, this.processingEnv);
            retVal.add(anno);
        }
        this.annotations = Collections.unmodifiableList(new ArrayList(retVal));
        return this.annotations;
    }

    private boolean isMethodToGenerate(Element element) {
        AltClass ac;
        TypeMirror param0;
        if (!ElementKind.METHOD.equals((Object)element.getKind())) {
            return false;
        }
        ExecutableElement executable = (ExecutableElement)element;
        String methodName = executable.getSimpleName().toString();
        if (!POSSIBLE_NO_HANDLE.contains(methodName)) {
            return true;
        }
        List<? extends TypeMirror> parameters = ((ExecutableType)executable.asType()).getParameterTypes();
        if (("getClass".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName) || "notify".equals(methodName) || "notifyAll".equals(methodName) || "wait".equals(methodName)) && parameters.size() == 0) {
            return false;
        }
        if ("equals".equals(methodName) && parameters.size() == 1) {
            param0 = parameters.get(0);
            ac = Utilities.convertTypeMirror(param0, this.processingEnv);
            if (Object.class.getName().equals(ac.getName())) {
                return false;
            }
        }
        if ("wait".equals(methodName) && parameters.size() == 1 && ClassAltClassImpl.LONG.equals(ac = Utilities.convertTypeMirror(param0 = parameters.get(0), this.processingEnv))) {
            return false;
        }
        if ("wait".equals(methodName) && parameters.size() == 2) {
            param0 = parameters.get(0);
            TypeMirror param1 = parameters.get(1);
            AltClass ac0 = Utilities.convertTypeMirror(param0, this.processingEnv);
            AltClass ac1 = Utilities.convertTypeMirror(param1, this.processingEnv);
            if (ClassAltClassImpl.LONG.equals(ac0) && ClassAltClassImpl.INT.equals(ac1)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized List<AltMethod> getMethods() {
        if (this.methods != null) {
            return this.methods;
        }
        List<? extends Element> innerElements = this.processingEnv.getElementUtils().getAllMembers(this.clazz);
        TreeMap<String, LinkedList<Element>> reorderByEnclosingClass = new TreeMap<String, LinkedList<Element>>();
        String clazzName = this.getName();
        for (Element element : innerElements) {
            if (!this.isMethodToGenerate(element)) continue;
            TypeElement typeElement = (TypeElement)element.getEnclosingElement();
            String enclosingName = Utilities.convertNameToString(this.processingEnv.getElementUtils().getBinaryName(typeElement));
            LinkedList<Element> addedList = (LinkedList<Element>)reorderByEnclosingClass.get(enclosingName);
            if (addedList == null) {
                addedList = new LinkedList<Element>();
                reorderByEnclosingClass.put(enclosingName, addedList);
            }
            addedList.add(element);
        }
        ArrayList innerElementsReordered = new ArrayList(innerElements.size());
        for (Map.Entry entry : reorderByEnclosingClass.entrySet()) {
            String enclosingClass = (String)entry.getKey();
            if (clazzName.equals(enclosingClass)) continue;
            innerElementsReordered.addAll((Collection)entry.getValue());
        }
        List list = (List)reorderByEnclosingClass.get(clazzName);
        if (list != null) {
            innerElementsReordered.addAll(list);
        }
        ArrayList<ElementAltMethodImpl> arrayList = new ArrayList<ElementAltMethodImpl>(innerElementsReordered.size());
        for (Element innerElementElement : innerElementsReordered) {
            arrayList.add(new ElementAltMethodImpl(innerElementElement, this.processingEnv));
        }
        this.methods = Collections.unmodifiableList(arrayList);
        return this.methods;
    }

    @Override
    public AltClass getSuperParameterizedType(AltClass superclass, int paramIndex) {
        if (paramIndex < 0) {
            return null;
        }
        String stopName = superclass.getName();
        TypeElement currentClass = this.clazz;
        while (currentClass != null) {
            String currentName = Utilities.convertNameToString(this.processingEnv.getElementUtils().getBinaryName(currentClass));
            TypeMirror superMirror = currentClass.getSuperclass();
            if (superMirror == null) {
                return null;
            }
            if (!(superMirror instanceof DeclaredType)) {
                return null;
            }
            DeclaredType superDeclared = (DeclaredType)superMirror;
            TypeElement nextClass = (TypeElement)superDeclared.asElement();
            String superName = Utilities.convertNameToString(this.processingEnv.getElementUtils().getBinaryName(nextClass));
            if (GeneralUtilities.safeEquals((Object)superName, (Object)stopName)) {
                List<? extends TypeMirror> genericParams = superDeclared.getTypeArguments();
                if (genericParams == null || genericParams.isEmpty()) {
                    throw new IllegalStateException("Class " + currentName + " which is a superclass of " + stopName + " does is not a parameterized type");
                }
                if (paramIndex >= genericParams.size()) {
                    throw new IllegalStateException("Class " + currentName + " which is a superclass of " + stopName + " does not have " + paramIndex + " types.  It only has " + genericParams.size());
                }
                TypeMirror tpe = genericParams.get(paramIndex);
                if (!(tpe instanceof DeclaredType)) {
                    return null;
                }
                DeclaredType retValDecl = (DeclaredType)tpe;
                TypeElement retValElement = (TypeElement)retValDecl.asElement();
                return new TypeElementAltClassImpl(retValElement, this.processingEnv);
            }
            currentClass = nextClass;
        }
        return null;
    }

    @Override
    public boolean isInterface() {
        return ElementKind.INTERFACE.equals((Object)this.clazz.getKind());
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public AltClass getComponentType() {
        return null;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof AltClass)) {
            return false;
        }
        AltClass oac = (AltClass)o;
        return GeneralUtilities.safeEquals((Object)oac.getName(), (Object)this.getName());
    }

    public String toString() {
        return "TypeElementAltClassImpl(" + this.clazz.getQualifiedName() + "," + System.identityHashCode(this) + ")";
    }
}

