/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.overlay.direct;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.beans.DiagnosticsBean;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.dynamic.overlay.ChangeDescriptor;
import org.glassfish.hk2.xml.test.dynamic.overlay.OverlayUtilities;
import org.glassfish.hk2.xml.test.dynamic.overlay.direct.DirectTerminalBean;
import org.glassfish.hk2.xml.test.dynamic.overlay.direct.DirectWithDirect;
import org.glassfish.hk2.xml.test.dynamic.overlay.direct.DirectWithKeyed;
import org.glassfish.hk2.xml.test.dynamic.overlay.direct.DirectWithUnkeyed;
import org.glassfish.hk2.xml.test.dynamic.overlay.direct.KeyedTerminalBean;
import org.glassfish.hk2.xml.test.dynamic.overlay.direct.OverlayRootBBean;
import org.glassfish.hk2.xml.test.dynamic.overlay.direct.UnkeyedTerminalBean;
import org.glassfish.hk2.xml.test.dynamic.rawsets.RawSetsTest;
import org.glassfish.hk2.xml.test.dynamic.rawsets.UpdateListener;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class OverlayDirectTest {
    private static final String TERMINAL_DATA_A = "terminalDataA";
    private static final String TERMINAL_DATA_B = "terminalDataB";
    public static final String DIRECT_WITH_KEYED = "direct-with-keyed";
    public static final String DIRECT_WITH_UNKEYED = "direct-with-unkeyed";
    public static final String DIRECT_WITH_DIRECT = "direct-with-direct";
    public static final String DIRECT_TERMINAL = "direct-terminal";
    public static final String TERMINAL_DATA = "terminal-data";
    public static final String UNKEYED_TERMINAL = "unkeyed-terminal";
    public static final String UNKEYED_DATA = "unkeyed-data";
    private static final String DIRECT_WITH_KEYED_TYPE = "/overlay-root-B/direct-with-keyed";
    private static final String DIRECT_WITH_UNKEYED_TYPE = "/overlay-root-B/direct-with-unkeyed";
    private static final String DIRECT_WITH_DIRECT_TYPE = "/overlay-root-B/direct-with-direct";
    private static final String DIRECT_WITH_DIRECT_TERMINAL_TYPE = "/overlay-root-B/direct-with-direct/direct-terminal";
    private static final String DIRECT_WITH_UNKEYED_TERMINAL_TYPE = "/overlay-root-B/direct-with-unkeyed/unkeyed-terminal";
    private static final String DIRECT_WITH_DIRECT_INSTANCE = "overlay-root-B.direct-with-direct";
    private static final String DIRECT_WITH_DIRECT_TERMINAL_INSTANCE = "overlay-root-B.direct-with-direct.direct-terminal";
    private static final String DIRECT_WITH_UNKEYED_INSTANCE = "overlay-root-B.direct-with-unkeyed";
    private static final String DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE = "overlay-root-B.direct-with-unkeyed.*";

    @Test
    public void testDirectWithDirectAdded() {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        XmlRootHandle<OverlayRootBBean> originalHandle = OverlayDirectTest.createEmptyRoot(xmlService, true);
        XmlRootHandle<OverlayRootBBean> modifiedHandle = OverlayDirectTest.createEmptyRoot(xmlService, false);
        OverlayDirectTest.checkEmptyRootInHub(hub, locator);
        OverlayRootBBean modifiedRoot = (OverlayRootBBean)modifiedHandle.getRoot();
        modifiedRoot.setDirectWithDirect((DirectWithDirect)xmlService.createBean(DirectWithDirect.class));
        DirectWithDirect dwd = modifiedRoot.getDirectWithDirect();
        dwd.setDirectTerminal((DirectTerminalBean)xmlService.createBean(DirectTerminalBean.class));
        DirectTerminalBean dtb = dwd.getDirectTerminal();
        dtb.setTerminalData(TERMINAL_DATA_A);
        originalHandle.overlay(modifiedHandle);
        OverlayRootBBean originalRoot = (OverlayRootBBean)originalHandle.getRoot();
        Assert.assertNotNull((Object)originalRoot.getDirectWithDirect());
        Assert.assertNull((Object)originalRoot.getDirectWithKeyed());
        Assert.assertNull((Object)originalRoot.getDirectWithUnkeyed());
        DirectWithDirect overlayDWD = originalRoot.getDirectWithDirect();
        DirectTerminalBean overlayDTB = overlayDWD.getDirectTerminal();
        Assert.assertNotNull((Object)overlayDTB);
        Assert.assertEquals((Object)TERMINAL_DATA_A, (Object)overlayDTB.getTerminalData());
        OverlayDirectTest.checkRootInHub(hub, locator);
        OverlayDirectTest.checkExists(hub, DIRECT_WITH_DIRECT_TYPE, DIRECT_WITH_DIRECT_INSTANCE, DirectWithDirect.class, locator);
        DirectTerminalBean service = OverlayDirectTest.checkExists(hub, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, DirectTerminalBean.class, locator);
        OverlayDirectTest.checkFieldInHub(hub, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, TERMINAL_DATA, TERMINAL_DATA_A);
        Assert.assertEquals((Object)TERMINAL_DATA_A, (Object)service.getTerminalData());
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_TYPE, DIRECT_WITH_DIRECT_TYPE, null, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, DIRECT_WITH_DIRECT_TYPE, DIRECT_WITH_DIRECT_INSTANCE, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_TYPE, DIRECT_WITH_DIRECT_TERMINAL_TYPE, null, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-B", "overlay-root-B", null, DIRECT_WITH_DIRECT));
    }

    @Test
    public void testDirectWithDirectRemoved() {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        XmlRootHandle<OverlayRootBBean> originalHandle = OverlayDirectTest.createEmptyRoot(xmlService, true);
        XmlRootHandle<OverlayRootBBean> modifiedHandle = OverlayDirectTest.createEmptyRoot(xmlService, false);
        OverlayRootBBean originalRoot = (OverlayRootBBean)originalHandle.getRoot();
        originalRoot.setDirectWithDirect((DirectWithDirect)xmlService.createBean(DirectWithDirect.class));
        DirectWithDirect dwd = originalRoot.getDirectWithDirect();
        dwd.setDirectTerminal((DirectTerminalBean)xmlService.createBean(DirectTerminalBean.class));
        DirectTerminalBean dtb = dwd.getDirectTerminal();
        dtb.setTerminalData(TERMINAL_DATA_A);
        OverlayDirectTest.checkRootInHub(hub, locator);
        OverlayDirectTest.checkExists(hub, DIRECT_WITH_DIRECT_TYPE, DIRECT_WITH_DIRECT_INSTANCE, DirectWithDirect.class, locator);
        DirectTerminalBean service = OverlayDirectTest.checkExists(hub, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, DirectTerminalBean.class, locator);
        OverlayDirectTest.checkFieldInHub(hub, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, TERMINAL_DATA, TERMINAL_DATA_A);
        Assert.assertEquals((Object)TERMINAL_DATA_A, (Object)service.getTerminalData());
        originalHandle.overlay(modifiedHandle);
        originalRoot = (OverlayRootBBean)originalHandle.getRoot();
        Assert.assertNull((Object)originalRoot.getDirectWithDirect());
        Assert.assertNull((Object)originalRoot.getDirectWithKeyed());
        Assert.assertNull((Object)originalRoot.getDirectWithUnkeyed());
        OverlayDirectTest.checkEmptyRootInHub(hub, locator);
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, DIRECT_WITH_DIRECT_TYPE, DIRECT_WITH_DIRECT_INSTANCE, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-B", "overlay-root-B", null, DIRECT_WITH_DIRECT));
    }

    @Test
    public void testDirectWithDirectChanged() {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        XmlRootHandle<OverlayRootBBean> originalHandle = OverlayDirectTest.createEmptyRoot(xmlService, true);
        XmlRootHandle<OverlayRootBBean> modifiedHandle = OverlayDirectTest.createEmptyRoot(xmlService, false);
        OverlayRootBBean originalRoot = (OverlayRootBBean)originalHandle.getRoot();
        originalRoot.setDirectWithDirect((DirectWithDirect)xmlService.createBean(DirectWithDirect.class));
        DirectWithDirect dwd = originalRoot.getDirectWithDirect();
        dwd.setDirectTerminal((DirectTerminalBean)xmlService.createBean(DirectTerminalBean.class));
        DirectTerminalBean dtb = dwd.getDirectTerminal();
        dtb.setTerminalData(TERMINAL_DATA_A);
        OverlayRootBBean modifiedRoot = (OverlayRootBBean)modifiedHandle.getRoot();
        modifiedRoot.setDirectWithDirect((DirectWithDirect)xmlService.createBean(DirectWithDirect.class));
        dwd = modifiedRoot.getDirectWithDirect();
        dwd.setDirectTerminal((DirectTerminalBean)xmlService.createBean(DirectTerminalBean.class));
        dtb = dwd.getDirectTerminal();
        dtb.setTerminalData(TERMINAL_DATA_B);
        OverlayDirectTest.checkRootInHub(hub, locator);
        OverlayDirectTest.checkExists(hub, DIRECT_WITH_DIRECT_TYPE, DIRECT_WITH_DIRECT_INSTANCE, DirectWithDirect.class, locator);
        DirectTerminalBean service = OverlayDirectTest.checkExists(hub, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, DirectTerminalBean.class, locator);
        OverlayDirectTest.checkFieldInHub(hub, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, TERMINAL_DATA, TERMINAL_DATA_A);
        Assert.assertEquals((Object)TERMINAL_DATA_A, (Object)service.getTerminalData());
        originalHandle.overlay(modifiedHandle);
        originalRoot = (OverlayRootBBean)originalHandle.getRoot();
        Assert.assertNotNull((Object)originalRoot.getDirectWithDirect());
        Assert.assertNull((Object)originalRoot.getDirectWithKeyed());
        Assert.assertNull((Object)originalRoot.getDirectWithUnkeyed());
        dwd = originalRoot.getDirectWithDirect();
        dtb = dwd.getDirectTerminal();
        Assert.assertNotNull((Object)dtb);
        Assert.assertEquals((Object)TERMINAL_DATA_B, (Object)dtb.getTerminalData());
        OverlayDirectTest.checkRootInHub(hub, locator);
        OverlayDirectTest.checkExists(hub, DIRECT_WITH_DIRECT_TYPE, DIRECT_WITH_DIRECT_INSTANCE, DirectWithDirect.class, locator);
        service = OverlayDirectTest.checkExists(hub, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, DirectTerminalBean.class, locator);
        OverlayDirectTest.checkFieldInHub(hub, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, TERMINAL_DATA, TERMINAL_DATA_B);
        Assert.assertEquals((Object)TERMINAL_DATA_B, (Object)service.getTerminalData());
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, DIRECT_WITH_DIRECT_TERMINAL_TYPE, DIRECT_WITH_DIRECT_TERMINAL_INSTANCE, null, TERMINAL_DATA));
    }

    @Test
    public void testDirectWithUnkeyedAdded() {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        XmlRootHandle<OverlayRootBBean> originalHandle = OverlayDirectTest.createEmptyRoot(xmlService, true);
        XmlRootHandle<OverlayRootBBean> modifiedHandle = OverlayDirectTest.createEmptyRoot(xmlService, false);
        OverlayDirectTest.checkEmptyRootInHub(hub, locator);
        OverlayRootBBean modifiedRoot = (OverlayRootBBean)modifiedHandle.getRoot();
        modifiedRoot.setDirectWithUnkeyed((DirectWithUnkeyed)xmlService.createBean(DirectWithUnkeyed.class));
        DirectWithUnkeyed dwu = modifiedRoot.getDirectWithUnkeyed();
        UnkeyedTerminalBean utb = dwu.addUnkeyedTerminal();
        utb.setUnkeyedData(TERMINAL_DATA_A);
        originalHandle.overlay(modifiedHandle);
        OverlayRootBBean originalRoot = (OverlayRootBBean)originalHandle.getRoot();
        Assert.assertNull((Object)originalRoot.getDirectWithDirect());
        Assert.assertNull((Object)originalRoot.getDirectWithKeyed());
        Assert.assertNotNull((Object)originalRoot.getDirectWithUnkeyed());
        DirectWithUnkeyed overlayDWU = originalRoot.getDirectWithUnkeyed();
        UnkeyedTerminalBean overlayUTB = overlayDWU.getUnkeyedTerminal().get(0);
        Assert.assertNotNull((Object)overlayUTB);
        Assert.assertEquals((Object)TERMINAL_DATA_A, (Object)overlayUTB.getUnkeyedData());
        OverlayDirectTest.checkRootInHub(hub, locator);
        OverlayDirectTest.checkExists(hub, DIRECT_WITH_UNKEYED_TYPE, DIRECT_WITH_UNKEYED_INSTANCE, DirectWithUnkeyed.class, locator);
        UnkeyedTerminalBean service = OverlayDirectTest.checkExists(hub, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, UnkeyedTerminalBean.class, locator);
        OverlayDirectTest.checkFieldInHub(hub, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, UNKEYED_DATA, TERMINAL_DATA_A);
        Assert.assertEquals((Object)TERMINAL_DATA_A, (Object)service.getUnkeyedData());
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_TYPE, DIRECT_WITH_UNKEYED_TYPE, null, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, DIRECT_WITH_UNKEYED_TYPE, DIRECT_WITH_UNKEYED_INSTANCE, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, null, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-B", "overlay-root-B", null, DIRECT_WITH_UNKEYED));
    }

    @Test
    public void testDirectWithUnkeyedChanged() {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        XmlRootHandle<OverlayRootBBean> originalHandle = OverlayDirectTest.createEmptyRoot(xmlService, true);
        XmlRootHandle<OverlayRootBBean> modifiedHandle = OverlayDirectTest.createEmptyRoot(xmlService, false);
        OverlayRootBBean originalRoot = (OverlayRootBBean)originalHandle.getRoot();
        originalRoot.setDirectWithUnkeyed((DirectWithUnkeyed)xmlService.createBean(DirectWithUnkeyed.class));
        DirectWithUnkeyed dwu = originalRoot.getDirectWithUnkeyed();
        UnkeyedTerminalBean utb = dwu.addUnkeyedTerminal();
        utb.setUnkeyedData(TERMINAL_DATA_A);
        OverlayRootBBean modifiedRoot = (OverlayRootBBean)modifiedHandle.getRoot();
        modifiedRoot.setDirectWithUnkeyed((DirectWithUnkeyed)xmlService.createBean(DirectWithUnkeyed.class));
        dwu = modifiedRoot.getDirectWithUnkeyed();
        utb = dwu.addUnkeyedTerminal();
        utb.setUnkeyedData(TERMINAL_DATA_B);
        OverlayDirectTest.checkRootInHub(hub, locator);
        OverlayDirectTest.checkExists(hub, DIRECT_WITH_UNKEYED_TYPE, DIRECT_WITH_UNKEYED_INSTANCE, DirectWithUnkeyed.class, locator);
        UnkeyedTerminalBean service = OverlayDirectTest.checkExists(hub, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, UnkeyedTerminalBean.class, locator);
        OverlayDirectTest.checkFieldInHub(hub, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, UNKEYED_DATA, TERMINAL_DATA_A);
        Assert.assertEquals((Object)TERMINAL_DATA_A, (Object)service.getUnkeyedData());
        originalHandle.overlay(modifiedHandle);
        originalRoot = (OverlayRootBBean)originalHandle.getRoot();
        Assert.assertNull((Object)originalRoot.getDirectWithDirect());
        Assert.assertNull((Object)originalRoot.getDirectWithKeyed());
        Assert.assertNotNull((Object)originalRoot.getDirectWithUnkeyed());
        dwu = originalRoot.getDirectWithUnkeyed();
        utb = dwu.getUnkeyedTerminal().get(0);
        Assert.assertNotNull((Object)utb);
        Assert.assertEquals((Object)TERMINAL_DATA_B, (Object)utb.getUnkeyedData());
        OverlayDirectTest.checkRootInHub(hub, locator);
        OverlayDirectTest.checkExists(hub, DIRECT_WITH_UNKEYED_TYPE, DIRECT_WITH_UNKEYED_INSTANCE, DirectWithUnkeyed.class, locator);
        service = OverlayDirectTest.checkExists(hub, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, UnkeyedTerminalBean.class, locator);
        OverlayDirectTest.checkFieldInHub(hub, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, UNKEYED_DATA, TERMINAL_DATA_B);
        Assert.assertEquals((Object)TERMINAL_DATA_B, (Object)service.getUnkeyedData());
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, null, UNKEYED_DATA));
    }

    @Test
    public void testDirectWithUnkeyedRemoved() {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        XmlRootHandle<OverlayRootBBean> originalHandle = OverlayDirectTest.createEmptyRoot(xmlService, true);
        XmlRootHandle<OverlayRootBBean> modifiedHandle = OverlayDirectTest.createEmptyRoot(xmlService, false);
        OverlayRootBBean originalRoot = (OverlayRootBBean)originalHandle.getRoot();
        originalRoot.setDirectWithUnkeyed((DirectWithUnkeyed)xmlService.createBean(DirectWithUnkeyed.class));
        DirectWithUnkeyed dwu = originalRoot.getDirectWithUnkeyed();
        UnkeyedTerminalBean utb = dwu.addUnkeyedTerminal();
        utb.setUnkeyedData(TERMINAL_DATA_A);
        OverlayDirectTest.checkRootInHub(hub, locator);
        OverlayDirectTest.checkExists(hub, DIRECT_WITH_UNKEYED_TYPE, DIRECT_WITH_UNKEYED_INSTANCE, DirectWithUnkeyed.class, locator);
        UnkeyedTerminalBean service = OverlayDirectTest.checkExists(hub, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, UnkeyedTerminalBean.class, locator);
        OverlayDirectTest.checkFieldInHub(hub, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, UNKEYED_DATA, TERMINAL_DATA_A);
        Assert.assertEquals((Object)TERMINAL_DATA_A, (Object)service.getUnkeyedData());
        originalHandle.overlay(modifiedHandle);
        originalRoot = (OverlayRootBBean)originalHandle.getRoot();
        Assert.assertNull((Object)originalRoot.getDirectWithDirect());
        Assert.assertNull((Object)originalRoot.getDirectWithKeyed());
        Assert.assertNull((Object)originalRoot.getDirectWithUnkeyed());
        OverlayDirectTest.checkEmptyRootInHub(hub, locator);
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, DIRECT_WITH_UNKEYED_TYPE, DIRECT_WITH_UNKEYED_INSTANCE, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, DIRECT_WITH_UNKEYED_TERMINAL_TYPE, DIRECT_WITH_UNKEYED_TERMINAL_INSTANCE, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-B", "overlay-root-B", null, DIRECT_WITH_UNKEYED));
    }

    @Test
    public void testChangeKeyedDirectChildWithOverlay() {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        XmlRootHandle rootHandle1 = xmlService.createEmptyHandle(DomainBean.class);
        rootHandle1.addRoot();
        DomainBean domain1 = (DomainBean)rootHandle1.getRoot();
        DiagnosticsBean aliceBean = RawSetsTest.createDiagnosticsBean(xmlService, "Alice");
        domain1.setDiagnostics(aliceBean);
        XmlRootHandle rootHandle2 = xmlService.createEmptyHandle(DomainBean.class, false, false);
        rootHandle2.addRoot();
        DomainBean domain2 = (DomainBean)rootHandle2.getRoot();
        DiagnosticsBean bobBean = RawSetsTest.createDiagnosticsBean(xmlService, "Bob");
        domain2.setDiagnostics(bobBean);
        DiagnosticsBean checkBean = OverlayDirectTest.checkExists(hub, "/domain/diagnostics", "domain.Alice", DiagnosticsBean.class, locator);
        Assert.assertEquals((Object)"Alice", (Object)checkBean.getName());
        OverlayDirectTest.checkNotExistsInHub(hub, "/domain/diagnostics", "domain.Bob");
        rootHandle1.overlay(rootHandle2);
        OverlayDirectTest.checkNotExistsInHub(hub, "/domain/diagnostics", "domain.Alice");
        checkBean = OverlayDirectTest.checkExists(hub, "/domain/diagnostics", "domain.Bob", DiagnosticsBean.class, locator);
        Assert.assertEquals((Object)"Bob", (Object)checkBean.getName());
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/domain/diagnostics", "domain.Alice", "Alice", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/domain/diagnostics", "domain.Bob", "Bob", new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/domain", "domain", null, "diagnostics"));
    }

    private static XmlRootHandle<OverlayRootBBean> createEmptyRoot(XmlService xmlService, boolean advertise) {
        XmlRootHandle retVal = xmlService.createEmptyHandle(OverlayRootBBean.class, advertise, advertise);
        retVal.addRoot();
        return retVal;
    }

    private static void checkExistsInHub(Hub hub, String type, String instance) {
        BeanDatabase bd = hub.getCurrentDatabase();
        Type hubType = bd.getType(type);
        Assert.assertNotNull((Object)hubType);
        Instance i = null;
        if (instance.contains(".*")) {
            Map instances = hubType.getInstances();
            Assert.assertEquals((long)1L, (long)instances.size());
            Iterator iterator = instances.values().iterator();
            while (iterator.hasNext()) {
                Instance found;
                i = found = (Instance)iterator.next();
            }
        } else {
            i = hubType.getInstance(instance);
        }
        Assert.assertNotNull((String)("Could not find instance " + instance + " in type " + type), (Object)i);
        Object bean = i.getBean();
        Assert.assertNotNull((Object)bean);
    }

    private static <T> T checkExists(Hub hub, String type, String instance, Class<T> serviceClazz, ServiceLocator locator) {
        OverlayDirectTest.checkExistsInHub(hub, type, instance);
        Object retVal = locator.getService(serviceClazz, new Annotation[0]);
        Assert.assertNotNull((Object)retVal);
        return (T)retVal;
    }

    private static void checkFieldInHub(Hub hub, String type, String instance, String field, Object value) {
        BeanDatabase bd = hub.getCurrentDatabase();
        Type hubType = bd.getType(type);
        Assert.assertNotNull((Object)hubType);
        Instance i = null;
        if (instance.contains(".*")) {
            Map instances = hubType.getInstances();
            Assert.assertEquals((long)1L, (long)instances.size());
            Iterator iterator = instances.values().iterator();
            while (iterator.hasNext()) {
                Instance found;
                i = found = (Instance)iterator.next();
            }
        } else {
            i = hubType.getInstance(instance);
        }
        Assert.assertNotNull((Object)i);
        Map bean = (Map)i.getBean();
        Assert.assertNotNull((Object)bean);
        Object checkedValue = bean.get(field);
        Assert.assertTrue((boolean)GeneralUtilities.safeEquals((Object)value, checkedValue));
    }

    private static void checkNotExistsInHub(Hub hub, String type, String instance) {
        BeanDatabase bd = hub.getCurrentDatabase();
        Type hubType = bd.getType(type);
        if (hubType == null) {
            return;
        }
        if (instance == null) {
            Assert.assertEquals((long)0L, (long)hubType.getInstances().size());
            return;
        }
        Instance i = hubType.getInstance(instance);
        Assert.assertNull((Object)i);
    }

    private static void checkRootInHub(Hub hub, ServiceLocator locator) {
        OverlayDirectTest.checkExists(hub, "/overlay-root-B", "overlay-root-B", OverlayRootBBean.class, locator);
    }

    private static void checkEmptyRootInHub(Hub hub, ServiceLocator locator) {
        OverlayDirectTest.checkRootInHub(hub, locator);
        OverlayDirectTest.checkNotExistsInHub(hub, DIRECT_WITH_KEYED_TYPE, null);
        OverlayDirectTest.checkNotExistsInHub(hub, DIRECT_WITH_UNKEYED_TYPE, null);
        OverlayDirectTest.checkNotExistsInHub(hub, DIRECT_WITH_DIRECT_TYPE, DIRECT_WITH_DIRECT_INSTANCE);
        Assert.assertNull((Object)locator.getService(DirectWithKeyed.class, new Annotation[0]));
        Assert.assertNull((Object)locator.getService(DirectWithUnkeyed.class, new Annotation[0]));
        Assert.assertNull((Object)locator.getService(DirectWithDirect.class, new Annotation[0]));
        Assert.assertNull((Object)locator.getService(KeyedTerminalBean.class, new Annotation[0]));
        Assert.assertNull((Object)locator.getService(UnkeyedTerminalBean.class, new Annotation[0]));
        Assert.assertNull((Object)locator.getService(DirectTerminalBean.class, new Annotation[0]));
    }
}

