/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.overlay;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.beans.Museum;
import org.glassfish.hk2.xml.test.dynamic.overlay.ChangeDescriptor;
import org.glassfish.hk2.xml.test.dynamic.overlay.OverlayRootABean;
import org.glassfish.hk2.xml.test.dynamic.overlay.OverlayUtilities;
import org.glassfish.hk2.xml.test.dynamic.rawsets.RawSetsTest;
import org.glassfish.hk2.xml.test.dynamic.rawsets.UpdateListener;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class OverlayTest {
    @Test
    public void testRootBeanOnlyOverlay() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Museum.class);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        URL url2 = this.getClass().getClassLoader().getResource("museum2.xml");
        XmlRootHandle rootHandle2 = xmlService.unmarshal(url2.toURI(), Museum.class, false, false);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        Museum museum = (Museum)rootHandle.getRoot();
        XmlHk2ConfigurationBean museumAsBean = (XmlHk2ConfigurationBean)museum;
        rootHandle.overlay(rootHandle2);
        Assert.assertEquals((long)101L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)101L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance("/museum", "museum");
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)101, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get("age"));
        List<Change> changes = listener.getChanges();
        Assert.assertNotNull(changes);
        Assert.assertEquals((long)1L, (long)changes.size());
        Change oneChange = null;
        for (Change change : changes) {
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
            oneChange = change;
        }
    }

    private List<Change> doTestA(String original, String overlay) {
        return this.doTestA(original, overlay, true, true);
    }

    private List<Change> doTestA(String original, String overlay, boolean generateLists, boolean generateArrays) {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        XmlRootHandle originalHandle = xmlService.createEmptyHandle(OverlayRootABean.class, true, true);
        OverlayUtilities.generateOverlayRootABean((XmlRootHandle<OverlayRootABean>)originalHandle, generateLists, generateArrays, original);
        String originalFromList = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)originalHandle.getRoot(), true);
        String originalFromArray = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)originalHandle.getRoot(), false);
        if (generateLists) {
            Assert.assertEquals((Object)original, (Object)originalFromList);
        }
        if (generateArrays) {
            Assert.assertEquals((Object)original, (Object)originalFromArray);
        }
        OverlayUtilities.checkSingleLetterOveralyRootA((XmlRootHandle<OverlayRootABean>)originalHandle, hub, generateLists, generateArrays, original);
        XmlRootHandle overlayHandle = xmlService.createEmptyHandle(OverlayRootABean.class, false, false);
        OverlayUtilities.generateOverlayRootABean((XmlRootHandle<OverlayRootABean>)overlayHandle, generateLists, generateArrays, overlay);
        String overlayFromList = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)overlayHandle.getRoot(), true);
        String overlayFromArray = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)overlayHandle.getRoot(), false);
        if (generateLists) {
            Assert.assertEquals((Object)overlay, (Object)overlayFromList);
        }
        if (generateArrays) {
            Assert.assertEquals((Object)overlay, (Object)overlayFromArray);
        }
        OverlayUtilities.checkSingleLetterOveralyRootA((XmlRootHandle<OverlayRootABean>)originalHandle, hub, generateLists, generateArrays, original);
        originalHandle.overlay(overlayHandle);
        String overlayedFromList = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)originalHandle.getRoot(), true);
        String overlayedFromArray = OverlayUtilities.getStringVersionOfTree((OverlayRootABean)originalHandle.getRoot(), false);
        if (generateLists) {
            Assert.assertEquals((Object)overlay, (Object)overlayedFromList);
        }
        if (generateArrays) {
            Assert.assertEquals((Object)overlay, (Object)overlayedFromArray);
        }
        OverlayUtilities.checkSingleLetterOveralyRootA((XmlRootHandle<OverlayRootABean>)originalHandle, hub, generateLists, generateArrays, overlay);
        return listener.getChanges();
    }

    @Test
    public void testABCxBC() throws Exception {
        List<Change> changes = this.doTestA("ABC", "BC");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"));
    }

    @Test
    public void testABCxAB() throws Exception {
        List<Change> changes = this.doTestA("ABC", "AB");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "C", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "C", new String[0]));
    }

    @Test
    public void testABCxCBA() throws Exception {
        List<Change> changes = this.doTestA("ABC", "CBA");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"));
    }

    @Test
    public void testABCxBCA() throws Exception {
        List<Change> changes = this.doTestA("ABC", "BCA");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"));
    }

    @Test
    public void testABCxABCD() throws Exception {
        List<Change> changes = this.doTestA("ABC", "ABCD");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "D", new String[0]));
    }

    @Test
    public void testABCxCABC() throws Exception {
        List<Change> changes = this.doTestA("ABC", "CABC");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "C", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "C", new String[0]));
    }

    @Test
    public void testABCxABDC() throws Exception {
        List<Change> changes = this.doTestA("ABC", "ABDC");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "D", new String[0]));
    }

    @Test
    public void testABCxABC() throws Exception {
        List<Change> changes = this.doTestA("ABC", "ABC");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor[0]);
    }

    @Test
    public void testABCxABD() throws Exception {
        List<Change> changes = this.doTestA("ABC", "ABD");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "C", "name"), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "C", "name"));
    }

    @Test
    public void testAxABC() throws Exception {
        List<Change> changes = this.doTestA("A", "ABC");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "B", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "C", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "B", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "C", new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"));
    }

    @Test
    public void testA_B_A_C_A_D_xA_B_A_C_A_D_() throws Exception {
        List<Change> changes = this.doTestA("A(B)A(C)A(D)", "A(B)A(C)A(D)");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor[0]);
    }

    @Test
    public void testA_B_A_C_A_D_xA_B_A_C_() throws Exception {
        List<Change> changes = this.doTestA("A(B)A(C)A(D)", "A(B)A(C)");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-list", "overlay-root-A.*.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-array", "overlay-root-A.*.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-list", "overlay-root-A.*.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array", "overlay-root-A.*.*", "D", new String[0]));
    }

    @Test
    public void testA_B_A_CxA_C_A_B_() throws Exception {
        List<Change> changes = this.doTestA("A(B)A(C)", "A(C)A(B)");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"));
    }

    @Test
    public void testA_B_A_C_A_D_xA_C_A_D_() throws Exception {
        List<Change> changes = this.doTestA("A(B)A(C)A(D)", "A(C)A(D)");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-list", "overlay-root-A.*.*", "B", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-array", "overlay-root-A.*.*", "B", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-list", "overlay-root-A.*", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array", "overlay-root-A.*", "A", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-list", "overlay-root-A.*.*", "B", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array", "overlay-root-A.*.*", "B", new String[0]));
    }

    @Test
    public void testA_B_C_D_EF__G_HI_JKL__xA_B_C_D_EF__G_HI_JKL__() throws Exception {
        List<Change> changes = this.doTestA("A(B(C)D(EF))G(HI(JKL))", "A(B(C)D(EF))G(HI(JKL))");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor[0]);
    }

    @Test
    public void testA_B_C_D_EF__G_HI_JKL__xG_HI_JKL__A_B_C_D_EF__() throws Exception {
        List<Change> changes = this.doTestA("A(B(C)D(EF))G(HI(JKL))", "G(HI(JKL))A(B(C)D(EF))");
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A", "overlay-root-A", null, "unkeyed-leaf-list", "unkeyed-leaf-array"));
    }

    @Test
    public void testListA_B_C__xA_B_CD_E___() throws Exception {
        List<Change> changes = this.doTestA("A(B(C))", "A(B(CD(E)))", true, false);
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-list/leaf-list", "overlay-root-A.*.*.*", "D", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_TYPE, "/overlay-root-A/unkeyed-leaf-list/leaf-list/leaf-list/leaf-list", null, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-list/leaf-list/leaf-list", "overlay-root-A.*.*.*.*", "E", new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A/unkeyed-leaf-list/leaf-list", "overlay-root-A.*.*", null, "leaf-list"));
    }

    @Test
    public void testArrayA_B_C__xA_B_CD_E___() throws Exception {
        List<Change> changes = this.doTestA("A(B(C))", "A(B(CD(E)))", false, true);
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array/leaf-array", "overlay-root-A.*.*.*", null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_TYPE, "/overlay-root-A/unkeyed-leaf-array/leaf-array/leaf-array/leaf-array", null, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array/leaf-array/leaf-array", "overlay-root-A.*.*.*.*", null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/overlay-root-A/unkeyed-leaf-array/leaf-array", "overlay-root-A.*.*", null, "leaf-array"));
    }
}

