/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.basic.beans;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.lifecycle.config.Association;
import org.glassfish.hk2.xml.lifecycle.config.Associations;
import org.glassfish.hk2.xml.lifecycle.config.Environment;
import org.glassfish.hk2.xml.lifecycle.config.LifecycleConfig;
import org.glassfish.hk2.xml.lifecycle.config.Partition;
import org.glassfish.hk2.xml.lifecycle.config.Runtime;
import org.glassfish.hk2.xml.lifecycle.config.Runtimes;
import org.glassfish.hk2.xml.lifecycle.config.Service;
import org.glassfish.hk2.xml.lifecycle.config.Tenant;
import org.glassfish.hk2.xml.test.basic.beans.AboveBean;
import org.glassfish.hk2.xml.test.basic.beans.BackwardTiesBean;
import org.glassfish.hk2.xml.test.basic.beans.BelowBean;
import org.glassfish.hk2.xml.test.basic.beans.Employee;
import org.glassfish.hk2.xml.test.basic.beans.Employees;
import org.glassfish.hk2.xml.test.basic.beans.EverythingBagel;
import org.glassfish.hk2.xml.test.basic.beans.Financials;
import org.glassfish.hk2.xml.test.basic.beans.FooBarBean;
import org.glassfish.hk2.xml.test.basic.beans.GreekEnum;
import org.glassfish.hk2.xml.test.basic.beans.Museum;
import org.glassfish.hk2.xml.test.basic.beans.OtherData;
import org.glassfish.hk2.xml.test.basic.beans.PropertyBean;
import org.glassfish.hk2.xml.test.basic.beans.ReferenceMaster;
import org.glassfish.hk2.xml.test.basic.beans.RootBeanWithProperties;
import org.glassfish.hk2.xml.test.basic.beans.RootWithCycle;
import org.glassfish.hk2.xml.test.basic.beans.TiesBean;
import org.glassfish.hk2.xml.test.basic.beans.TypeBean;
import org.junit.Assert;

public class Commons {
    public static final String MUSEUM1_FILE = "museum1.xml";
    public static final String ACME1_FILE = "Acme1.xml";
    public static final String ACME2_FILE = "Acme2.xml";
    public static final String SAMPLE_CONFIG_FILE = "sample-config.xml";
    public static final String CYCLE_FILE = "cycle.xml";
    public static final String TYPE1_FILE = "type1.xml";
    public static final String FOOBAR_FILE = "foobar.xml";
    public static final String REFERENCE1_FILE = "reference1.xml";
    public static final String ROOT_BEAN_WITH_PROPERTIES = "xmljavatypeadapter/root-bean-with-properties.xml";
    public static final String BEN_FRANKLIN = "Ben Franklin";
    public static final String ACME = "Acme";
    public static final String ALICE = "Alice";
    public static final String BOB = "Bob";
    public static final String CAROL = "Carol";
    public static final String DAVE = "Dave";
    public static final String ENGLEBERT = "Englebert";
    public static final String FRANK = "Frank";
    public static final String ACME_SYMBOL = "acme";
    public static final String NYSE = "NYSE";
    private static final String COKE_TENANT = "coke";
    private static final String HRPROD_SERVICE = "HRProd";
    public static final String FINANCIALS_TYPE = "/employees/financials";
    public static final String FINANCIALS_INSTANCE = "employees.financials";
    public static final String EMPLOYEES_TYPE = "/employees";
    public static final String EMPLOYEES_INSTANCE_NAME = "employees";
    public static final String EMPLOYEE_TYPE = "/employees/employee";
    public static final String DAVE_EMPLOYEE_INSTANCE = "employees.Dave";
    public static final int HUNDRED_INT = 100;
    public static final int HUNDRED_TEN_INT = 110;
    public static final long HUNDRED_LONG = 100L;
    public static final long HUNDRED_ONE_LONG = 101L;
    public static final String COMPANY_NAME_TAG = "company-name";
    public static final String EMPLOYEE_TAG = "employee";
    public static final String NAME_TAG = "name";
    public static final String ID_TAG = "id";
    private static final String COKE_ENV = "cokeenv";
    public static final String SYMBOL_TAG = "symbol";
    public static final String EXCHANGE_TAG = "exchange";
    public static final String NON_KEY_TAG = "non-key-identifier";
    public static final String PORT_TAG = "port";
    public static final String PUBLIC_KEY_TAG = "public-key-location";
    public static final String TYPES_FILE = "types/types.xml";
    private static final String LIFECYCLE_ROOT_TYPE = "/lifecycle-config";
    private static final String LIFECYCLE_ROOT_INSTANCE = "lifecycle-config";
    private static final String LIFECYCLE_RUNTIMES_TYPE = "/lifecycle-config/runtimes";
    private static final String LIFECYCLE_RUNTIMES_INSTANCE = "lifecycle-config.runtimes";
    private static final String LIFECYCLE_TENANTS_TYPE = "/lifecycle-config/tenants";
    private static final String LIFECYCLE_TENANTS_INSTANCE = "lifecycle-config.tenants";
    private static final String LIFECYCLE_ENVIRONMENTS_TYPE = "/lifecycle-config/environments";
    private static final String LIFECYCLE_ENVIRONMENTS_INSTANCE = "lifecycle-config.environments";
    private static final String LIFECYCLE_RUNTIME_TYPE = "/lifecycle-config/runtimes/runtime";
    private static final String LIFECYCLE_RUNTIME_wlsRuntime_INSTANCE = "lifecycle-config.runtimes.wlsRuntime";
    private static final String LIFECYCLE_RUNTIME_DatabaseTestRuntime_INSTANCE = "lifecycle-config.runtimes.DatabaseTestRuntime";
    private static final String WLS_RUNTIME_NAME = "wlsRuntime";
    private static final String ASSOCIATION_TYPE = "/lifecycle-config/environments/environment/associations/association";
    private static final String ASSOCIATION_INSTANCE_PREFIX = "lifecycle-config.environments.cokeenv.associations.";
    private static final String FOOBAR_ROOT_TYPE = "/foobar";
    private static final String FOOBAR_ROOT_INSTANCE = "foobar";
    private static final String FOOBAR_FOO_TYPE = "/foobar/foo";
    private static final String FOOBAR_FOO1_INSTANCE = "foobar.foo1";
    private static final String FOOBAR_FOO2_INSTANCE = "foobar.foo2";
    private static final String FOOBAR_BAR_TYPE = "/foobar/bar";
    private static final String FOOBAR_BAR1_INSTANCE = "foobar.bar1";
    private static final String FOOBAR_BAR2_INSTANCE = "foobar.bar2";
    private static final String NO_LEADING_OR_TRAILING = "Had leading and trailing whitespace";

    private Commons() {
    }

    public static void testInterfaceJaxbUnmarshalling(ServiceLocator locator, URI uri) throws Exception {
        Commons.testInterfaceJaxbUnmarshalling(locator, uri, null, null);
    }

    public static void testInterfaceJaxbUnmarshalling(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testInterfaceJaxbUnmarshalling(locator, null, reader, null);
    }

    public static void testInterfaceJaxbUnmarshalling(ServiceLocator locator, InputStream stream) throws Exception {
        Commons.testInterfaceJaxbUnmarshalling(locator, null, null, stream);
    }

    private static void testInterfaceJaxbUnmarshalling(ServiceLocator locator, URI uri, XMLStreamReader reader, InputStream is) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, Museum.class) : (is != null ? xmlService.unmarshal(is, Museum.class) : xmlService.unmarshal(reader, Museum.class, true, true));
        Museum museum = (Museum)rootHandle.getRoot();
        Assert.assertEquals((long)100L, (long)museum.getId());
        Assert.assertEquals((Object)BEN_FRANKLIN, (Object)museum.getName());
        Assert.assertEquals((long)110L, (long)museum.getAge());
        Museum asService = (Museum)locator.getService(Museum.class, new Annotation[0]);
        Assert.assertNotNull((Object)asService);
        Assert.assertEquals((Object)museum, (Object)asService);
    }

    public static void testBeanLikeMapOfInterface(ServiceLocator locator, URI uri) throws Exception {
        Commons.testBeanLikeMapOfInterface(locator, uri, null);
    }

    public static void testBeanLikeMapOfInterface(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testBeanLikeMapOfInterface(locator, null, reader);
    }

    private static void testBeanLikeMapOfInterface(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, Employees.class) : xmlService.unmarshal(reader, Employees.class, true, true);
        Employees employees = (Employees)rootHandle.getRoot();
        Assert.assertTrue((boolean)(employees instanceof XmlHk2ConfigurationBean));
        XmlHk2ConfigurationBean hk2Configuration = (XmlHk2ConfigurationBean)employees;
        Map beanLikeMap = hk2Configuration._getBeanLikeMap();
        Assert.assertEquals((Object)ACME, beanLikeMap.get(COMPANY_NAME_TAG));
        List employeeChildList = (List)beanLikeMap.get(EMPLOYEE_TAG);
        Assert.assertNotNull((Object)employeeChildList);
        Assert.assertEquals((long)2L, (long)employeeChildList.size());
        boolean first = true;
        for (Employee employee : employeeChildList) {
            Assert.assertTrue((boolean)(employee instanceof XmlHk2ConfigurationBean));
            XmlHk2ConfigurationBean employeeConfiguration = (XmlHk2ConfigurationBean)employee;
            Map employeeBeanLikeMap = employeeConfiguration._getBeanLikeMap();
            if (first) {
                first = false;
                Assert.assertEquals((Object)100L, employeeBeanLikeMap.get(ID_TAG));
                Assert.assertEquals((Object)BOB, employeeBeanLikeMap.get(NAME_TAG));
                continue;
            }
            Assert.assertEquals((Object)101L, employeeBeanLikeMap.get(ID_TAG));
            Assert.assertEquals((Object)CAROL, employeeBeanLikeMap.get(NAME_TAG));
        }
        Assert.assertNotNull((Object)locator.getService(Employees.class, new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(Employee.class, BOB, new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(Employee.class, CAROL, new Annotation[0]));
    }

    public static void testInterfaceJaxbUnmarshallingWithChildren(ServiceLocator locator, URI uri) throws Exception {
        Commons.testInterfaceJaxbUnmarshallingWithChildren(locator, uri, null);
    }

    public static void testInterfaceJaxbUnmarshallingWithChildren(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testInterfaceJaxbUnmarshallingWithChildren(locator, null, reader);
    }

    private static void testInterfaceJaxbUnmarshallingWithChildren(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, Employees.class) : xmlService.unmarshal(reader, Employees.class, true, true);
        Employees employees = (Employees)rootHandle.getRoot();
        Assert.assertEquals((Object)ACME, (Object)employees.getCompanyName());
        Assert.assertEquals((long)2L, (long)employees.getEmployees().size());
        boolean first = true;
        for (Employee employee : employees.getEmployees()) {
            if (first) {
                first = false;
                Assert.assertEquals((long)100L, (long)employee.getId());
                Assert.assertEquals((Object)BOB, (Object)employee.getName());
                continue;
            }
            Assert.assertEquals((long)101L, (long)employee.getId());
            Assert.assertEquals((Object)CAROL, (Object)employee.getName());
        }
        Financials financials = employees.getFinancials();
        Assert.assertNotNull((Object)financials);
        Assert.assertEquals((Object)ACME_SYMBOL, (Object)financials.getSymbol());
        Assert.assertEquals((Object)NYSE, (Object)financials.getExchange());
        Assert.assertEquals(Employees.class, (Object)rootHandle.getRootClass());
        if (uri != null) {
            Assert.assertEquals((Object)uri, (Object)rootHandle.getURI());
        } else {
            Assert.assertNull((Object)rootHandle.getURI());
        }
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FINANCIALS_TYPE, FINANCIALS_INSTANCE));
    }

    public static void testComplexUnmarshalling(ServiceLocator locator, URI uri) throws Exception {
        Commons.testComplexUnmarshalling(locator, uri, null);
    }

    public static void testComplexUnmarshalling(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testComplexUnmarshalling(locator, null, reader);
    }

    private static void testComplexUnmarshalling(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, LifecycleConfig.class) : xmlService.unmarshal(reader, LifecycleConfig.class, true, true);
        LifecycleConfig lifecycleConfig = (LifecycleConfig)rootHandle.getRoot();
        Assert.assertNotNull((Object)lifecycleConfig);
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_ROOT_TYPE, LIFECYCLE_ROOT_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_RUNTIMES_TYPE, LIFECYCLE_RUNTIMES_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_TENANTS_TYPE, LIFECYCLE_TENANTS_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_ENVIRONMENTS_TYPE, LIFECYCLE_ENVIRONMENTS_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_RUNTIME_TYPE, LIFECYCLE_RUNTIME_wlsRuntime_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(LIFECYCLE_RUNTIME_TYPE, LIFECYCLE_RUNTIME_DatabaseTestRuntime_INSTANCE));
        Tenant tenant = (Tenant)locator.getService(Tenant.class, COKE_TENANT, new Annotation[0]);
        Assert.assertNotNull((Object)tenant);
        Service hrProdService = tenant.lookupService(HRPROD_SERVICE);
        Assert.assertNotNull((Object)hrProdService);
        Assert.assertEquals((Object)HRPROD_SERVICE, (Object)hrProdService.getName());
    }

    public static void testUnkeyedChildren(ServiceLocator locator, URI uri) throws Exception {
        Commons.testUnkeyedChildren(locator, uri, null);
    }

    public static void testUnkeyedChildren(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testUnkeyedChildren(locator, null, reader);
    }

    private static void testUnkeyedChildren(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, LifecycleConfig.class) : xmlService.unmarshal(reader, LifecycleConfig.class, true, true);
        LifecycleConfig lifecycleConfig = (LifecycleConfig)rootHandle.getRoot();
        Assert.assertNotNull((Object)lifecycleConfig);
        Environment cokeEnv = (Environment)locator.getService(Environment.class, COKE_ENV, new Annotation[0]);
        Assert.assertNotNull((Object)cokeEnv);
        Associations associations = cokeEnv.getAssociations();
        Assert.assertNotNull((Object)associations);
        String generatedKey1 = null;
        String generatedKey2 = null;
        for (Association association : associations.getAssociations()) {
            XmlHk2ConfigurationBean bean = (XmlHk2ConfigurationBean)association;
            Assert.assertNull((Object)bean._getKeyPropertyName());
            if (generatedKey1 == null) {
                generatedKey1 = bean._getKeyValue();
                continue;
            }
            if (generatedKey2 == null) {
                generatedKey2 = bean._getKeyValue();
                continue;
            }
            Assert.fail((String)"Should only have been two associations, but we found at least three");
        }
        Assert.assertNotNull(generatedKey1);
        Assert.assertNotNull(generatedKey2);
        Assert.assertNotEquals(generatedKey1, generatedKey2);
        String association0_instance_name = ASSOCIATION_INSTANCE_PREFIX + generatedKey1;
        String association1_instance_name = ASSOCIATION_INSTANCE_PREFIX + generatedKey2;
        Instance as_0 = hub.getCurrentDatabase().getInstance(ASSOCIATION_TYPE, association0_instance_name);
        Instance as_1 = hub.getCurrentDatabase().getInstance(ASSOCIATION_TYPE, association1_instance_name);
        Assert.assertNotNull((Object)as_0);
        Assert.assertNotNull((Object)as_1);
    }

    public static void testSameClassTwoChildren(ServiceLocator locator, URI uri) throws Exception {
        Commons.testSameClassTwoChildren(locator, uri, null);
    }

    public static void testSameClassTwoChildren(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testSameClassTwoChildren(locator, null, reader);
    }

    private static void testSameClassTwoChildren(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, FooBarBean.class) : xmlService.unmarshal(reader, FooBarBean.class, true, true);
        FooBarBean foobar = (FooBarBean)rootHandle.getRoot();
        Assert.assertNotNull((Object)foobar);
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FOOBAR_ROOT_TYPE, FOOBAR_ROOT_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FOOBAR_FOO_TYPE, FOOBAR_FOO1_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FOOBAR_FOO_TYPE, FOOBAR_FOO2_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FOOBAR_BAR_TYPE, FOOBAR_BAR1_INSTANCE));
        Assert.assertNotNull((Object)hub.getCurrentDatabase().getInstance(FOOBAR_BAR_TYPE, FOOBAR_BAR2_INSTANCE));
    }

    public static void testBeanCycle(ServiceLocator locator, URI uri) throws Exception {
        Commons.testBeanCycle(locator, uri, null);
    }

    public static void testBeanCycle(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testBeanCycle(locator, null, reader);
    }

    private static void testBeanCycle(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, RootWithCycle.class) : xmlService.unmarshal(reader, RootWithCycle.class, true, true);
        RootWithCycle cycle = (RootWithCycle)rootHandle.getRoot();
        Assert.assertNotNull((Object)cycle);
        Assert.assertNotNull((Object)cycle.getLeafWithCycle());
        Assert.assertNotNull((Object)cycle.getLeafWithCycle().getRootWithCycle());
        Assert.assertNull((Object)cycle.getLeafWithCycle().getRootWithCycle().getLeafWithCycle());
    }

    public static void testEveryType(ServiceLocator locator, URI uri) throws Exception {
        Commons.testEveryType(locator, uri, null);
    }

    public static void testEveryType(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testEveryType(locator, null, reader);
    }

    private static void testEveryType(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, TypeBean.class) : xmlService.unmarshal(reader, TypeBean.class, true, true);
        TypeBean types = (TypeBean)rootHandle.getRoot();
        Assert.assertNotNull((Object)types);
        Assert.assertEquals((long)13L, (long)types.getIType());
        Assert.assertEquals((long)-13L, (long)types.getJType());
        Assert.assertEquals((Object)true, (Object)types.getZType());
        Assert.assertEquals((long)120L, (long)types.getBType());
        Assert.assertEquals((long)161L, (long)types.getSType());
        Assert.assertEquals((long)0L, (long)Float.compare(3.14f, types.getFType()));
        Assert.assertEquals((long)0L, (long)Double.compare(2.71828, types.getDType()));
        Assert.assertEquals((Object)new QName("bar"), (Object)types.getQNameLocalOnly());
        Assert.assertEquals((Object)new QName("http://www.acme.org/jmxoverjms", "foo", "xos"), (Object)types.getQName());
        Assert.assertEquals((Object)new QName("http://www.eagles.com/CarsonCity", "phillies", "sox"), (Object)types.getQNameElementPrefix());
        Assert.assertNull((Object)types.getQNameUnknownPrefix());
    }

    public static void testAnnotationWithEverythingCopied(ServiceLocator locator, URI uri) throws Exception {
        Commons.testAnnotationWithEverythingCopied(locator, uri, null);
    }

    public static void testAnnotationWithEverythingCopied(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testAnnotationWithEverythingCopied(locator, null, reader);
    }

    private static void testAnnotationWithEverythingCopied(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, Employees.class) : xmlService.unmarshal(reader, Employees.class, true, true);
        Employees employees = (Employees)rootHandle.getRoot();
        Method setBagelMethod = employees.getClass().getMethod("setBagelPreference", Integer.TYPE);
        EverythingBagel bagel = setBagelMethod.getAnnotation(EverythingBagel.class);
        Assert.assertEquals((long)13L, (long)bagel.byteValue());
        Assert.assertTrue((boolean)bagel.booleanValue());
        Assert.assertEquals((long)101L, (long)bagel.charValue());
        Assert.assertEquals((long)13L, (long)bagel.shortValue());
        Assert.assertEquals((long)13L, (long)bagel.intValue());
        Assert.assertEquals((long)13L, (long)bagel.longValue());
        Assert.assertEquals((long)0L, (long)Float.compare(13.0f, bagel.floatValue()));
        Assert.assertEquals((long)0L, (long)Double.compare(13.0, bagel.doubleValue()));
        Assert.assertEquals((Object)"13", (Object)bagel.stringValue());
        Assert.assertEquals(Employees.class, bagel.classValue());
        Assert.assertEquals((Object)((Object)GreekEnum.BETA), (Object)((Object)bagel.enumValue()));
        Assert.assertTrue((boolean)Arrays.equals(new byte[]{13, 14}, bagel.byteArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new boolean[]{true, false}, bagel.booleanArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new char[]{'e', 'E'}, bagel.charArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new short[]{13, 14}, bagel.shortArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new int[]{13, 14}, bagel.intArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new long[]{13L, 14L}, bagel.longArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new String[]{"13", "14"}, bagel.stringArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals(new Class[]{String.class, Double.TYPE}, bagel.classArrayValue()));
        Assert.assertTrue((boolean)Arrays.equals((Object[])new GreekEnum[]{GreekEnum.GAMMA, GreekEnum.ALPHA}, (Object[])bagel.enumArrayValue()));
        Assert.assertEquals((long)0L, (long)Float.compare(13.0f, bagel.floatArrayValue()[0]));
        Assert.assertEquals((long)0L, (long)Float.compare(14.0f, bagel.floatArrayValue()[1]));
        Assert.assertEquals((long)0L, (long)Double.compare(13.0, bagel.doubleArrayValue()[0]));
        Assert.assertEquals((long)0L, (long)Double.compare(14.0, bagel.doubleArrayValue()[1]));
    }

    public static void testEmptyListChildReturnsEmptyList(ServiceLocator locator, URI uri) throws Exception {
        Commons.testEmptyListChildReturnsEmptyList(locator, uri, null);
    }

    public static void testEmptyListChildReturnsEmptyList(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testEmptyListChildReturnsEmptyList(locator, null, reader);
    }

    private static void testEmptyListChildReturnsEmptyList(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, Employees.class) : xmlService.unmarshal(reader, Employees.class, true, true);
        Employees employees = (Employees)rootHandle.getRoot();
        List<OtherData> noChildrenList = employees.getNoChildList();
        Assert.assertNotNull(noChildrenList);
        Assert.assertTrue((boolean)noChildrenList.isEmpty());
    }

    public static void testEmptyArrayChildReturnsEmptyArray(ServiceLocator locator, URI uri) throws Exception {
        Commons.testEmptyArrayChildReturnsEmptyArray(locator, uri, null);
    }

    public static void testEmptyArrayChildReturnsEmptyArray(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testEmptyArrayChildReturnsEmptyArray(locator, null, reader);
    }

    private static void testEmptyArrayChildReturnsEmptyArray(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, Employees.class) : xmlService.unmarshal(reader, Employees.class, true, true);
        Employees employees = (Employees)rootHandle.getRoot();
        OtherData[] noChildrenList = employees.getNoChildArray();
        Assert.assertNotNull((Object)noChildrenList);
        Assert.assertEquals((long)0L, (long)noChildrenList.length);
    }

    public static void testByteArrayNonChild(ServiceLocator locator, URI uri) throws Exception {
        Commons.testByteArrayNonChild(locator, uri, null);
    }

    public static void testByteArrayNonChild(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testByteArrayNonChild(locator, null, reader);
    }

    private static void testByteArrayNonChild(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, Employees.class) : xmlService.unmarshal(reader, Employees.class, true, true);
        Employees employees = (Employees)rootHandle.getRoot();
        byte[] encrypted = employees.getEncryptedCredentials();
        Assert.assertNotNull((Object)encrypted);
        String asString = new String(encrypted);
        Assert.assertEquals((Object)"Garbledeguk", (Object)asString);
    }

    public static void testJaxbStyleReference(ServiceLocator locator, URI uri) throws Exception {
        Commons.testJaxbStyleReference(locator, uri, null);
    }

    public static void testJaxbStyleReference(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testJaxbStyleReference(locator, null, reader);
    }

    private static void testJaxbStyleReference(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, LifecycleConfig.class) : xmlService.unmarshal(reader, LifecycleConfig.class, true, true);
        LifecycleConfig lifecycleConfig = (LifecycleConfig)rootHandle.getRoot();
        Assert.assertNotNull((Object)lifecycleConfig);
        Environment cokeEnv = (Environment)locator.getService(Environment.class, COKE_ENV, new Annotation[0]);
        Assert.assertNotNull((Object)cokeEnv);
        Associations associations = cokeEnv.getAssociations();
        Assert.assertNotNull((Object)associations);
        Assert.assertEquals((long)2L, (long)associations.getAssociations().size());
        Association association0 = associations.getAssociations().get(0);
        Association association1 = associations.getAssociations().get(1);
        Assert.assertNotNull((Object)association0);
        Assert.assertNotNull((Object)association1);
        Runtimes runtimes = lifecycleConfig.getRuntimes();
        Runtime runtime = runtimes.lookupRuntime(WLS_RUNTIME_NAME);
        Partition allTwos = runtime.lookupPartition("222");
        Partition allThrees = runtime.lookupPartition("333");
        Partition allFives = runtime.lookupPartition("555");
        Partition allSevens = runtime.lookupPartition("777");
        Assert.assertNotNull((Object)allTwos);
        Assert.assertNotNull((Object)allThrees);
        Assert.assertNotNull((Object)allFives);
        Assert.assertNotNull((Object)allSevens);
        Partition a0_p1 = association0.getPartition1();
        Partition a0_p2 = association0.getPartition2();
        Partition a1_p1 = association1.getPartition1();
        Partition a1_p2 = association1.getPartition2();
        Assert.assertNotNull((Object)a0_p1);
        Assert.assertNotNull((Object)a0_p2);
        Assert.assertNotNull((Object)a1_p1);
        Assert.assertNotNull((Object)a1_p2);
        Assert.assertEquals((Object)a0_p1, (Object)allTwos);
        Assert.assertEquals((Object)a0_p2, (Object)allThrees);
        Assert.assertEquals((Object)a1_p1, (Object)allFives);
        Assert.assertEquals((Object)a1_p2, (Object)allSevens);
    }

    public static void testJaxbStyleForwardReference(ServiceLocator locator, URI uri) throws Exception {
        Commons.testJaxbStyleForwardReference(locator, uri, null);
    }

    public static void testJaxbStyleForwardReference(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testJaxbStyleForwardReference(locator, null, reader);
    }

    private static void testJaxbStyleForwardReference(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, ReferenceMaster.class) : xmlService.unmarshal(reader, ReferenceMaster.class, true, true);
        ReferenceMaster referenceMaster = (ReferenceMaster)rootHandle.getRoot();
        Assert.assertNotNull((Object)referenceMaster);
        AboveBean alice = referenceMaster.getAboves().get(0);
        AboveBean bob = referenceMaster.getAboves().get(1);
        BelowBean carol = referenceMaster.getBelows().get(0);
        BelowBean dave = referenceMaster.getBelows().get(1);
        Assert.assertNotNull((Object)alice);
        Assert.assertNotNull((Object)bob);
        Assert.assertNotNull((Object)carol);
        Assert.assertNotNull((Object)dave);
        TiesBean tie0 = referenceMaster.getTies().get(0);
        AboveBean aliceFromTie = tie0.getAbove();
        BelowBean carolFromTie = tie0.getBelow();
        Assert.assertEquals((Object)alice, (Object)aliceFromTie);
        Assert.assertEquals((Object)carol, (Object)carolFromTie);
        TiesBean tie1 = referenceMaster.getTies().get(1);
        AboveBean bobFromTie = tie1.getAbove();
        BelowBean daveFromTie = tie1.getBelow();
        Assert.assertEquals((Object)bob, (Object)bobFromTie);
        Assert.assertEquals((Object)dave, (Object)daveFromTie);
        BackwardTiesBean tie2 = referenceMaster.getBackwardTies().get(0);
        aliceFromTie = tie2.getAbove();
        daveFromTie = tie2.getBelow();
        Assert.assertEquals((Object)alice, (Object)aliceFromTie);
        Assert.assertEquals((Object)dave, (Object)daveFromTie);
        BackwardTiesBean tie3 = referenceMaster.getBackwardTies().get(1);
        bobFromTie = tie3.getAbove();
        carolFromTie = tie3.getBelow();
        Assert.assertEquals((Object)bob, (Object)bobFromTie);
        Assert.assertEquals((Object)carol, (Object)carolFromTie);
    }

    public static void testXmlJavaTypeAdapter(ServiceLocator locator, URI uri) throws Exception {
        Commons.testXmlJavaTypeAdapter(locator, uri, null);
    }

    public static void testXmlJavaTypeAdapter(ServiceLocator locator, XMLStreamReader reader) throws Exception {
        Commons.testXmlJavaTypeAdapter(locator, null, reader);
    }

    private static void testXmlJavaTypeAdapter(ServiceLocator locator, URI uri, XMLStreamReader reader) throws Exception {
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle rootHandle = uri != null ? xmlService.unmarshal(uri, RootBeanWithProperties.class) : xmlService.unmarshal(reader, RootBeanWithProperties.class, true, true);
        RootBeanWithProperties rbwp = (RootBeanWithProperties)rootHandle.getRoot();
        Map<String, String> props = rbwp.getProperties();
        Assert.assertEquals((Object)BOB, (Object)props.get(ALICE));
        Assert.assertEquals((Object)DAVE, (Object)props.get(CAROL));
        String collapsed = rbwp.getCollapsedProperty();
        Assert.assertEquals((Object)NO_LEADING_OR_TRAILING, (Object)collapsed);
        List<PropertyBean> nakedProperties = rbwp.getNakedProperties();
        Assert.assertEquals((long)1L, (long)nakedProperties.size());
        Assert.assertEquals((Object)ENGLEBERT, (Object)nakedProperties.get(0).getKey());
        Assert.assertEquals((Object)FRANK, (Object)nakedProperties.get(0).getValue());
    }
}

