/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.transaction;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.xml.api.XmlHandleTransaction;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans.JMSServerBean;
import org.glassfish.hk2.xml.test.beans.MachineBean;
import org.glassfish.hk2.xml.test.beans.ServerBean;
import org.glassfish.hk2.xml.test.dynamic.merge.MergeTest;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class TransactionTest {
    private static final String ALT_SUBNET = "0.0.255.255";
    private static final String MIXED_METAPHOR = "Mixed Metaphor";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyTwoPropertiesInOneTransaction() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        XmlHandleTransaction transaction = rootHandle.lockForTransaction();
        try {
            Assert.assertEquals((Object)rootHandle, (Object)transaction.getRootHandle());
            domain.setSubnetwork(ALT_SUBNET);
            domain.setTaxonomy(MIXED_METAPHOR);
        }
        finally {
            transaction.commit();
        }
        Assert.assertEquals((Object)ALT_SUBNET, (Object)domain.getSubnetwork());
        Assert.assertEquals((Object)MIXED_METAPHOR, (Object)domain.getTaxonomy());
        Instance domainInstance = hub.getCurrentDatabase().getInstance("/domain", "domain");
        Assert.assertNotNull((Object)domainInstance);
        Map domainMap = (Map)domainInstance.getBean();
        Assert.assertEquals((Object)ALT_SUBNET, domainMap.get("subnetwork"));
        Assert.assertEquals((Object)MIXED_METAPHOR, domainMap.get("taxonomy"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testModifyTwoPropertiesInOneTransactionAbandon() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        XmlHandleTransaction transaction = rootHandle.lockForTransaction();
        try {
            Assert.assertEquals((Object)rootHandle, (Object)transaction.getRootHandle());
            domain.setSubnetwork(ALT_SUBNET);
            domain.setTaxonomy(MIXED_METAPHOR);
        }
        finally {
            transaction.abandon();
        }
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveModifySuccess() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        XmlHandleTransaction transaction = rootHandle.lockForTransaction();
        try {
            TransactionTest.addRemoveAndModify(xmlService, domain);
        }
        finally {
            transaction.commit();
        }
        Assert.assertNull((Object)domain.lookupJMSServer("Dave"));
        MachineBean eddie = domain.lookupMachine("Eddie");
        Assert.assertNotNull((Object)eddie);
        Assert.assertEquals((Object)"Eddie", (Object)eddie.getName());
        ServerBean server1 = eddie.lookupServer("Server-1");
        Assert.assertEquals((Object)"Server-1", (Object)server1.getName());
        Assert.assertEquals((Object)ALT_SUBNET, (Object)domain.getSubnetwork());
        JMSServerBean carol = domain.lookupJMSServer("Carol");
        Assert.assertEquals((Object)"LZ", (Object)carol.getCompressionAlgorithm());
        Instance domainInstance = hub.getCurrentDatabase().getInstance("/domain", "domain");
        Assert.assertNotNull((Object)domainInstance);
        Map domainMap = (Map)domainInstance.getBean();
        Assert.assertEquals((Object)ALT_SUBNET, domainMap.get("subnetwork"));
        Assert.assertNull(domainMap.get("taxonomy"));
        Instance daveInstance = hub.getCurrentDatabase().getInstance("/domain/jms-server", "domain.Dave");
        Assert.assertNull((Object)daveInstance);
        MergeTest.assertNameOnlyBean(hub, "/domain/machine", "domain.Eddie", "Eddie");
        MergeTest.assertNameOnlyBean(hub, "/domain/machine/server", "domain.Eddie.Server-1", "Server-1");
        Instance carolInstance = hub.getCurrentDatabase().getInstance("/domain/jms-server", "domain.Carol");
        Assert.assertNotNull((Object)carolInstance);
        Map carolMap = (Map)carolInstance.getBean();
        Assert.assertEquals((Object)"LZ", carolMap.get("compression-algorithm"));
        Assert.assertNull((Object)locator.getService(JMSServerBean.class, "Dave", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(MachineBean.class, "Eddie", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(ServerBean.class, "Server-1", new Annotation[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddRemoveModifyAbandon() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        XmlHandleTransaction transaction = rootHandle.lockForTransaction();
        try {
            TransactionTest.addRemoveAndModify(xmlService, domain);
        }
        finally {
            transaction.abandon();
        }
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarshalInsideATransaction() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        XmlHandleTransaction transaction = rootHandle.lockForTransaction();
        boolean success = false;
        try {
            TransactionTest.addRemoveAndModify(xmlService, domain);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                rootHandle.marshal((OutputStream)baos);
            }
            String asString = baos.toString();
            Assert.assertFalse((boolean)asString.contains("Dave"));
            Assert.assertTrue((boolean)asString.contains("Eddie"));
            Assert.assertTrue((boolean)asString.contains("Server-1"));
            Assert.assertFalse((boolean)asString.contains("0.0.0.255"));
            Assert.assertTrue((boolean)asString.contains(ALT_SUBNET));
            success = true;
        }
        finally {
            if (success) {
                transaction.commit();
            } else {
                transaction.abandon();
            }
        }
    }

    private static void addRemoveAndModify(XmlService xmlService, DomainBean domain) {
        JMSServerBean dave = domain.removeJMSServer("Dave");
        Assert.assertNotNull((Object)dave);
        MachineBean eddie = (MachineBean)xmlService.createBean(MachineBean.class);
        eddie.setName("Eddie");
        ServerBean server1 = (ServerBean)xmlService.createBean(ServerBean.class);
        server1.setName("Server-1");
        eddie.addServer(server1);
        domain.addMachine(eddie);
        domain.setSubnetwork(ALT_SUBNET);
        JMSServerBean carol = domain.lookupJMSServer("Carol");
        carol.setCompressionAlgorithm("LZ");
    }
}

