/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import jakarta.xml.bind.Unmarshaller;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.xml.internal.AliasType;
import org.glassfish.hk2.xml.internal.ChildDataModel;
import org.glassfish.hk2.xml.internal.ChildDescriptor;
import org.glassfish.hk2.xml.internal.JAUtilities;
import org.glassfish.hk2.xml.internal.ModelImpl;
import org.glassfish.hk2.xml.internal.ParentedModel;
import org.glassfish.hk2.xml.internal.QNameUtilities;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class Hk2JAXBUnmarshallerListener
extends Unmarshaller.Listener {
    private final JAUtilities jaUtilities;
    private final ClassReflectionHelper classReflectionHelper;
    private final LinkedList<BaseHK2JAXBBean> allBeans = new LinkedList();

    Hk2JAXBUnmarshallerListener(JAUtilities jaUtilities, ClassReflectionHelper classReflectionHelper) {
        this.jaUtilities = jaUtilities;
        this.classReflectionHelper = classReflectionHelper;
    }

    private void setUserKey(BaseHK2JAXBBean bean, boolean listOrArray) {
        ModelImpl model = bean._getModel();
        QName keyProperty = model.getKeyProperty();
        if (keyProperty == null && listOrArray) {
            bean._setKeyValue(this.jaUtilities.getUniqueId());
            return;
        }
        if (keyProperty == null) {
            return;
        }
        String key = (String)bean._getProperty(QNameUtilities.getNamespace(keyProperty), keyProperty.getLocalPart());
        if (key == null) {
            return;
        }
        bean._setKeyValue(key);
    }

    private void setSelfXmlTagInAllChildren(BaseHK2JAXBBean targetBean, BaseHK2JAXBBean parent) {
        ModelImpl model = targetBean._getModel();
        for (Map.Entry<QName, ChildDescriptor> childDescriptorEntry : model.getAllChildrenDescriptors().entrySet()) {
            ParentedModel parentedNode = childDescriptorEntry.getValue().getParentedModel();
            if (parentedNode != null) {
                Object children;
                String childXmlTagNamespace = parentedNode.getChildXmlNamespace();
                String childXmlTag = parentedNode.getChildXmlTag();
                String xmlWrapperTag = parentedNode.getXmlWrapperTag();
                if (parentedNode.getAdapter() != null) continue;
                switch (parentedNode.getAliasType()) {
                    case NORMAL: {
                        children = targetBean._getProperty(childXmlTagNamespace, childXmlTag);
                        break;
                    }
                    case IS_ALIAS: {
                        children = targetBean._getProperty(childXmlTagNamespace, childXmlTag);
                        targetBean.__fixAlias(childXmlTagNamespace, childXmlTag, parentedNode.getChildXmlAlias());
                        break;
                    }
                    default: {
                        children = null;
                    }
                }
                if (children == null) continue;
                String proxyName = Utilities.getProxyNameFromInterfaceName(parentedNode.getChildInterface());
                if (children instanceof List) {
                    for (Object child : (List)children) {
                        if (!child.getClass().getName().equals(proxyName)) continue;
                        BaseHK2JAXBBean childBean = (BaseHK2JAXBBean)child;
                        childBean._setSelfXmlTag(parentedNode.getChildXmlNamespace(), Utilities.constructXmlTag(xmlWrapperTag, parentedNode.getChildXmlTag()));
                        this.setUserKey(childBean, true);
                    }
                    continue;
                }
                if (children.getClass().isArray()) {
                    for (Object child : (Object[])children) {
                        BaseHK2JAXBBean childBean = (BaseHK2JAXBBean)child;
                        childBean._setSelfXmlTag(parentedNode.getChildXmlNamespace(), Utilities.constructXmlTag(xmlWrapperTag, parentedNode.getChildXmlTag()));
                        this.setUserKey(childBean, true);
                    }
                    continue;
                }
                BaseHK2JAXBBean childBean = (BaseHK2JAXBBean)children;
                childBean._setSelfXmlTag(parentedNode.getChildXmlNamespace(), Utilities.constructXmlTag(xmlWrapperTag, parentedNode.getChildXmlTag()));
                this.setUserKey(childBean, false);
                continue;
            }
            QName nonChildProp = childDescriptorEntry.getKey();
            ChildDataModel cdm = childDescriptorEntry.getValue().getChildDataModel();
            if (!AliasType.IS_ALIAS.equals((Object)cdm.getAliasType())) continue;
            targetBean.__fixAlias(QNameUtilities.getNamespace(nonChildProp), nonChildProp.getLocalPart(), cdm.getXmlAlias());
        }
    }

    public void afterUnmarshal(Object target, Object parent) {
        if (!(target instanceof BaseHK2JAXBBean)) {
            return;
        }
        BaseHK2JAXBBean targetBean = (BaseHK2JAXBBean)target;
        BaseHK2JAXBBean parentBean = (BaseHK2JAXBBean)parent;
        ModelImpl targetNode = targetBean._getModel();
        this.allBeans.add(targetBean);
        if (parentBean == null) {
            QName rootName = targetNode.getRootName();
            targetBean._setSelfXmlTag(QNameUtilities.getNamespace(rootName), rootName.getLocalPart());
        }
        this.setSelfXmlTagInAllChildren(targetBean, parentBean);
    }

    public void beforeUnmarshal(Object target, Object parent) {
        if (!(target instanceof BaseHK2JAXBBean)) {
            return;
        }
        if (parent != null && !(parent instanceof BaseHK2JAXBBean)) {
            return;
        }
        BaseHK2JAXBBean targetBean = (BaseHK2JAXBBean)target;
        BaseHK2JAXBBean parentBean = (BaseHK2JAXBBean)parent;
        targetBean._setClassReflectionHelper(this.classReflectionHelper);
        targetBean._setParent(parentBean);
    }

    LinkedList<BaseHK2JAXBBean> getAllBeans() {
        return this.allBeans;
    }
}

