/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import jakarta.xml.bind.annotation.XmlNs;
import jakarta.xml.bind.annotation.XmlSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.hk2.utilities.cache.Computable;
import org.glassfish.hk2.utilities.cache.ComputationErrorException;

public class PackageToNamespaceComputable
implements Computable<Package, Map<String, String>> {
    private static final Map<String, String> EMPTY = Collections.emptyMap();

    public static Map<String, String> calculateNamespaces(Class<?> clazz) {
        Package p = clazz.getPackage();
        return new PackageToNamespaceComputable().compute(p);
    }

    public Map<String, String> compute(Package key) throws ComputationErrorException {
        XmlSchema xmlSchema = key.getAnnotation(XmlSchema.class);
        if (xmlSchema == null) {
            return EMPTY;
        }
        if (xmlSchema.xmlns() == null) {
            return EMPTY;
        }
        HashMap<String, String> retVal = new HashMap<String, String>();
        for (XmlNs xmlNs : xmlSchema.xmlns()) {
            retVal.put(xmlNs.prefix(), xmlNs.namespaceURI());
        }
        return retVal;
    }
}

