/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal.alt.papi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltMethod;
import org.glassfish.hk2.xml.internal.alt.MethodInformationI;
import org.glassfish.hk2.xml.internal.alt.clazz.ClassAltClassImpl;
import org.glassfish.hk2.xml.internal.alt.papi.AnnotationMirrorAltAnnotationImpl;
import org.glassfish.hk2.xml.internal.alt.papi.TypeElementAltClassImpl;

public class ElementAltMethodImpl
implements AltMethod {
    private final ExecutableElement method;
    private final ProcessingEnvironment processingEnv;
    private List<AltClass> parameters;
    private AltClass returnType;
    private Map<String, AltAnnotation> annotations;
    private MethodInformationI methodInformation;

    public ElementAltMethodImpl(Element method, ProcessingEnvironment processingEnv) {
        this.method = (ExecutableElement)method;
        this.processingEnv = processingEnv;
    }

    @Override
    public String getName() {
        return Utilities.convertNameToString(this.method.getSimpleName());
    }

    @Override
    public synchronized AltClass getReturnType() {
        AltClass retVal;
        if (this.returnType != null) {
            return this.returnType;
        }
        ExecutableType executable = (ExecutableType)this.method.asType();
        TypeMirror returnMirror = executable.getReturnType();
        this.returnType = retVal = Utilities.convertTypeMirror(returnMirror, this.processingEnv);
        return this.returnType;
    }

    @Override
    public synchronized List<AltClass> getParameterTypes() {
        if (this.parameters != null) {
            return this.parameters;
        }
        ExecutableType executable = (ExecutableType)this.method.asType();
        List<? extends TypeMirror> paramMirrors = executable.getParameterTypes();
        ArrayList<AltClass> retVal = new ArrayList<AltClass>(paramMirrors.size());
        for (TypeMirror typeMirror : paramMirrors) {
            retVal.add(Utilities.convertTypeMirror(typeMirror, this.processingEnv));
        }
        this.parameters = Collections.unmodifiableList(retVal);
        return this.parameters;
    }

    @Override
    public AltClass getFirstTypeArgument() {
        TypeMirror typeMirror = this.method.getReturnType();
        if (!(typeMirror instanceof DeclaredType)) {
            return null;
        }
        DeclaredType declaredReturn = (DeclaredType)typeMirror;
        List<? extends TypeMirror> types = declaredReturn.getTypeArguments();
        if (types == null || types.size() < 1) {
            return null;
        }
        TypeMirror firstTypeMirror = types.get(0);
        return Utilities.convertTypeMirror(firstTypeMirror, this.processingEnv);
    }

    @Override
    public AltClass getFirstTypeArgumentOfParameter(int index) {
        VariableElement ve = this.method.getParameters().get(index);
        TypeMirror tm = ve.asType();
        if (!TypeKind.DECLARED.equals((Object)tm.getKind())) {
            return ClassAltClassImpl.OBJECT;
        }
        DeclaredType dt = (DeclaredType)tm;
        List<? extends TypeMirror> typeParams = dt.getTypeArguments();
        if (typeParams == null || typeParams.size() < 1) {
            return ClassAltClassImpl.OBJECT;
        }
        TypeMirror firstTypeParam = typeParams.get(0);
        if (!TypeKind.DECLARED.equals((Object)firstTypeParam.getKind())) {
            return ClassAltClassImpl.OBJECT;
        }
        Element ele = ((DeclaredType)firstTypeParam).asElement();
        if (!(ele instanceof TypeElement)) {
            return ClassAltClassImpl.OBJECT;
        }
        return new TypeElementAltClassImpl((TypeElement)ele, this.processingEnv);
    }

    @Override
    public synchronized AltAnnotation getAnnotation(String annotation) {
        if (this.annotations == null) {
            this.getAnnotations();
        }
        return this.annotations.get(annotation);
    }

    @Override
    public synchronized List<AltAnnotation> getAnnotations() {
        if (this.annotations != null) {
            return Collections.unmodifiableList(new ArrayList<AltAnnotation>(this.annotations.values()));
        }
        LinkedHashMap<String, AnnotationMirrorAltAnnotationImpl> retVal = new LinkedHashMap<String, AnnotationMirrorAltAnnotationImpl>();
        for (AnnotationMirror annotationMirror : this.method.getAnnotationMirrors()) {
            AnnotationMirrorAltAnnotationImpl addMe = new AnnotationMirrorAltAnnotationImpl(annotationMirror, this.processingEnv);
            retVal.put(addMe.annotationType(), addMe);
        }
        this.annotations = Collections.unmodifiableMap(retVal);
        return Collections.unmodifiableList(new ArrayList<AltAnnotation>(this.annotations.values()));
    }

    @Override
    public void setMethodInformation(MethodInformationI methodInfo) {
        this.methodInformation = methodInfo;
    }

    @Override
    public MethodInformationI getMethodInformation() {
        return this.methodInformation;
    }

    @Override
    public boolean isVarArgs() {
        return this.method.isVarArgs();
    }

    public String toString() {
        return "ElementAltMethodImpl(" + this.method + ")";
    }
}

