/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.overlay;

import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.configuration.hub.api.Type;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.test.dynamic.overlay.ChangeDescriptor;
import org.glassfish.hk2.xml.test.dynamic.overlay.OverlayRootABean;
import org.glassfish.hk2.xml.test.dynamic.overlay.UnkeyedLeafBean;
import org.junit.Assert;

public class OverlayUtilities {
    public static final String OROOT_A = "overlay-root-A";
    public static final String OROOT_B = "overlay-root-B";
    public static final String A_LIST_CHILD = "unkeyed-leaf-list";
    public static final String A_ARRAY_CHILD = "unkeyed-leaf-array";
    public static final String NAME_TAG = "name";
    public static final String LEAF_LIST = "leaf-list";
    public static final String LEAF_ARRAY = "leaf-array";
    public static final String OROOT_TYPE = "/overlay-root-A";
    public static final String LIST_TYPE = "/overlay-root-A/unkeyed-leaf-list";
    public static final String ARRAY_TYPE = "/overlay-root-A/unkeyed-leaf-array";
    public static final String OROOT_TYPE_B = "/overlay-root-B";
    private static final String LEFT_PAREN = "(";
    private static final String RIGHT_PAREN = ")";

    public static String getStringVersionOfTree(OverlayRootABean root, boolean followList) {
        if (followList) {
            return OverlayUtilities.getStringVersionOfTreeList(root);
        }
        return OverlayUtilities.getStringVersionOfTreeArray(root);
    }

    private static String getStringVersionOfTreeList(OverlayRootABean root) {
        StringBuffer sb = new StringBuffer();
        for (UnkeyedLeafBean ulb : root.getUnkeyedLeafList()) {
            sb.append(ulb.getName());
            boolean wroteParen = false;
            if (!ulb.getListLeaf().isEmpty()) {
                sb.append(LEFT_PAREN);
                wroteParen = true;
            }
            for (UnkeyedLeafBean ulbc : ulb.getListLeaf()) {
                OverlayUtilities.getStringVersionOfLeafList(ulbc, sb);
            }
            if (!wroteParen) continue;
            sb.append(RIGHT_PAREN);
        }
        return sb.toString();
    }

    private static void getStringVersionOfLeafList(UnkeyedLeafBean ulb, StringBuffer sb) {
        sb.append(ulb.getName());
        boolean wroteParen = false;
        if (!ulb.getListLeaf().isEmpty()) {
            sb.append(LEFT_PAREN);
            wroteParen = true;
        }
        for (UnkeyedLeafBean ulbc : ulb.getListLeaf()) {
            OverlayUtilities.getStringVersionOfLeafList(ulbc, sb);
        }
        if (wroteParen) {
            sb.append(RIGHT_PAREN);
        }
    }

    private static String getStringVersionOfTreeArray(OverlayRootABean root) {
        StringBuffer sb = new StringBuffer();
        for (UnkeyedLeafBean ulb : root.getUnkeyedLeafArray()) {
            sb.append(ulb.getName());
            boolean wroteParen = false;
            if (ulb.getArrayLeaf().length > 0) {
                sb.append(LEFT_PAREN);
                wroteParen = true;
            }
            for (UnkeyedLeafBean ulbc : ulb.getArrayLeaf()) {
                OverlayUtilities.getStringVersionOfLeafArray(ulbc, sb);
            }
            if (!wroteParen) continue;
            sb.append(RIGHT_PAREN);
        }
        return sb.toString();
    }

    private static void getStringVersionOfLeafArray(UnkeyedLeafBean ulb, StringBuffer sb) {
        sb.append(ulb.getName());
        boolean wroteParen = false;
        if (ulb.getArrayLeaf().length > 0) {
            sb.append(LEFT_PAREN);
            wroteParen = true;
        }
        for (UnkeyedLeafBean ulbc : ulb.getArrayLeaf()) {
            OverlayUtilities.getStringVersionOfLeafArray(ulbc, sb);
        }
        if (wroteParen) {
            sb.append(RIGHT_PAREN);
        }
    }

    public static void generateOverlayRootABean(XmlRootHandle<OverlayRootABean> handle, String singleLetterLeafNames) {
        OverlayUtilities.generateOverlayRootABean(handle, true, true, OverlayUtilities.singleLetterNames(singleLetterLeafNames));
    }

    public static void generateOverlayRootABean(XmlRootHandle<OverlayRootABean> handle, boolean generateLists, boolean generateArrays, String singleLetterLeafNames) {
        OverlayUtilities.generateOverlayRootABean(handle, generateLists, generateArrays, OverlayUtilities.singleLetterNames(singleLetterLeafNames));
    }

    private static void generateOverlayRootABean(XmlRootHandle<OverlayRootABean> handle, boolean generateLists, boolean generateArrays, String ... leafNames) {
        OverlayRootABean root = (OverlayRootABean)handle.getRoot();
        Assert.assertNull((Object)root);
        handle.addRoot();
        root = (OverlayRootABean)handle.getRoot();
        OverlayUtilities.createOverlay(root, null, generateLists, generateArrays, leafNames);
    }

    private static void createOverlay(OverlayRootABean root, UnkeyedLeafBean parent, boolean generateLists, boolean generateArrays, String[] leafNames) {
        UnkeyedLeafBean addedListChild = null;
        UnkeyedLeafBean addedArrayChild = null;
        for (int lcv = 0; lcv < leafNames.length; ++lcv) {
            String leafName = leafNames[lcv];
            if (LEFT_PAREN.equals(leafName)) {
                String[] subList = OverlayUtilities.getChildNames(leafNames, lcv);
                if (generateLists) {
                    OverlayUtilities.createOverlay(root, addedListChild, generateLists, generateArrays, subList);
                }
                if (generateArrays) {
                    OverlayUtilities.createOverlay(root, addedArrayChild, generateLists, generateArrays, subList);
                }
                lcv += subList.length + 1;
                continue;
            }
            if (RIGHT_PAREN.equals(leafName)) continue;
            if (parent == null) {
                if (generateArrays) {
                    addedArrayChild = root.addUnkeyedLeafArray();
                    addedArrayChild.setName(leafName);
                }
                if (!generateLists) continue;
                addedListChild = root.addUnkeyedLeafList();
                addedListChild.setName(leafName);
                continue;
            }
            if (generateArrays) {
                addedArrayChild = parent.addArrayLeaf();
                addedArrayChild.setName(leafName);
            }
            if (!generateLists) continue;
            addedListChild = parent.addListLeaf();
            addedListChild.setName(leafName);
        }
    }

    private static String[] singleLetterNames(String parseMe) {
        if (parseMe == null) {
            parseMe = "";
        }
        String[] retVal = new String[parseMe.length()];
        for (int lcv = 0; lcv < parseMe.length(); ++lcv) {
            retVal[lcv] = parseMe.substring(lcv, lcv + 1);
        }
        return retVal;
    }

    public static void checkSingleLetterOveralyRootA(XmlRootHandle<OverlayRootABean> handle, Hub hub, boolean generateLists, boolean generateArrays, String names) {
        OverlayUtilities.checkSingleLetterOveralyRootA((OverlayRootABean)handle.getRoot(), hub, generateLists, generateArrays, OverlayUtilities.singleLetterNames(names));
    }

    private static void checkSingleLetterOveralyRootA(OverlayRootABean root, Hub hub, boolean generateLists, boolean generateArrays, String[] names) {
        String typeName = OROOT_TYPE;
        Type rootType = hub.getCurrentDatabase().getType(typeName);
        Map rootInstance = rootType.getInstances();
        Assert.assertEquals((long)1L, (long)rootInstance.size());
        int childCount = 0;
        UnkeyedLeafBean currentListBean = null;
        UnkeyedLeafBean currentArrayBean = null;
        for (int lcv = 0; lcv < names.length; ++lcv) {
            String name = names[lcv];
            if (LEFT_PAREN.equals(name)) {
                String[] childNames = OverlayUtilities.getChildNames(names, lcv);
                lcv += childNames.length;
                if (generateLists) {
                    OverlayUtilities.checkSingleLetterLeaf(currentListBean, hub, LIST_TYPE, generateLists, generateArrays, childNames);
                }
                if (!generateArrays) continue;
                OverlayUtilities.checkSingleLetterLeaf(currentArrayBean, hub, ARRAY_TYPE, generateLists, generateArrays, childNames);
                continue;
            }
            if (RIGHT_PAREN.equals(name)) continue;
            if (generateLists) {
                currentListBean = root.getUnkeyedLeafList().get(childCount);
                OverlayUtilities.checkLeafInHub(hub, LIST_TYPE, currentListBean, name, childCount);
            }
            if (generateArrays) {
                currentArrayBean = root.getUnkeyedLeafArray()[childCount];
                OverlayUtilities.checkLeafInHub(hub, ARRAY_TYPE, currentArrayBean, name, childCount);
            }
            ++childCount;
        }
        if (generateLists) {
            Type listType = hub.getCurrentDatabase().getType(LIST_TYPE);
            if (listType == null) {
                Assert.assertEquals((long)0L, (long)childCount);
            } else {
                Map listInstances = listType.getInstances();
                Assert.assertEquals((long)childCount, (long)listInstances.size());
            }
        }
        if (generateArrays) {
            Type arrayType = hub.getCurrentDatabase().getType(ARRAY_TYPE);
            if (arrayType == null) {
                Assert.assertEquals((long)0L, (long)childCount);
            } else {
                Map arrayInstances = arrayType.getInstances();
                Assert.assertEquals((long)childCount, (long)arrayInstances.size());
            }
        }
    }

    private static void checkSingleLetterLeaf(UnkeyedLeafBean root, Hub hub, String parentType, boolean generateLists, boolean generateArrays, String[] names) {
        String candidateInstanceName;
        int myChildrenCount;
        String listChildType = parentType + "/leaf-list";
        String arrayChildType = parentType + "/leaf-array";
        int childCount = 0;
        UnkeyedLeafBean currentListBean = null;
        UnkeyedLeafBean currentArrayBean = null;
        for (int lcv = 0; lcv < names.length; ++lcv) {
            String name = names[lcv];
            if (LEFT_PAREN.equals(name)) {
                String[] childNames = OverlayUtilities.getChildNames(names, lcv);
                lcv += childNames.length;
                if (generateLists) {
                    OverlayUtilities.checkSingleLetterLeaf(currentListBean, hub, listChildType, generateLists, generateArrays, childNames);
                }
                if (!generateArrays) continue;
                OverlayUtilities.checkSingleLetterLeaf(currentArrayBean, hub, arrayChildType, generateLists, generateArrays, childNames);
                continue;
            }
            if (RIGHT_PAREN.equals(name)) continue;
            if (generateLists) {
                currentListBean = root.getListLeaf().get(childCount);
                OverlayUtilities.checkLeafInHub(hub, listChildType, currentListBean, name, childCount);
            }
            if (generateArrays) {
                currentArrayBean = root.getArrayLeaf()[childCount];
                OverlayUtilities.checkLeafInHub(hub, arrayChildType, currentArrayBean, name, childCount);
            }
            ++childCount;
        }
        if (generateLists) {
            List<UnkeyedLeafBean> lBeans = root.getListLeaf();
            Assert.assertEquals((String)("Number of entries in " + lBeans + " is wrong"), (long)childCount, (long)lBeans.size());
        }
        if (generateArrays) {
            Object[] aBeans = root.getArrayLeaf();
            Assert.assertEquals((String)("Number of entries in " + Arrays.toString(aBeans) + " is wrong"), (long)childCount, (long)aBeans.length);
        }
        String parentInstanceName = ((XmlHk2ConfigurationBean)root)._getInstanceName();
        if (generateLists) {
            Type listType = hub.getCurrentDatabase().getType(listChildType);
            if (listType == null) {
                Assert.assertEquals((long)0L, (long)childCount);
            } else {
                Map listInstances = listType.getInstances();
                myChildrenCount = 0;
                for (Map.Entry me : listInstances.entrySet()) {
                    candidateInstanceName = (String)me.getKey();
                    if (!OverlayUtilities.isDirectChildBasedOnInstanceName(parentInstanceName, candidateInstanceName)) continue;
                    ++myChildrenCount;
                }
                Assert.assertEquals((String)("The type " + listChildType + " had the wrong number of entries"), (long)childCount, (long)myChildrenCount);
            }
        }
        if (generateArrays) {
            Type arrayType = hub.getCurrentDatabase().getType(arrayChildType);
            if (arrayType == null) {
                Assert.assertEquals((long)0L, (long)childCount);
            } else {
                Map arrayInstances = arrayType.getInstances();
                myChildrenCount = 0;
                for (Map.Entry me : arrayInstances.entrySet()) {
                    candidateInstanceName = (String)me.getKey();
                    if (!OverlayUtilities.isDirectChildBasedOnInstanceName(parentInstanceName, candidateInstanceName)) continue;
                    ++myChildrenCount;
                }
                Assert.assertEquals((String)("The type " + arrayChildType + " had the wrong number of entries"), (long)childCount, (long)myChildrenCount);
            }
        }
    }

    private static void checkLeafInHub(Hub hub, String typeName, UnkeyedLeafBean bean, String expectedName, int parentIndex) {
        Assert.assertEquals((String)("In type " + typeName + " we got wrong name at parent index " + parentIndex + " in bean " + bean), (Object)expectedName, (Object)bean.getName());
        Type type = hub.getCurrentDatabase().getType(typeName);
        Map instances = type.getInstances();
        boolean found = false;
        for (Instance instance : instances.values()) {
            Map blm = (Map)instance.getBean();
            String instanceName = (String)blm.get(NAME_TAG);
            if (instanceName == null || !instanceName.equals(expectedName)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)("Did not find expectedName " + expectedName + " in hub type " + typeName + " in bean " + bean), (boolean)found);
    }

    private static final String[] getChildNames(String[] names, int leftParenIndex) {
        Assert.assertEquals((Object)LEFT_PAREN, (Object)names[leftParenIndex]);
        Assert.assertTrue((names.length > leftParenIndex ? 1 : 0) != 0);
        int leftParenCount = 0;
        for (int dot = leftParenIndex + 1; dot < names.length; ++dot) {
            String current = names[dot];
            if (current.equals(LEFT_PAREN)) {
                ++leftParenCount;
                continue;
            }
            if (!current.equals(RIGHT_PAREN)) continue;
            if (leftParenCount <= 0) {
                int retLen = dot - leftParenIndex - 1;
                if (retLen <= 0) {
                    return new String[0];
                }
                String[] retVal = new String[retLen];
                System.arraycopy(names, leftParenIndex + 1, retVal, 0, retLen);
                return retVal;
            }
            --leftParenCount;
        }
        throw new AssertionError((Object)("There was a left paren without a matching right paren in " + names));
    }

    private static final boolean isDirectChildBasedOnInstanceName(String parentInstanceName, String myInstanceName) {
        if (!myInstanceName.startsWith(parentInstanceName)) {
            return false;
        }
        String remainder = myInstanceName.substring(parentInstanceName.length());
        if (!remainder.startsWith(".")) {
            return false;
        }
        int dotIndex = (remainder = remainder.substring(1)).indexOf(46);
        return dotIndex < 0;
    }

    private static String instanceToName(Instance instance) {
        if (instance == null) {
            return null;
        }
        Map blm = (Map)instance.getBean();
        if (blm == null) {
            return null;
        }
        return (String)blm.get(NAME_TAG);
    }

    private static String getChangeDescription(Change change) {
        StringBuffer sb = new StringBuffer(change.getChangeCategory() + " type=");
        Type type = change.getChangeType();
        sb.append(type.getName() + " ");
        switch (change.getChangeCategory()) {
            case REMOVE_INSTANCE: {
                String instanceKey = change.getInstanceKey();
                Instance instanceRemoved = change.getInstanceValue();
                String instanceName = OverlayUtilities.instanceToName(instanceRemoved);
                sb.append(" removedName=" + instanceName + " instanceKey=" + instanceKey);
                break;
            }
            case ADD_INSTANCE: {
                String instanceKey = change.getInstanceKey();
                Instance instanceAdded = change.getInstanceValue();
                String instanceName = OverlayUtilities.instanceToName(instanceAdded);
                sb.append(" addedName=" + instanceName + " instanceKey=" + instanceKey);
                break;
            }
            case MODIFY_INSTANCE: {
                String instanceKey = change.getInstanceKey();
                Instance originalMod = change.getOriginalInstanceValue();
                Instance changedMod = change.getInstanceValue();
                String originalName = OverlayUtilities.instanceToName(originalMod);
                String changedName = OverlayUtilities.instanceToName(changedMod);
                sb.append(" originalName=" + originalName + " newName=" + changedName + " instanceKey=" + instanceKey + " propsChanged=[");
                boolean firstTime = true;
                List propsChanged = change.getModifiedProperties();
                for (PropertyChangeEvent pce : propsChanged) {
                    if (firstTime) {
                        sb.append(pce.getPropertyName());
                        firstTime = false;
                        continue;
                    }
                    sb.append("," + pce.getPropertyName());
                }
                sb.append("]");
                break;
            }
        }
        return sb.toString();
    }

    private static String getAssertString(List<Change> changes, ChangeDescriptor ... changeDescriptors) {
        StringBuffer received = new StringBuffer("\n");
        int count = 0;
        for (Change change : changes) {
            received.append("  " + count + ". " + OverlayUtilities.getChangeDescription(change) + "\n");
            ++count;
        }
        StringBuffer expected = new StringBuffer("\n");
        for (int lcv = 0; lcv < changeDescriptors.length; ++lcv) {
            expected.append("  " + lcv + ". " + changeDescriptors[lcv] + "\n");
        }
        return "Expected Changes were: " + expected + "Recieved changes are: " + received;
    }

    public static void checkChanges(List<Change> changes, ChangeDescriptor ... changeDescriptors) {
        if (changes.size() != changeDescriptors.length) {
            Assert.fail((String)OverlayUtilities.getAssertString(changes, changeDescriptors));
        }
        LinkedHashSet<Integer> usedDescriptors = new LinkedHashSet<Integer>();
        HashMap<Integer, LinkedList<String>> errors = new HashMap<Integer, LinkedList<String>>();
        for (int lcv = 0; lcv < changeDescriptors.length; ++lcv) {
            ChangeDescriptor cd = changeDescriptors[lcv];
            for (int inner = 0; inner < changes.size(); ++inner) {
                if (usedDescriptors.contains(inner)) continue;
                Change change = changes.get(inner);
                String isSame = cd.check(change);
                if (isSame == null) {
                    usedDescriptors.add(inner);
                    continue;
                }
                LinkedList<String> eList = (LinkedList<String>)errors.get(inner);
                if (eList == null) {
                    eList = new LinkedList<String>();
                    errors.put(inner, eList);
                }
                eList.add(isSame);
            }
        }
        StringBuffer sb = new StringBuffer();
        if (!errors.isEmpty()) {
            for (Map.Entry errorEntry : errors.entrySet()) {
                Integer changeKey = (Integer)errorEntry.getKey();
                if (usedDescriptors.contains(changeKey)) continue;
                sb.append("Errors for Change " + errorEntry.getKey() + " (" + changes.get(changeKey) + ")\n");
                int lcv = 0;
                for (String eError : (List)errorEntry.getValue()) {
                    sb.append("  " + lcv + ". " + eError + "\n");
                    ++lcv;
                }
            }
        }
        Assert.assertEquals((String)(OverlayUtilities.getAssertString(changes, changeDescriptors) + " usedDescriptors=" + usedDescriptors + "\n" + sb.toString()), (long)changes.size(), (long)usedDescriptors.size());
    }
}

