/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal.alt.papi;

import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltMethod;

public class ArrayTypeAltClassImpl
implements AltClass {
    private final ArrayType arrayType;
    private final ProcessingEnvironment processingEnv;
    private String name;
    private String simpleName;

    public ArrayTypeAltClassImpl(ArrayType arrayType, ProcessingEnvironment processingEnv) {
        this.arrayType = arrayType;
        this.processingEnv = processingEnv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void calculateNames() {
        String lSimpleName;
        StringBuffer sb = new StringBuffer();
        TypeMirror currentMirror = this.arrayType;
        int numBraces = 0;
        while (TypeKind.ARRAY.equals((Object)currentMirror.getKind())) {
            sb.append("[");
            currentMirror = currentMirror.getComponentType();
            ++numBraces;
        }
        if (currentMirror.getKind().isPrimitive()) {
            if (TypeKind.INT.equals((Object)currentMirror.getKind())) {
                sb.append("I");
                lSimpleName = "int";
            } else if (TypeKind.LONG.equals((Object)currentMirror.getKind())) {
                sb.append("J");
                lSimpleName = "long";
            } else if (TypeKind.BYTE.equals((Object)currentMirror.getKind())) {
                sb.append("B");
                lSimpleName = "byte";
            } else if (TypeKind.BOOLEAN.equals((Object)currentMirror.getKind())) {
                sb.append("Z");
                lSimpleName = "boolean";
            } else if (TypeKind.CHAR.equals((Object)currentMirror.getKind())) {
                sb.append("C");
                lSimpleName = "char";
            } else if (TypeKind.DOUBLE.equals((Object)currentMirror.getKind())) {
                sb.append("D");
                lSimpleName = "double";
            } else if (TypeKind.FLOAT.equals((Object)currentMirror.getKind())) {
                sb.append("F");
                lSimpleName = "float";
            } else {
                if (!TypeKind.SHORT.equals((Object)currentMirror.getKind())) throw new AssertionError((Object)("Unknown primitive type " + currentMirror.getKind() + " for array " + this.arrayType));
                sb.append("S");
                lSimpleName = "short";
            }
        } else {
            if (!TypeKind.DECLARED.equals((Object)currentMirror.getKind())) throw new AssertionError((Object)("Unknown array type: " + currentMirror.getKind() + " for array " + this.arrayType));
            AltClass ac = Utilities.convertTypeMirror(currentMirror, this.processingEnv);
            sb.append("L" + ac.getName() + ";");
            lSimpleName = ac.getSimpleName();
        }
        this.name = sb.toString();
        StringBuffer simpleNameSB = new StringBuffer(lSimpleName);
        for (int lcv = 0; lcv < numBraces; ++lcv) {
            simpleNameSB.append("[]");
        }
        this.simpleName = simpleNameSB.toString();
    }

    @Override
    public synchronized String getName() {
        if (this.name != null) {
            return this.name;
        }
        this.calculateNames();
        return this.name;
    }

    @Override
    public synchronized String getSimpleName() {
        if (this.simpleName != null) {
            return this.simpleName;
        }
        this.calculateNames();
        return this.simpleName;
    }

    @Override
    public List<AltAnnotation> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public List<AltMethod> getMethods() {
        return Collections.emptyList();
    }

    @Override
    public AltClass getSuperParameterizedType(AltClass superclass, int paramIndex) {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public AltClass getComponentType() {
        TypeMirror compTypeAsMirror = this.arrayType.getComponentType();
        return Utilities.convertTypeMirror(compTypeAsMirror, this.processingEnv);
    }
}

