/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.xml.api.XmlHandleTransaction;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.internal.DynamicChangeInfo;

public class XmlHandleTransactionImpl<T>
implements XmlHandleTransaction<T> {
    private final XmlRootHandle<T> root;
    private final DynamicChangeInfo changeInfo;

    public XmlHandleTransactionImpl(XmlRootHandle<T> root, DynamicChangeInfo changeInfo) {
        this.root = root;
        this.changeInfo = changeInfo;
        changeInfo.getWriteLock().lock();
        changeInfo.startOrContinueChange(null);
    }

    @Override
    public XmlRootHandle<T> getRootHandle() {
        return this.root;
    }

    @Override
    public void commit() throws MultiException {
        try {
            this.changeInfo.endOrDeferChange(true);
        }
        finally {
            this.changeInfo.getWriteLock().unlock();
        }
    }

    @Override
    public void abandon() {
        try {
            this.changeInfo.endOrDeferChange(false);
        }
        finally {
            this.changeInfo.getWriteLock().unlock();
        }
    }

    public String toString() {
        return "XmlHandleTransactionImpl(" + this.root + "," + System.identityHashCode(this) + ")";
    }
}

