/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.utilities.general.GeneralUtilities;
import org.glassfish.hk2.xml.internal.AliasType;
import org.glassfish.hk2.xml.internal.Format;

public class ChildDataModel
implements Serializable {
    private static final long serialVersionUID = 208423310453044595L;
    private static final Map<String, Class<?>> TYPE_MAP = new HashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private String childType;
    private String defaultAsString;
    private boolean isReference;
    private Format format;
    private String childListType;
    private AliasType aliasType;
    private String aliasOf;
    private boolean required;
    private String originalMethodName;
    private ClassLoader myLoader;
    private Class<?> childTypeAsClass;
    private Class<?> childListTypeAsClass;

    public ChildDataModel() {
    }

    public ChildDataModel(String childType, String childListType, String defaultAsString, boolean isReference, Format format, AliasType aliasType, String aliasOf, boolean required, String originalMethodName) {
        this.childType = childType;
        this.defaultAsString = defaultAsString;
        this.isReference = isReference;
        this.format = format;
        this.childListType = childListType;
        this.aliasType = aliasType;
        this.aliasOf = aliasOf;
        this.required = required;
        this.originalMethodName = originalMethodName;
    }

    public String getChildType() {
        return this.childType;
    }

    public String getChildListType() {
        return this.childListType;
    }

    public String getDefaultAsString() {
        return this.defaultAsString;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public Format getFormat() {
        return this.format;
    }

    public AliasType getAliasType() {
        return this.aliasType;
    }

    public String getXmlAlias() {
        return this.aliasOf;
    }

    public void setLoader(ClassLoader myLoader) {
        this.lock.lock();
        try {
            this.myLoader = myLoader;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Class<?> getChildTypeAsClass() {
        this.lock.lock();
        try {
            if (this.childTypeAsClass != null) {
                Class<?> clazz = this.childTypeAsClass;
                return clazz;
            }
            this.childTypeAsClass = TYPE_MAP.get(this.childType);
            if (this.childTypeAsClass != null) {
                Class<?> clazz = this.childTypeAsClass;
                return clazz;
            }
            this.childTypeAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.childType);
            Class<?> clazz = this.childTypeAsClass;
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Class<?> getChildListTypeAsClass() {
        this.lock.lock();
        try {
            if (this.childListType == null) {
                Class<?> clazz = null;
                return clazz;
            }
            if (this.childListTypeAsClass != null) {
                Class<?> clazz = this.childListTypeAsClass;
                return clazz;
            }
            this.childListTypeAsClass = TYPE_MAP.get(this.childListType);
            if (this.childListTypeAsClass != null) {
                Class<?> clazz = this.childListTypeAsClass;
                return clazz;
            }
            this.childListTypeAsClass = GeneralUtilities.loadClass((ClassLoader)this.myLoader, (String)this.childListType);
            Class<?> clazz = this.childListTypeAsClass;
            return clazz;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getOriginalMethodName() {
        return this.originalMethodName;
    }

    public String toString() {
        return "ChildDataModel(" + this.childType + "," + this.defaultAsString + "," + this.isReference + "," + this.childListType + "," + this.aliasType + "," + this.format + "," + this.required + "," + this.originalMethodName + "," + System.identityHashCode(this) + ")";
    }

    static {
        TYPE_MAP.put("char", Character.TYPE);
        TYPE_MAP.put("byte", Byte.TYPE);
        TYPE_MAP.put("short", Short.TYPE);
        TYPE_MAP.put("int", Integer.TYPE);
        TYPE_MAP.put("float", Float.TYPE);
        TYPE_MAP.put("long", Long.TYPE);
        TYPE_MAP.put("double", Double.TYPE);
        TYPE_MAP.put("boolean", Boolean.TYPE);
    }
}

