/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.xml.jaxb.internal.BaseHK2JAXBBean;

public class Differences {
    private Map<DifferenceKey, Difference> differences = new LinkedHashMap<DifferenceKey, Difference>();

    public void addDifference(Difference difference) {
        DifferenceKey addedKey = new DifferenceKey(difference.getSource());
        Difference existingDifference = this.differences.get(addedKey);
        if (existingDifference == null) {
            this.differences.put(addedKey, difference);
        } else {
            existingDifference.merge(difference);
        }
    }

    public List<Difference> getDifferences() {
        return new ArrayList<Difference>(this.differences.values());
    }

    public int getDifferenceCost() {
        int retVal = 0;
        for (Difference d : this.differences.values()) {
            retVal += d.getSize();
        }
        return retVal;
    }

    public void merge(Differences diffs) {
        for (Difference diff : diffs.getDifferences()) {
            this.addDifference(diff);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Differences(num=" + this.differences.size() + ",cost=" + this.getDifferenceCost() + "\n");
        int lcv = 1;
        for (Difference d : this.differences.values()) {
            BaseHK2JAXBBean source = d.getSource();
            String xmlPath = source._getXmlPath();
            String instanceName = source._getInstanceName();
            List<PropertyChangeEvent> events = d.getNonChildChanges();
            sb.append(lcv + ". Modified Bean sourcePath=" + xmlPath + " sourceInstance=" + instanceName + "\n");
            for (PropertyChangeEvent event : events) {
                sb.append("\tCHANGED: " + event.getPropertyName() + " from " + event.getOldValue() + " to " + event.getNewValue() + "\n");
            }
            Map<String, AddRemoveMoveDifference> childChanges = d.getChildChanges();
            for (Map.Entry<String, AddRemoveMoveDifference> childEntry : childChanges.entrySet()) {
                String propertyName = childEntry.getKey();
                sb.append("  CHANGED CHILD: " + propertyName + "\n");
                AddRemoveMoveDifference arm = childEntry.getValue();
                for (AddData ad : arm.getAdds()) {
                    BaseHK2JAXBBean added = ad.getToAdd();
                    int index = ad.getIndex();
                    String addedXmlPath = added._getXmlPath();
                    String addedInstanceName = added._getInstanceName();
                    sb.append("    ADDED: addedPath=" + addedXmlPath + " addedInstanceName=" + addedInstanceName + " addedIndex=" + index + "\n");
                }
                for (RemoveData rd : arm.getRemoves()) {
                    String removedXmlPath = rd.getChild()._getXmlPath();
                    String removedInstanceName = rd.getChild()._getInstanceName();
                    sb.append("    REMOVED: removedPath=" + removedXmlPath + " removedInstanceName=" + removedInstanceName + "\n");
                }
                for (MoveData md : arm.getMoves()) {
                    sb.append("    MOVED: oldIndex=" + md.getOldIndex() + " newIndex=" + md.getNewIndex() + "\n");
                }
                for (AddRemoveData ard : arm.getDirectReplaces()) {
                    AddData ad = ard.getAdd();
                    RemoveData rd = ard.getRemove();
                    BaseHK2JAXBBean added = ad.getToAdd();
                    String addedXmlPath = added._getXmlPath();
                    String addedInstanceName = added._getInstanceName();
                    String removedInstanceName = rd.getChild()._getInstanceName();
                    sb.append("    DIRECT_REPLACEMENT: modifiedPath=" + addedXmlPath + " addedInstanceName=" + addedInstanceName + " removedInstanceName=" + removedInstanceName + "\n");
                }
            }
            ++lcv;
        }
        return sb.toString() + "\n," + System.identityHashCode(this) + ")";
    }

    private static class DifferenceKey {
        private final String xmlPath;
        private final String instanceName;
        private final int hash;

        private DifferenceKey(BaseHK2JAXBBean bean) {
            this.xmlPath = bean._getXmlPath();
            this.instanceName = bean._getInstanceName();
            this.hash = this.xmlPath.hashCode() ^ this.instanceName.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof DifferenceKey)) {
                return false;
            }
            DifferenceKey other = (DifferenceKey)o;
            return this.xmlPath.equals(other.xmlPath) && this.instanceName.equals(other.instanceName);
        }

        public String toString() {
            return "DifferenceKey(" + this.xmlPath + "," + this.instanceName + "," + this.hash + "," + System.identityHashCode(this) + ")";
        }
    }

    public static class Difference {
        private final BaseHK2JAXBBean source;
        private final List<PropertyChangeEvent> nonChildChanges = new LinkedList<PropertyChangeEvent>();
        private final Map<String, AddRemoveMoveDifference> childChanges = new LinkedHashMap<String, AddRemoveMoveDifference>();

        public Difference(BaseHK2JAXBBean source) {
            this.source = source;
        }

        public BaseHK2JAXBBean getSource() {
            return this.source;
        }

        public void addNonChildChange(PropertyChangeEvent evt) {
            this.nonChildChanges.add(evt);
        }

        public List<PropertyChangeEvent> getNonChildChanges() {
            return this.nonChildChanges;
        }

        public Map<String, AddRemoveMoveDifference> getChildChanges() {
            return this.childChanges;
        }

        private AddRemoveMoveDifference getARMDiff(String propName) {
            AddRemoveMoveDifference field = this.childChanges.get(propName);
            if (field == null) {
                field = new AddRemoveMoveDifference();
                this.childChanges.put(propName, field);
            }
            return field;
        }

        public void addAdd(String propName, AddData toAdd) {
            AddRemoveMoveDifference arm = this.getARMDiff(propName);
            arm.addAdd(toAdd);
        }

        public void addAdd(String propName, BaseHK2JAXBBean toAdd, int index) {
            this.addAdd(propName, new AddData(toAdd, index));
        }

        public void addMove(String propName, MoveData md) {
            AddRemoveMoveDifference arm = this.getARMDiff(propName);
            arm.addMove(md);
        }

        public void addRemove(String propName, RemoveData removeData) {
            AddRemoveMoveDifference arm = this.getARMDiff(propName);
            arm.addRemove(removeData);
        }

        public void addDirectReplace(String propName, BaseHK2JAXBBean toAdd, RemoveData removeData) {
            AddRemoveMoveDifference arm = this.getARMDiff(propName);
            arm.addDirectReplace(new AddRemoveData(new AddData(toAdd, -1), removeData));
        }

        private void merge(Difference mergeMe) {
            for (PropertyChangeEvent pce : mergeMe.getNonChildChanges()) {
                this.addNonChildChange(pce);
            }
            Map<String, AddRemoveMoveDifference> childChanges = mergeMe.getChildChanges();
            for (Map.Entry<String, AddRemoveMoveDifference> childEntry : childChanges.entrySet()) {
                String propertyName = childEntry.getKey();
                AddRemoveMoveDifference arm = childEntry.getValue();
                for (AddData add : arm.getAdds()) {
                    this.addAdd(propertyName, new AddData(add));
                }
                for (RemoveData remove : arm.getRemoves()) {
                    this.addRemove(propertyName, new RemoveData(remove));
                }
                for (MoveData move : arm.getMoves()) {
                    this.addMove(propertyName, new MoveData(move));
                }
            }
        }

        public boolean isDirty() {
            return !this.nonChildChanges.isEmpty() || !this.childChanges.isEmpty();
        }

        public boolean hasChildChanges() {
            return !this.childChanges.isEmpty();
        }

        public int getSize() {
            int retVal = this.nonChildChanges.size();
            return retVal += this.childChanges.size();
        }

        public String toString() {
            return "Difference(" + this.source + "," + System.identityHashCode(this) + ")";
        }
    }

    public static class AddRemoveMoveDifference {
        private final List<AddData> adds = new ArrayList<AddData>();
        private final List<RemoveData> removes = new ArrayList<RemoveData>();
        private final List<MoveData> moves = new ArrayList<MoveData>();
        private final List<AddRemoveData> directReplace = new ArrayList<AddRemoveData>();

        private void addAdd(AddData add) {
            this.adds.add(add);
        }

        private void addRemove(RemoveData remove) {
            this.removes.add(remove);
        }

        private void addMove(MoveData move) {
            this.moves.add(move);
        }

        private void addDirectReplace(AddRemoveData dr) {
            this.directReplace.add(dr);
        }

        public List<AddData> getAdds() {
            return this.adds;
        }

        public List<RemoveData> getRemoves() {
            return this.removes;
        }

        public List<MoveData> getMoves() {
            return this.moves;
        }

        public List<AddRemoveData> getDirectReplaces() {
            return this.directReplace;
        }

        public boolean requiresListChange() {
            return !this.adds.isEmpty() || !this.removes.isEmpty() || !this.moves.isEmpty() || !this.directReplace.isEmpty();
        }

        public int getSize() {
            return this.adds.size() + this.removes.size() + this.moves.size() + this.directReplace.size();
        }

        public int getNewSize(int oldSize) {
            return oldSize - this.removes.size() + this.adds.size();
        }

        public String toString() {
            return "AddRemoveMoveDifference(" + this.adds + "," + this.removes + "," + this.moves + "," + this.directReplace + "," + System.identityHashCode(this) + ")";
        }
    }

    public static class AddData {
        private final BaseHK2JAXBBean toAdd;
        private final int index;

        public AddData(BaseHK2JAXBBean toAdd, int index) {
            this.toAdd = toAdd;
            this.index = index;
        }

        public AddData(AddData copyMe) {
            this.toAdd = copyMe.toAdd;
            this.index = copyMe.index;
        }

        public BaseHK2JAXBBean getToAdd() {
            return this.toAdd;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return "AddData(" + this.toAdd + "," + this.index + "," + System.identityHashCode(this) + ")";
        }
    }

    public static class RemoveData {
        private final String childProperty;
        private final String childKey;
        private final int index;
        private final BaseHK2JAXBBean child;

        public RemoveData(String childProperty, BaseHK2JAXBBean child) {
            this(childProperty, null, -1, child);
        }

        public RemoveData(String childProperty, String childKey, BaseHK2JAXBBean child) {
            this(childProperty, childKey, -1, child);
        }

        public RemoveData(String childProperty, int index, BaseHK2JAXBBean child) {
            this(childProperty, null, index, child);
        }

        public RemoveData(RemoveData copyMe) {
            this(copyMe.childProperty, copyMe.childKey, copyMe.index, copyMe.child);
        }

        private RemoveData(String childProperty, String childKey, int index, BaseHK2JAXBBean child) {
            this.childProperty = childProperty;
            this.childKey = childKey;
            this.index = index;
            this.child = child;
        }

        public String getChildProperty() {
            return this.childProperty;
        }

        public String getChildKey() {
            return this.childKey;
        }

        public int getIndex() {
            return this.index;
        }

        public BaseHK2JAXBBean getChild() {
            return this.child;
        }

        public String toString() {
            return "RemoveData(" + this.childProperty + "," + this.childKey + "," + this.index + "," + this.child + "," + System.identityHashCode(this) + ")";
        }
    }

    public static class MoveData {
        private final int oldIndex;
        private final int newIndex;

        public MoveData(int oldIndex, int newIndex) {
            this.oldIndex = oldIndex;
            this.newIndex = newIndex;
        }

        public MoveData(MoveData copyMe) {
            this(copyMe.oldIndex, copyMe.newIndex);
        }

        public int getOldIndex() {
            return this.oldIndex;
        }

        public int getNewIndex() {
            return this.newIndex;
        }

        public String toString() {
            return "MoveData(" + this.oldIndex + "," + this.newIndex + "," + System.identityHashCode(this) + ")";
        }
    }

    public static class AddRemoveData {
        private final AddData add;
        private final RemoveData remove;

        private AddRemoveData(AddData add, RemoveData remove) {
            this.add = add;
            this.remove = remove;
        }

        public AddData getAdd() {
            return this.add;
        }

        public RemoveData getRemove() {
            return this.remove;
        }

        public String toString() {
            return "AddRemoveData(" + this.add + "," + this.remove + "," + System.identityHashCode(this) + ")";
        }
    }
}

