/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal.alt.clazz;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.utilities.reflection.ClassReflectionHelper;
import org.glassfish.hk2.utilities.reflection.MethodWrapper;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.glassfish.hk2.utilities.reflection.internal.ClassReflectionHelperImpl;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltMethod;
import org.glassfish.hk2.xml.internal.alt.clazz.AnnotationAltAnnotationImpl;
import org.glassfish.hk2.xml.internal.alt.clazz.MethodAltMethodImpl;

public class ClassAltClassImpl
implements AltClass {
    private static final ClassReflectionHelper SCALAR_HELPER = new ClassReflectionHelperImpl();
    public static final AltClass VOID = new ClassAltClassImpl(Void.TYPE, SCALAR_HELPER);
    public static final AltClass BOOLEAN = new ClassAltClassImpl(Boolean.TYPE, SCALAR_HELPER);
    public static final AltClass BYTE = new ClassAltClassImpl(Byte.TYPE, SCALAR_HELPER);
    public static final AltClass CHAR = new ClassAltClassImpl(Character.TYPE, SCALAR_HELPER);
    public static final AltClass SHORT = new ClassAltClassImpl(Short.TYPE, SCALAR_HELPER);
    public static final AltClass INT = new ClassAltClassImpl(Integer.TYPE, SCALAR_HELPER);
    public static final AltClass LONG = new ClassAltClassImpl(Long.TYPE, SCALAR_HELPER);
    public static final AltClass FLOAT = new ClassAltClassImpl(Float.TYPE, SCALAR_HELPER);
    public static final AltClass DOUBLE = new ClassAltClassImpl(Double.TYPE, SCALAR_HELPER);
    public static final AltClass OBJECT = new ClassAltClassImpl(Object.class, SCALAR_HELPER);
    public static final AltClass XML_ADAPTER = new ClassAltClassImpl(XmlAdapter.class, SCALAR_HELPER);
    private final ReentrantLock lock = new ReentrantLock();
    private final Class<?> clazz;
    private final ClassReflectionHelper helper;
    private List<AltMethod> methods;
    private List<AltAnnotation> annotations;

    public ClassAltClassImpl(Class<?> clazz, ClassReflectionHelper helper) {
        this.clazz = clazz;
        this.helper = helper;
    }

    public Class<?> getOriginalClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public String getSimpleName() {
        return this.clazz.getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AltAnnotation> getAnnotations() {
        this.lock.lock();
        try {
            if (this.annotations != null) {
                List<AltAnnotation> list = this.annotations;
                return list;
            }
            Annotation[] annotationz = this.clazz.getAnnotations();
            ArrayList<AnnotationAltAnnotationImpl> retVal = new ArrayList<AnnotationAltAnnotationImpl>(annotationz.length);
            for (Annotation annotation : annotationz) {
                retVal.add(new AnnotationAltAnnotationImpl(annotation, this.helper));
            }
            List<AltAnnotation> list = this.annotations = Collections.unmodifiableList(retVal);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AltMethod> getMethods() {
        this.lock.lock();
        try {
            if (this.methods != null) {
                List<AltMethod> list = this.methods;
                return list;
            }
            Set wrappers = this.helper.getAllMethods(this.clazz);
            ArrayList<MethodAltMethodImpl> retVal = new ArrayList<MethodAltMethodImpl>(wrappers.size());
            for (MethodWrapper method : wrappers) {
                retVal.add(new MethodAltMethodImpl(method.getMethod(), this.helper));
            }
            this.methods = Collections.unmodifiableList(retVal);
            List<AltMethod> list = this.methods;
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public AltClass getSuperParameterizedType(AltClass superType, int paramIndex) {
        Class<?> previousClazz = this.clazz;
        Class<?> superClass = previousClazz.getSuperclass();
        while (superClass != null) {
            if (superType.getName().equals(superClass.getName())) {
                Type genericType = previousClazz.getGenericSuperclass();
                if (!(genericType instanceof ParameterizedType)) {
                    return null;
                }
                ParameterizedType pt = (ParameterizedType)genericType;
                Type actualType = pt.getActualTypeArguments()[paramIndex];
                Class rawType = ReflectionHelper.getRawClass((Type)actualType);
                if (rawType == null) {
                    return null;
                }
                return new ClassAltClassImpl(rawType, this.helper);
            }
            previousClazz = superClass;
            superClass = previousClazz.getSuperclass();
        }
        return null;
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public boolean isArray() {
        return this.clazz.isArray();
    }

    @Override
    public AltClass getComponentType() {
        Class<?> cType = this.clazz.getComponentType();
        if (cType == null) {
            return null;
        }
        return new ClassAltClassImpl(cType, this.helper);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof AltClass)) {
            return false;
        }
        AltClass other = (AltClass)o;
        return this.getName().equals(other.getName());
    }

    public String toString() {
        return "ClassAltClassImpl(" + this.clazz.getName() + "," + System.identityHashCode(this) + ")";
    }
}

