/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.arrays;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.arrays.Employees;
import org.glassfish.hk2.xml.test.basic.beans.Employee;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class ArraysTest {
    @Test
    public void testBasicReadWithArray() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("Acme1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Employees.class);
        Employees employees = (Employees)rootHandle.getRoot();
        Assert.assertTrue((boolean)(employees instanceof XmlHk2ConfigurationBean));
        XmlHk2ConfigurationBean hk2Configuration = (XmlHk2ConfigurationBean)employees;
        Map beanLikeMap = hk2Configuration._getBeanLikeMap();
        Assert.assertEquals((Object)"Acme", beanLikeMap.get("company-name"));
        Employee[] employeeChildList = (Employee[])beanLikeMap.get("employee");
        Assert.assertNotNull((Object)employeeChildList);
        Assert.assertEquals((long)2L, (long)employeeChildList.length);
        boolean first = true;
        for (Employee employee : employeeChildList) {
            Assert.assertTrue((boolean)(employee instanceof XmlHk2ConfigurationBean));
            XmlHk2ConfigurationBean employeeConfiguration = (XmlHk2ConfigurationBean)employee;
            Map employeeBeanLikeMap = employeeConfiguration._getBeanLikeMap();
            if (first) {
                first = false;
                Assert.assertEquals((Object)100L, employeeBeanLikeMap.get("id"));
                Assert.assertEquals((Object)"Bob", employeeBeanLikeMap.get("name"));
                continue;
            }
            Assert.assertEquals((Object)101L, employeeBeanLikeMap.get("id"));
            Assert.assertEquals((Object)"Carol", employeeBeanLikeMap.get("name"));
        }
        Assert.assertNotNull((Object)locator.getService(Employees.class, new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(Employee.class, "Bob", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(Employee.class, "Carol", new Annotation[0]));
    }
}

