/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.internal.alt.papi;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.glassfish.hk2.xml.internal.Utilities;
import org.glassfish.hk2.xml.internal.alt.AltAnnotation;
import org.glassfish.hk2.xml.internal.alt.AltClass;
import org.glassfish.hk2.xml.internal.alt.AltEnum;
import org.glassfish.hk2.xml.internal.alt.papi.StringAltEnumImpl;

public class AnnotationMirrorAltAnnotationImpl
implements AltAnnotation {
    private final ReentrantLock lock = new ReentrantLock();
    private final AnnotationMirror annotation;
    private final ProcessingEnvironment processingEnv;
    private String type;
    private Map<String, Object> values;

    public AnnotationMirrorAltAnnotationImpl(AnnotationMirror annotation, ProcessingEnvironment processingEnv) {
        this.annotation = annotation;
        this.processingEnv = processingEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String annotationType() {
        this.lock.lock();
        try {
            if (this.type != null) {
                String string = this.type;
                return string;
            }
            DeclaredType dt = this.annotation.getAnnotationType();
            TypeElement clazzType = (TypeElement)dt.asElement();
            String string = this.type = Utilities.convertNameToString(clazzType.getQualifiedName());
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getStringValue(String methodName) {
        this.getAnnotationValues();
        return (String)this.values.get(methodName);
    }

    @Override
    public boolean getBooleanValue(String methodName) {
        this.getAnnotationValues();
        return (Boolean)this.values.get(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getStringArrayValue(String methodName) {
        this.lock.lock();
        try {
            this.getAnnotationValues();
            Object retVal = this.values.get(methodName);
            if (retVal == null || !(retVal instanceof String[])) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] stringArray = (String[])this.values.get(methodName);
            return stringArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public AltAnnotation[] getAnnotationArrayValue(String methodName) {
        this.getAnnotationValues();
        return (AltAnnotation[])this.values.get(methodName);
    }

    @Override
    public AltClass getClassValue(String methodName) {
        this.getAnnotationValues();
        return (AltClass)this.values.get(methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAnnotationValues() {
        this.lock.lock();
        try {
            if (this.values != null) {
                Map<String, Object> map = this.values;
                return map;
            }
            Map<? extends ExecutableElement, ? extends AnnotationValue> rawValues = this.processingEnv.getElementUtils().getElementValuesWithDefaults(this.annotation);
            TreeMap<String, Object> retVal = new TreeMap<String, Object>();
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : rawValues.entrySet()) {
                ExecutableElement annoMethod = entry.getKey();
                AnnotationValue annoValue = entry.getValue();
                String key = Utilities.convertNameToString(annoMethod.getSimpleName());
                Object value = annoValue.getValue();
                if (value instanceof TypeMirror) {
                    value = Utilities.convertTypeMirror((TypeMirror)value, this.processingEnv);
                } else if (value instanceof VariableElement) {
                    VariableElement variable = (VariableElement)value;
                    TypeElement enclosing = (TypeElement)variable.getEnclosingElement();
                    String annoClassName = Utilities.convertNameToString(enclosing.getQualifiedName());
                    String annoVal = Utilities.convertNameToString(variable.getSimpleName());
                    value = new StringAltEnumImpl(annoClassName, annoVal);
                } else {
                    if (value instanceof AnnotationMirror) {
                        throw new AssertionError((Object)("The annotation " + this.annotation + " key " + key + " has unimplemented type AnnotationMirror"));
                    }
                    if (value instanceof List) {
                        int lcv;
                        Object[] iValue;
                        ArrayType returnType = (ArrayType)annoMethod.getReturnType();
                        TypeMirror arrayTypeMirror = returnType.getComponentType();
                        TypeKind arrayTypeKind = arrayTypeMirror.getKind();
                        List array = (List)value;
                        if (TypeKind.INT.equals((Object)arrayTypeMirror.getKind())) {
                            iValue = new int[array.size()];
                            lcv = 0;
                            for (AnnotationValue item : array) {
                                iValue[lcv++] = (Integer)item.getValue();
                            }
                            value = iValue;
                        } else if (TypeKind.DECLARED.equals((Object)arrayTypeMirror.getKind())) {
                            AltClass[] cValue = new AltClass[array.size()];
                            AltEnum[] eValue = new AltEnum[array.size()];
                            String[] sValue = new String[array.size()];
                            AltAnnotation[] aValue = new AltAnnotation[array.size()];
                            boolean isClass = true;
                            boolean isEnum = true;
                            boolean isAnnos = false;
                            int lcv2 = 0;
                            for (AnnotationValue item : array) {
                                Object itemValue = item.getValue();
                                if (itemValue instanceof TypeMirror) {
                                    isClass = true;
                                    isEnum = false;
                                    isAnnos = false;
                                    cValue[lcv2++] = Utilities.convertTypeMirror((TypeMirror)itemValue, this.processingEnv);
                                    continue;
                                }
                                if (itemValue instanceof VariableElement) {
                                    isClass = false;
                                    isEnum = true;
                                    isAnnos = false;
                                    VariableElement variable = (VariableElement)itemValue;
                                    TypeElement enclosing = (TypeElement)variable.getEnclosingElement();
                                    String annoClassName = Utilities.convertNameToString(enclosing.getQualifiedName());
                                    String annoVal = Utilities.convertNameToString(variable.getSimpleName());
                                    eValue[lcv2++] = new StringAltEnumImpl(annoClassName, annoVal);
                                    continue;
                                }
                                if (itemValue instanceof String) {
                                    isClass = false;
                                    isEnum = false;
                                    isAnnos = false;
                                    sValue[lcv2++] = (String)itemValue;
                                    continue;
                                }
                                if (itemValue instanceof List) {
                                    throw new AssertionError((Object)("Unimplemented declared List type in " + this));
                                }
                                if (itemValue instanceof AnnotationMirror) {
                                    isClass = false;
                                    isEnum = false;
                                    isAnnos = true;
                                    aValue[lcv2++] = new AnnotationMirrorAltAnnotationImpl((AnnotationMirror)itemValue, this.processingEnv);
                                    continue;
                                }
                                throw new AssertionError((Object)("Unknown declared type: " + itemValue.getClass().getName()));
                            }
                            value = isClass ? cValue : (isEnum ? eValue : (isAnnos ? aValue : sValue));
                        } else if (TypeKind.LONG.equals((Object)arrayTypeMirror.getKind())) {
                            iValue = new long[array.size()];
                            lcv = 0;
                            for (AnnotationValue item : array) {
                                iValue[lcv++] = (int)((Long)item.getValue()).longValue();
                            }
                            value = iValue;
                        } else if (TypeKind.SHORT.equals((Object)arrayTypeMirror.getKind())) {
                            iValue = new short[array.size()];
                            lcv = 0;
                            for (AnnotationValue item : array) {
                                iValue[lcv++] = ((Short)item.getValue()).shortValue();
                            }
                            value = iValue;
                        } else if (TypeKind.CHAR.equals((Object)arrayTypeMirror.getKind())) {
                            iValue = new char[array.size()];
                            lcv = 0;
                            for (AnnotationValue item : array) {
                                iValue[lcv++] = ((Character)item.getValue()).charValue();
                            }
                            value = iValue;
                        } else if (TypeKind.FLOAT.equals((Object)arrayTypeMirror.getKind())) {
                            iValue = new float[array.size()];
                            lcv = 0;
                            for (AnnotationValue item : array) {
                                iValue[lcv++] = (int)((Float)item.getValue()).floatValue();
                            }
                            value = iValue;
                        } else if (TypeKind.DOUBLE.equals((Object)arrayTypeMirror.getKind())) {
                            iValue = new double[array.size()];
                            lcv = 0;
                            for (AnnotationValue item : array) {
                                iValue[lcv++] = (int)((Double)item.getValue()).doubleValue();
                            }
                            value = iValue;
                        } else if (TypeKind.BOOLEAN.equals((Object)arrayTypeMirror.getKind())) {
                            iValue = new boolean[array.size()];
                            lcv = 0;
                            for (AnnotationValue item : array) {
                                iValue[lcv++] = ((Boolean)item.getValue()).booleanValue() ? 1 : 0;
                            }
                            value = iValue;
                        } else if (TypeKind.BYTE.equals((Object)arrayTypeMirror.getKind())) {
                            iValue = new byte[array.size()];
                            lcv = 0;
                            for (AnnotationValue item : array) {
                                iValue[lcv++] = ((Byte)item.getValue()).byteValue();
                            }
                            value = iValue;
                        } else {
                            throw new AssertionError((Object)("Array type " + arrayTypeKind + " is not implemented"));
                        }
                    }
                }
                retVal.put(key, value);
            }
            this.values = Collections.unmodifiableMap(retVal);
            Map<String, Object> map = this.values;
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "AnnotationMirrorAltAnnotationImpl(" + this.annotationType() + ")";
    }
}

