/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.basic;

import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.test.basic.beans.Commons;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Test;

public class UnmarshallXMLStreamTest {
    private final XMLInputFactory xif = XMLInputFactory.newInstance();

    private InputStream getStream(String fileName) throws Exception {
        URL url = this.getClass().getClassLoader().getResource(fileName);
        InputStream is = url.openStream();
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterfaceJaxbUnmarshalling() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("museum1.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testInterfaceJaxbUnmarshalling(locator, reader);
        }
    }

    @Test
    public void testInterfaceJaxbUnmarshallingStream() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("museum1.xml");){
            Commons.testInterfaceJaxbUnmarshalling(locator, is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanLikeMapOfInterface() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("Acme1.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testBeanLikeMapOfInterface(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterfaceJaxbUnmarshallingWithChildren() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("Acme1.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testInterfaceJaxbUnmarshallingWithChildren(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComplexUnmarshalling() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("sample-config.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testComplexUnmarshalling(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnkeyedChildren() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("sample-config.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testUnkeyedChildren(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSameClassTwoChildren() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("foobar.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testSameClassTwoChildren(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBeanCycle() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("cycle.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testBeanCycle(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEveryType() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("type1.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testEveryType(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnnotationWithEverythingCopied() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("Acme1.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testAnnotationWithEverythingCopied(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyListChildReturnsEmptyList() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("Acme1.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testEmptyListChildReturnsEmptyList(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyArrayChildReturnsEmptyArray() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("Acme1.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testEmptyArrayChildReturnsEmptyArray(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testByteArrayNonChild() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("Acme2.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testByteArrayNonChild(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJaxbStyleReference() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("sample-config.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testJaxbStyleReference(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJaxbStyleForwardReference() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("reference1.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testJaxbStyleForwardReference(locator, reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXmlJavaTypeAdapter() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        try (InputStream is = this.getStream("xmljavatypeadapter/root-bean-with-properties.xml");
             XMLStreamReader reader = this.xif.createXMLStreamReader(is);){
            Commons.testXmlJavaTypeAdapter(locator, reader);
        }
    }
}

