/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.defaulting;

import java.lang.annotation.Annotation;
import java.net.URL;
import javax.xml.namespace.QName;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans.SSLManagerBean;
import org.glassfish.hk2.xml.test.beans.SecurityManagerBean;
import org.glassfish.hk2.xml.test.defaulting.Colors;
import org.glassfish.hk2.xml.test.defaulting.DefaultedBean;
import org.glassfish.hk2.xml.test.dynamic.merge.MergeTest;
import org.junit.Assert;

public class DefaultingCommon {
    private static final String DEFAULTING_FILE = "defaulted.xml";

    public void testDefaultedValues(XmlService xmlService) throws Exception {
        URL url = this.getClass().getClassLoader().getResource(DEFAULTING_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DefaultedBean.class);
        DefaultedBean db = (DefaultedBean)rootHandle.getRoot();
        XmlHk2ConfigurationBean asBean = (XmlHk2ConfigurationBean)db;
        Assert.assertFalse((boolean)asBean._isSet("int-prop"));
        Assert.assertFalse((boolean)asBean._isSet("long-prop"));
        Assert.assertFalse((boolean)asBean._isSet("short-prop"));
        Assert.assertFalse((boolean)asBean._isSet("byte-prop"));
        Assert.assertFalse((boolean)asBean._isSet("boolean-prop"));
        Assert.assertFalse((boolean)asBean._isSet("char-prop"));
        Assert.assertFalse((boolean)asBean._isSet("float-prop"));
        Assert.assertFalse((boolean)asBean._isSet("double-prop"));
        Assert.assertFalse((boolean)asBean._isSet("string-prop"));
        Assert.assertFalse((boolean)asBean._isSet("qname-prop"));
        Assert.assertFalse((boolean)asBean._isSet("color"));
        Assert.assertEquals((long)13L, (long)db.getIntProp());
        Assert.assertEquals((long)13L, (long)db.getLongProp());
        Assert.assertEquals((long)13L, (long)db.getByteProp());
        Assert.assertEquals((Object)true, (Object)db.isBooleanProp());
        Assert.assertEquals((long)13L, (long)db.getShortProp());
        Assert.assertEquals((long)102L, (long)db.getCharProp());
        Assert.assertEquals((long)0L, (long)Float.compare(13.0f, db.getFloatProp()));
        Assert.assertEquals((long)0L, (long)Double.compare(13.0, db.getDoubleProp()));
        Assert.assertEquals((Object)"13", (Object)db.getStringProp());
        Assert.assertEquals((Object)new QName("http://qwerty.com/qwerty", "foo", "xyz"), (Object)db.getQNameProp());
        Assert.assertEquals((Object)((Object)Colors.GREEN), (Object)((Object)db.getColor()));
        db.setLongProp(13L);
        db.setByteProp((byte)13);
        db.setBooleanProp(true);
        db.setShortProp((short)13);
        db.setCharProp('f');
        db.setFloatProp(13.0f);
        db.setDoubleProp(13.0);
        db.setStringProp("13");
        db.setQNameProp(new QName("http://qwerty.com/qwerty", "foo", "xyz"));
        db.setColor(Colors.GREEN);
        Assert.assertEquals((long)13L, (long)db.getIntProp());
        Assert.assertEquals((long)13L, (long)db.getLongProp());
        Assert.assertEquals((long)13L, (long)db.getByteProp());
        Assert.assertEquals((Object)true, (Object)db.isBooleanProp());
        Assert.assertEquals((long)13L, (long)db.getShortProp());
        Assert.assertEquals((long)102L, (long)db.getCharProp());
        Assert.assertEquals((long)0L, (long)Float.compare(13.0f, db.getFloatProp()));
        Assert.assertEquals((long)0L, (long)Double.compare(13.0, db.getDoubleProp()));
        Assert.assertEquals((Object)"13", (Object)db.getStringProp());
        Assert.assertEquals((Object)new QName("http://qwerty.com/qwerty", "foo", "xyz"), (Object)db.getQNameProp());
        Assert.assertEquals((Object)((Object)Colors.GREEN), (Object)((Object)db.getColor()));
        Assert.assertFalse((boolean)asBean._isSet("int-prop"));
        Assert.assertTrue((boolean)asBean._isSet("long-prop"));
        Assert.assertTrue((boolean)asBean._isSet("short-prop"));
        Assert.assertTrue((boolean)asBean._isSet("byte-prop"));
        Assert.assertTrue((boolean)asBean._isSet("boolean-prop"));
        Assert.assertTrue((boolean)asBean._isSet("char-prop"));
        Assert.assertTrue((boolean)asBean._isSet("float-prop"));
        Assert.assertTrue((boolean)asBean._isSet("double-prop"));
        Assert.assertTrue((boolean)asBean._isSet("string-prop"));
        Assert.assertTrue((boolean)asBean._isSet("qname-prop"));
        Assert.assertTrue((boolean)asBean._isSet("color"));
    }

    public void testDefaultDefaultedValues(XmlService xmlService) throws Exception {
        URL url = this.getClass().getClassLoader().getResource(DEFAULTING_FILE);
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DefaultedBean.class);
        DefaultedBean db = (DefaultedBean)rootHandle.getRoot();
        Assert.assertEquals((long)0L, (long)db.getDefaultIntProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultLongProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultByteProp());
        Assert.assertEquals((Object)false, (Object)db.isDefaultBooleanProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultShortProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultCharProp());
        Assert.assertEquals((long)0L, (long)Float.compare(0.0f, db.getDefaultFloatProp()));
        Assert.assertEquals((long)0L, (long)Double.compare(0.0, db.getDefaultDoubleProp()));
        Assert.assertEquals(null, (Object)db.getDefaultStringProp());
        Assert.assertNull((Object)db.getDefaultQNameProp());
        Assert.assertNull((Object)((Object)db.getDefaultColor()));
    }

    public void testCanGetValuesFromDynamicallyCreatedBean(XmlService xmlService) {
        DefaultedBean db = (DefaultedBean)xmlService.createBean(DefaultedBean.class);
        Assert.assertEquals((long)13L, (long)db.getIntProp());
        Assert.assertEquals((long)13L, (long)db.getLongProp());
        Assert.assertEquals((long)13L, (long)db.getByteProp());
        Assert.assertEquals((Object)true, (Object)db.isBooleanProp());
        Assert.assertEquals((long)13L, (long)db.getShortProp());
        Assert.assertEquals((long)102L, (long)db.getCharProp());
        Assert.assertEquals((long)0L, (long)Float.compare(13.0f, db.getFloatProp()));
        Assert.assertEquals((long)0L, (long)Double.compare(13.0, db.getDoubleProp()));
        Assert.assertEquals((Object)"13", (Object)db.getStringProp());
        Assert.assertEquals((Object)((Object)Colors.GREEN), (Object)((Object)db.getColor()));
        Assert.assertEquals((long)0L, (long)db.getDefaultIntProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultLongProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultByteProp());
        Assert.assertEquals((Object)false, (Object)db.isDefaultBooleanProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultShortProp());
        Assert.assertEquals((long)0L, (long)db.getDefaultCharProp());
        Assert.assertEquals((long)0L, (long)Float.compare(0.0f, db.getDefaultFloatProp()));
        Assert.assertEquals((long)0L, (long)Double.compare(0.0, db.getDefaultDoubleProp()));
        Assert.assertEquals(null, (Object)db.getDefaultStringProp());
        Assert.assertNull((Object)((Object)db.getDefaultColor()));
    }

    public void testDefaultingViaServiceWorks(ServiceLocator locator, XmlService xmlService) throws Exception {
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator, true);
        SecurityManagerBean smb = (SecurityManagerBean)locator.getService(SecurityManagerBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)smb);
        Assert.assertNotNull((Object)smb.getSSLManager());
        Assert.assertNotNull((Object)locator.getService(SSLManagerBean.class, new Annotation[0]));
    }

    public void testDefaultingViaAddWorks(ServiceLocator locator, XmlService xmlService) throws Exception {
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator, true);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        domain.setSecurityManager(null);
        Assert.assertNull((Object)locator.getService(SSLManagerBean.class, new Annotation[0]));
        SecurityManagerBean smb = (SecurityManagerBean)xmlService.createBean(SecurityManagerBean.class);
        domain.setSecurityManager(smb);
        smb = domain.getSecurityManager();
        Assert.assertNotNull((Object)smb);
        Assert.assertNotNull((Object)smb.getSSLManager());
        Assert.assertNotNull((Object)locator.getService(SecurityManagerBean.class, new Annotation[0]));
        Assert.assertNotNull((Object)smb.getSSLManager());
        Assert.assertNotNull((Object)locator.getService(SSLManagerBean.class, new Annotation[0]));
    }
}

