/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.defaulting;

import java.lang.annotation.Annotation;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.beans.SSLManagerBeanCustomizer;
import org.glassfish.hk2.xml.test.defaulting.DefaultingCommon;
import org.glassfish.hk2.xml.test.defaulting.SecurityManagerBeanDefaulter;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Test;

public class DefaultingTest {
    private static final String DEFAULTING_FILE = "defaulted.xml";
    private final DefaultingCommon commons = new DefaultingCommon();

    @Test
    public void testDefaultedValues() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, "JAXBXmlParsingService", new Annotation[0]);
        this.commons.testDefaultedValues(xmlService);
    }

    @Test
    public void testDefaultedValuesStream() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, "StreamXmlParsingService", new Annotation[0]);
        this.commons.testDefaultedValues(xmlService);
    }

    @Test
    public void testDefaultDefaultedValues() throws Exception {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, "JAXBXmlParsingService", new Annotation[0]);
        this.commons.testDefaultDefaultedValues(xmlService);
    }

    @Test
    public void testDefaultDefaultedValuesString() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, "StreamXmlParsingService", new Annotation[0]);
        this.commons.testDefaultDefaultedValues(xmlService);
    }

    @Test
    public void testCanGetValuesFromDynamicallyCreatedBean() {
        ServiceLocator locator = Utilities.createLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, "JAXBXmlParsingService", new Annotation[0]);
        this.commons.testCanGetValuesFromDynamicallyCreatedBean(xmlService);
    }

    @Test
    public void testCanGetValuesFromDynamicallyCreatedBeanStream() {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, "StreamXmlParsingService", new Annotation[0]);
        this.commons.testCanGetValuesFromDynamicallyCreatedBean(xmlService);
    }

    @Test
    public void testDefaultingViaServiceWorks() throws Exception {
        ServiceLocator locator = Utilities.createLocator(SSLManagerBeanCustomizer.class, SecurityManagerBeanDefaulter.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, "JAXBXmlParsingService", new Annotation[0]);
        this.commons.testDefaultingViaServiceWorks(locator, xmlService);
    }

    @Test
    public void testDefaultingViaServiceWorksStream() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(SSLManagerBeanCustomizer.class, SecurityManagerBeanDefaulter.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, "StreamXmlParsingService", new Annotation[0]);
        this.commons.testDefaultingViaServiceWorks(locator, xmlService);
    }

    @Test
    public void testDefaultingViaAddWorks() throws Exception {
        ServiceLocator locator = Utilities.createLocator(SSLManagerBeanCustomizer.class, SecurityManagerBeanDefaulter.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, "JAXBXmlParsingService", new Annotation[0]);
        this.commons.testDefaultingViaAddWorks(locator, xmlService);
    }

    @Test
    public void testDefaultingViaAddWorksStream() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(SSLManagerBeanCustomizer.class, SecurityManagerBeanDefaulter.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, "StreamXmlParsingService", new Annotation[0]);
        this.commons.testDefaultingViaAddWorks(locator, xmlService);
    }
}

