/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.dynamic.rawsets;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.configuration.hub.api.BeanDatabase;
import org.glassfish.hk2.configuration.hub.api.Change;
import org.glassfish.hk2.configuration.hub.api.Hub;
import org.glassfish.hk2.configuration.hub.api.Instance;
import org.glassfish.hk2.xml.api.XmlHk2ConfigurationBean;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.test.basic.beans.Museum;
import org.glassfish.hk2.xml.test.beans.AuthorizationProviderBean;
import org.glassfish.hk2.xml.test.beans.DiagnosticsBean;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.beans.JMSServerBean;
import org.glassfish.hk2.xml.test.beans.MachineBean;
import org.glassfish.hk2.xml.test.beans.SSLManagerBean;
import org.glassfish.hk2.xml.test.beans.SSLManagerBeanCustomizer;
import org.glassfish.hk2.xml.test.beans.SecurityManagerBean;
import org.glassfish.hk2.xml.test.dynamic.merge.MergeTest;
import org.glassfish.hk2.xml.test.dynamic.overlay.ChangeDescriptor;
import org.glassfish.hk2.xml.test.dynamic.overlay.OverlayUtilities;
import org.glassfish.hk2.xml.test.dynamic.rawsets.UpdateListener;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Assert;
import org.junit.Test;

public class RawSetsTest {
    public static final String MUSEUM2_FILE = "museum2.xml";
    public static final String MUSEUM_TYPE = "/museum";
    public static final String MUSEUM_INSTANCE = "museum";
    private static final String JMS_SERVER_PROPERTY = "jms-server";
    private static final String MACHINE_PROPERTY = "machine";
    private static final String AUTHORIZATION_PROVIDER_PROPERTY = "authorization-provider";
    public static final String AGE_TAG = "age";
    public static final int ONE_OH_ONE_INT = 101;

    public static void verifyPreState(XmlRootHandle<Museum> rootHandle, Hub hub) {
        Museum museum = (Museum)rootHandle.getRoot();
        Assert.assertEquals((long)100L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)110L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance(MUSEUM_TYPE, MUSEUM_INSTANCE);
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)100, beanLikeMap.get("id"));
        Assert.assertEquals((Object)110, beanLikeMap.get(AGE_TAG));
    }

    @Test
    public void testModifySingleProperty() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("museum1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), Museum.class);
        RawSetsTest.verifyPreState((XmlRootHandle<Museum>)rootHandle, hub);
        Museum museum = (Museum)rootHandle.getRoot();
        museum.setAge(101);
        Assert.assertEquals((long)100L, (long)museum.getId());
        Assert.assertEquals((Object)"Ben Franklin", (Object)museum.getName());
        Assert.assertEquals((long)101L, (long)museum.getAge());
        Instance instance = hub.getCurrentDatabase().getInstance(MUSEUM_TYPE, MUSEUM_INSTANCE);
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertEquals((Object)"Ben Franklin", beanLikeMap.get("name"));
        Assert.assertEquals((Object)100, beanLikeMap.get("id"));
        Assert.assertEquals((Object)101, beanLikeMap.get(AGE_TAG));
        List<Change> changes = listener.getChanges();
        Assert.assertNotNull(changes);
        Assert.assertEquals((long)1L, (long)changes.size());
        for (Change change : changes) {
            Assert.assertEquals((Object)Change.ChangeCategory.MODIFY_INSTANCE, (Object)change.getChangeCategory());
        }
    }

    @Test
    public void testAddDirectTypeWithSet() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        SecurityManagerBean securityManager = domain.getSecurityManager();
        SSLManagerBean sslManager = (SSLManagerBean)xmlService.createBean(SSLManagerBean.class);
        securityManager.setSSLManager(sslManager);
        sslManager = securityManager.getSSLManager();
        Assert.assertEquals((Object)securityManager, (Object)((XmlHk2ConfigurationBean)sslManager)._getParent());
        Assert.assertEquals((Object)"Fort Knox", (Object)sslManager.getSSLPrivateKeyLocation());
        Assert.assertEquals((Object)sslManager, (Object)locator.getService(SSLManagerBean.class, new Annotation[0]));
        Instance instance = hub.getCurrentDatabase().getInstance("/domain/security-manager/ssl-manager", "domain.security-manager.ssl-manager");
        Map beanLikeMap = (Map)instance.getBean();
        Assert.assertNotNull((Object)beanLikeMap);
        Assert.assertTrue((boolean)beanLikeMap.isEmpty());
    }

    @Test
    public void testRemoveDirectTypeWithSet() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        domain.setSecurityManager(null);
        Assert.assertNull((Object)domain.getSecurityManager());
        Assert.assertNull((Object)locator.getService(SecurityManagerBean.class, new Annotation[0]));
        Assert.assertNull((Object)locator.getService(AuthorizationProviderBean.class, new Annotation[0]));
        Assert.assertNull((Object)hub.getCurrentDatabase().getInstance("/domain/security-manager", "domain.security-manager"));
        Assert.assertNull((Object)hub.getCurrentDatabase().getInstance("/domain/security-manager/authorization-provider", "RSA"));
    }

    @Test
    public void testNullToNull() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        SecurityManagerBean securityManagerBean = domain.getSecurityManager();
        securityManagerBean.setSSLManager(null);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
    }

    @Test
    public void testSameToSame() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        SecurityManagerBean securityManagerBean = domain.getSecurityManager();
        domain.setSecurityManager(securityManagerBean);
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
    }

    @Test
    public void testArrayListSwap() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        URL url = this.getClass().getClassLoader().getResource("domain1.xml");
        XmlRootHandle rootHandle = xmlService.unmarshal(url.toURI(), DomainBean.class);
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        MergeTest.verifyDomain1Xml((XmlRootHandle<DomainBean>)rootHandle, hub, locator);
        JMSServerBean[] newBeans = new JMSServerBean[2];
        JMSServerBean[] oldBeans = domain.getJMSServers();
        newBeans[0] = oldBeans[1];
        newBeans[1] = oldBeans[0];
        domain.setJMSServers(newBeans);
        JMSServerBean[] changedBeans = domain.getJMSServers();
        Assert.assertEquals((Object)"Dave", (Object)changedBeans[0].getName());
        Assert.assertEquals((Object)"Carol", (Object)changedBeans[1].getName());
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/domain", "domain", null, JMS_SERVER_PROPERTY));
    }

    @Test
    public void testListSetModificationsSwap() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.createEmptyHandle(DomainBean.class);
        rootHandle.addRoot();
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        MachineBean aliceBean = RawSetsTest.createMachineBean(xmlService, "Alice");
        MachineBean bobBean = RawSetsTest.createMachineBean(xmlService, "Bob");
        MachineBean carolBean = RawSetsTest.createMachineBean(xmlService, "Carol");
        LinkedList<MachineBean> allBeans = new LinkedList<MachineBean>();
        allBeans.add(aliceBean);
        allBeans.add(bobBean);
        allBeans.add(carolBean);
        domain.setMachines(allBeans);
        allBeans.clear();
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_TYPE, "/domain/machine", null, null, new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/domain/machine", "domain.Alice", "Alice", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/domain/machine", "domain.Bob", "Bob", new String[0]), new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/domain/machine", "domain.Carol", "Carol", new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/domain", "domain", null, MACHINE_PROPERTY));
        Assert.assertNotNull((Object)locator.getService(MachineBean.class, "Alice", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(MachineBean.class, "Bob", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(MachineBean.class, "Carol", new Annotation[0]));
        Assert.assertNull((Object)locator.getService(MachineBean.class, "Dave", new Annotation[0]));
        List<MachineBean> fromRootMachines = domain.getMachines();
        Assert.assertEquals((long)3L, (long)fromRootMachines.size());
        Assert.assertEquals((Object)"Alice", (Object)fromRootMachines.get(0).getName());
        Assert.assertEquals((Object)"Bob", (Object)fromRootMachines.get(1).getName());
        Assert.assertEquals((Object)"Carol", (Object)fromRootMachines.get(2).getName());
        RawSetsTest.checkHubInstanceWithName(hub, "/domain/machine", "domain.Alice", "Alice");
        RawSetsTest.checkHubInstanceWithName(hub, "/domain/machine", "domain.Bob", "Bob");
        RawSetsTest.checkHubInstanceWithName(hub, "/domain/machine", "domain.Carol", "Carol");
        RawSetsTest.checkHubNoInstance(hub, "/domain/machine", "domain.Dave");
        MachineBean daveBean = RawSetsTest.createMachineBean(xmlService, "Dave");
        allBeans.add(carolBean);
        allBeans.add(daveBean);
        allBeans.add(aliceBean);
        domain.setMachines(allBeans);
        Assert.assertNotNull((Object)locator.getService(MachineBean.class, "Alice", new Annotation[0]));
        Assert.assertNull((Object)locator.getService(MachineBean.class, "Bob", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(MachineBean.class, "Carol", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(MachineBean.class, "Dave", new Annotation[0]));
        fromRootMachines = domain.getMachines();
        Assert.assertEquals((long)3L, (long)fromRootMachines.size());
        Assert.assertEquals((Object)"Carol", (Object)fromRootMachines.get(0).getName());
        Assert.assertEquals((Object)"Dave", (Object)fromRootMachines.get(1).getName());
        Assert.assertEquals((Object)"Alice", (Object)fromRootMachines.get(2).getName());
        RawSetsTest.checkHubInstanceWithName(hub, "/domain/machine", "domain.Alice", "Alice");
        RawSetsTest.checkHubNoInstance(hub, "/domain/machine", "domain.Bob");
        RawSetsTest.checkHubInstanceWithName(hub, "/domain/machine", "domain.Carol", "Carol");
        RawSetsTest.checkHubInstanceWithName(hub, "/domain/machine", "domain.Dave", "Dave");
        changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/domain/machine", "domain.Dave", "Dave", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/domain/machine", "domain.Bob", "Bob", new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/domain", "domain", null, MACHINE_PROPERTY));
    }

    @Test
    public void testDirectSetModification() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.createEmptyHandle(DomainBean.class);
        rootHandle.addRoot();
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        SecurityManagerBean originalSM = (SecurityManagerBean)xmlService.createBean(SecurityManagerBean.class);
        AuthorizationProviderBean aliceBean = RawSetsTest.createAuthorizationProviderBean(xmlService, "Alice");
        originalSM.addAuthorizationProvider(aliceBean);
        domain.setSecurityManager(originalSM);
        Assert.assertNotNull((Object)locator.getService(AuthorizationProviderBean.class, "Alice", new Annotation[0]));
        Assert.assertNull((Object)locator.getService(AuthorizationProviderBean.class, "Bob", new Annotation[0]));
        RawSetsTest.checkHubInstanceWithName(hub, "/domain/security-manager/authorization-provider", "domain.security-manager.Alice", "Alice");
        RawSetsTest.checkHubNoInstance(hub, "/domain/security-manager/authorization-provider", "domain.security-manager.Bob");
        SecurityManagerBean newSM = (SecurityManagerBean)xmlService.createBean(SecurityManagerBean.class);
        AuthorizationProviderBean bobBean = RawSetsTest.createAuthorizationProviderBean(xmlService, "Bob");
        newSM.addAuthorizationProvider(bobBean);
        domain.setSecurityManager(newSM);
        Assert.assertNull((Object)locator.getService(AuthorizationProviderBean.class, "Alice", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(AuthorizationProviderBean.class, "Bob", new Annotation[0]));
        RawSetsTest.checkHubInstanceWithName(hub, "/domain/security-manager/authorization-provider", "domain.security-manager.Bob", "Bob");
        RawSetsTest.checkHubNoInstance(hub, "/domain/security-manager/authorization-provider", "domain.security-manager.Alice");
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/domain/security-manager/authorization-provider", "domain.security-manager.Bob", "Bob", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/domain/security-manager/authorization-provider", "domain.security-manager.Alice", "Alice", new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/domain/security-manager", "domain.security-manager", null, AUTHORIZATION_PROVIDER_PROPERTY));
    }

    @Test
    public void testKeyedDirectSetModification() throws Exception {
        ServiceLocator locator = Utilities.createLocator(UpdateListener.class, SSLManagerBeanCustomizer.class);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        Hub hub = (Hub)locator.getService(Hub.class, new Annotation[0]);
        XmlRootHandle rootHandle = xmlService.createEmptyHandle(DomainBean.class);
        rootHandle.addRoot();
        DomainBean domain = (DomainBean)rootHandle.getRoot();
        DiagnosticsBean aliceBean = RawSetsTest.createDiagnosticsBean(xmlService, "Alice");
        domain.setDiagnostics(aliceBean);
        Assert.assertNotNull((Object)locator.getService(DiagnosticsBean.class, "Alice", new Annotation[0]));
        Assert.assertNull((Object)locator.getService(DiagnosticsBean.class, "Bob", new Annotation[0]));
        RawSetsTest.checkHubInstanceWithName(hub, "/domain/diagnostics", "domain.Alice", "Alice");
        RawSetsTest.checkHubNoInstance(hub, "/domain/diagnostics", "domain.Bob");
        DiagnosticsBean bobBean = RawSetsTest.createDiagnosticsBean(xmlService, "Bob");
        domain.setDiagnostics(bobBean);
        Assert.assertNull((Object)locator.getService(DiagnosticsBean.class, "Alice", new Annotation[0]));
        Assert.assertNotNull((Object)locator.getService(DiagnosticsBean.class, "Bob", new Annotation[0]));
        RawSetsTest.checkHubInstanceWithName(hub, "/domain/diagnostics", "domain.Bob", "Bob");
        RawSetsTest.checkHubNoInstance(hub, "/domain/diagnostics", "domain.Alice");
        UpdateListener listener = (UpdateListener)locator.getService(UpdateListener.class, new Annotation[0]);
        List<Change> changes = listener.getChanges();
        OverlayUtilities.checkChanges(changes, new ChangeDescriptor(Change.ChangeCategory.ADD_INSTANCE, "/domain/diagnostics", "domain.Bob", "Bob", new String[0]), new ChangeDescriptor(Change.ChangeCategory.REMOVE_INSTANCE, "/domain/diagnostics", "domain.Alice", "Alice", new String[0]), new ChangeDescriptor(Change.ChangeCategory.MODIFY_INSTANCE, "/domain", "domain", null, "diagnostics"));
    }

    private static void checkHubNoInstance(Hub hub, String typeName, String instanceName) {
        BeanDatabase bd = hub.getCurrentDatabase();
        Instance instance = bd.getInstance(typeName, instanceName);
        Assert.assertNull((Object)instance);
    }

    private static void checkHubInstanceWithName(Hub hub, String typeName, String instanceName, String name) {
        BeanDatabase bd = hub.getCurrentDatabase();
        Instance instance = bd.getInstance(typeName, instanceName);
        Assert.assertNotNull((Object)instance);
        Map bean = (Map)instance.getBean();
        Assert.assertNotNull((Object)bean);
        Assert.assertEquals((Object)name, bean.get("name"));
    }

    private static final MachineBean createMachineBean(XmlService xmlService, String name) {
        MachineBean retVal = (MachineBean)xmlService.createBean(MachineBean.class);
        retVal.setName(name);
        return retVal;
    }

    private static final AuthorizationProviderBean createAuthorizationProviderBean(XmlService xmlService, String name) {
        AuthorizationProviderBean retVal = (AuthorizationProviderBean)xmlService.createBean(AuthorizationProviderBean.class);
        retVal.setName(name);
        return retVal;
    }

    public static final DiagnosticsBean createDiagnosticsBean(XmlService xmlService, String name) {
        DiagnosticsBean retVal = (DiagnosticsBean)xmlService.createBean(DiagnosticsBean.class);
        retVal.setName(name);
        return retVal;
    }
}

