/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.xml.test.negative.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.glassfish.hk2.xml.api.XmlRootHandle;
import org.glassfish.hk2.xml.api.XmlService;
import org.glassfish.hk2.xml.spi.XmlServiceParser;
import org.glassfish.hk2.xml.test.beans.DomainBean;
import org.glassfish.hk2.xml.test.utilities.Utilities;
import org.junit.Test;

public class NegativeAPITest {
    private static final File OUTPUT_FILE = new File("negative-output.xml");
    private static final Filter PARSER_REMOVE_FILTER = BuilderHelper.createContractFilter((String)XmlServiceParser.class.getName());
    private final URL DOMAIN_URL = this.getClass().getClassLoader().getResource("domain1.xml");
    private final XMLInputFactory xif = XMLInputFactory.newInstance();

    private XMLStreamReader openDomainReader() throws Exception {
        InputStream is = this.DOMAIN_URL.openStream();
        return this.xif.createXMLStreamReader(is);
    }

    private InputStream openDomainInputStream() throws Exception {
        return this.DOMAIN_URL.openStream();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullURIXmlServiceUnmarshal() {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        xmlService.unmarshal((URI)null, DomainBean.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullBeanXmlServiceUnmarshal() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URI uri = this.DOMAIN_URL.toURI();
        xmlService.unmarshal(uri, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBeanIsClassXmlServiceUnmarshal() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        URI uri = this.DOMAIN_URL.toURI();
        xmlService.unmarshal(uri, NegativeAPITest.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullReaderXmlServiceUnmarshal() {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        xmlService.unmarshal((XMLStreamReader)null, DomainBean.class, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testNullBeanXmlServiceUnmarshalReader() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        try (XMLStreamReader reader = this.openDomainReader();){
            xmlService.unmarshal(reader, null, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testBeanIsClassXmlServiceUnmarshalReader() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        try (XMLStreamReader reader = this.openDomainReader();){
            xmlService.unmarshal(reader, NegativeAPITest.class, true, false);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullInputStreamXmlServiceUnmarshal() {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        xmlService.unmarshal((InputStream)null, DomainBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testNullBeanXmlServiceUnmarshalInputStream() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        try (InputStream reader = this.openDomainInputStream();){
            xmlService.unmarshal(reader, null, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testBeanIsClassXmlServiceUnmarshalInputStream() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        try (InputStream reader = this.openDomainInputStream();){
            xmlService.unmarshal(reader, NegativeAPITest.class, true, false);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testNoParserXmlServiceUnmarshalURI() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        NegativeAPITest.removeParser(locator);
        xmlService.unmarshal(this.DOMAIN_URL.toURI(), DomainBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testNoParserXmlServiceUnmarshalInputStream() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        NegativeAPITest.removeParser(locator);
        try (InputStream reader = this.openDomainInputStream();){
            xmlService.unmarshal(reader, DomainBean.class, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalStateException.class)
    public void testNoParserXmlServiceMarshal() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        XmlRootHandle handle = xmlService.unmarshal(this.DOMAIN_URL.toURI(), DomainBean.class);
        NegativeAPITest.removeParser(locator);
        try (FileOutputStream fos = new FileOutputStream(OUTPUT_FILE);){
            xmlService.marshal((OutputStream)fos, handle);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testXmlServiceEmptyHandleBadInput() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        xmlService.createEmptyHandle(NegativeAPITest.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testXmlServiceCreateBeanBadInput() throws Exception {
        ServiceLocator locator = Utilities.createDomLocator(new Class[0]);
        XmlService xmlService = (XmlService)locator.getService(XmlService.class, new Annotation[0]);
        xmlService.createBean(NegativeAPITest.class);
    }

    private static void removeParser(ServiceLocator locator) {
        ServiceLocatorUtilities.removeFilter((ServiceLocator)locator, (Filter)PARSER_REMOVE_FILTER);
    }
}

