/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.bootstrap.ModuleStartup;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.logging.Level;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.ServiceLocatorFactory;
import org.glassfish.hk2.bootstrap.DescriptorFileFinder;
import org.glassfish.hk2.bootstrap.HK2Populator;
import org.glassfish.hk2.bootstrap.PopulatorPostProcessor;
import org.glassfish.hk2.bootstrap.impl.URLDescriptorFileFinder;
import org.glassfish.hk2.extension.ServiceLocatorGenerator;
import org.jvnet.hk2.external.generator.ServiceLocatorGeneratorImpl;
import org.jvnet.hk2.osgiadapter.BundleEventType;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OsgiHk2Loader;
import org.jvnet.hk2.osgiadapter.OsgiPopulatorPostProcessor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class ServiceLocatorActivator
implements BundleActivator,
SynchronousBundleListener {
    public final String DEFAULT_NAME = "_SERVICELOCATOR_DEFAULT";
    private BundleContext bundleContext;
    private ServiceLocator serviceLocator;
    private ServiceRegistration serviceLocatorRegistration;

    public ServiceLocatorActivator() {
    }

    ServiceLocatorActivator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private void destroyServiceLocator(ServiceLocator serviceLocator) {
        ServiceLocatorFactory.getInstance().destroy(serviceLocator.getName());
        this.serviceLocatorRegistration.unregister();
    }

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        Logger.logger.entering(this.getClass().getSimpleName(), "start", new Object[]{context});
        this.serviceLocator = ServiceLocatorFactory.getInstance().create("_SERVICELOCATOR_DEFAULT", null, (ServiceLocatorGenerator)new ServiceLocatorGeneratorImpl());
        this.serviceLocatorRegistration = this.bundleContext.registerService(ServiceLocator.class.getName(), (Object)this.serviceLocator, null);
        context.addBundleListener((BundleListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        ModuleStartup startupService = (ModuleStartup)this.serviceLocator.getService(ModuleStartup.class, new Annotation[0]);
        if (startupService != null) {
            try {
                Logger.logger.info("Stopping " + startupService);
                startupService.stop();
            }
            catch (Exception e) {
                Logger.logger.log(Level.WARNING, "HK2Main:stop():Exception while stopping ModuleStartup service.", e);
            }
        }
        this.destroyServiceLocator(this.serviceLocator);
    }

    public void bundleChanged(BundleEvent event) {
        Logger.logger.logp(Level.FINE, this.getClass().getSimpleName(), "bundleChanged", "source= {0}, type= {1}", new Object[]{event.getSource(), BundleEventType.valueOf(event.getType())});
        switch (event.getType()) {
            case 2: {
                Bundle bundle = event.getBundle();
                URL url = bundle.getResource("/META-INF/hk2-locator/default");
                if (url == null) break;
                try {
                    OsgiHk2Loader hk2Loader = new OsgiHk2Loader(bundle);
                    HK2Populator.populate((ServiceLocator)ServiceLocatorFactory.getInstance().create("_SERVICELOCATOR_DEFAULT", null, (ServiceLocatorGenerator)new ServiceLocatorGeneratorImpl()), (DescriptorFileFinder)new URLDescriptorFileFinder(url), (PopulatorPostProcessor)new OsgiPopulatorPostProcessor(hk2Loader));
                }
                catch (Exception e) {
                    Logger.logger.log(Level.SEVERE, "Exception while binding HK2 service.", e);
                }
                break;
            }
        }
    }
}

