/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleDependency;
import com.sun.enterprise.module.ModuleMetadata;
import com.sun.enterprise.module.common_impl.Jar;
import com.sun.enterprise.module.common_impl.LogHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.jvnet.hk2.osgiadapter.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class OSGiModuleDefinition
implements ModuleDefinition,
Serializable {
    private String name;
    private String bundleName;
    private URI location;
    private String version;
    private Manifest manifest;
    private String lifecyclePolicyClassName;
    private ModuleMetadata metadata = new ModuleMetadata();
    List<ActiveDescriptor> descriptors;

    public OSGiModuleDefinition(File jar) throws IOException {
        this(Jar.create((File)jar), jar.toURI());
    }

    public OSGiModuleDefinition(Jar jarFile, URI location) throws IOException {
        this.location = location;
        Manifest m = jarFile.getManifest();
        this.manifest = m instanceof Serializable ? m : new SerializableManifest(m);
        Attributes mainAttr = this.manifest.getMainAttributes();
        this.bundleName = mainAttr.getValue("Bundle-Name");
        this.name = mainAttr.getValue("Bundle-SymbolicName");
        if (this.name == null) {
            this.name = location.toString();
        }
        this.version = mainAttr.getValue("Bundle-Version");
        this.lifecyclePolicyClassName = mainAttr.getValue("HK2-Module-Lifecycle-Policy");
        jarFile.loadMetadata(this.metadata);
    }

    public OSGiModuleDefinition(Bundle b) throws IOException, URISyntaxException {
        this(new BundleJar(b), OSGiModuleDefinition.toURI(b));
    }

    static URI toURI(Bundle b) throws URISyntaxException {
        try {
            return new URI(b.getLocation());
        }
        catch (URISyntaxException ue) {
            if (b.getLocation().startsWith("initial@")) {
                return new URI(b.getLocation().substring("initial@".length()));
            }
            throw ue;
        }
    }

    public String getName() {
        return this.name;
    }

    public String[] getPublicInterfaces() {
        throw new UnsupportedOperationException("This method should not be called in OSGi environment, hence not supported");
    }

    public ModuleDependency[] getDependencies() {
        ArrayList<ModuleDependency> mds = new ArrayList<ModuleDependency>();
        String requiredBundles = this.getManifest().getMainAttributes().getValue("Require-Bundle");
        if (requiredBundles != null) {
            int i1;
            Logger.logger.log(Level.INFO, this.name + " -> " + requiredBundles);
            while ((i1 = requiredBundles.indexOf(34)) != -1) {
                int i2 = requiredBundles.indexOf(34, i1 + 1);
                StringBuilder sb = new StringBuilder();
                sb.append(requiredBundles.substring(0, i1));
                sb.append(requiredBundles.substring(i2 + 1));
                requiredBundles = sb.toString();
            }
            StringTokenizer st = new StringTokenizer(requiredBundles, ",", false);
            while (st.hasMoreTokens()) {
                String requireBundle = st.nextToken();
                int idx = requireBundle.indexOf(59);
                String requiredBundleName = idx == -1 ? requireBundle : requireBundle.substring(0, idx);
                mds.add(new ModuleDependency(requiredBundleName, null));
            }
        }
        return mds.toArray(new ModuleDependency[mds.size()]);
    }

    public URI[] getLocations() {
        return new URI[]{this.location};
    }

    public String getVersion() {
        return this.version;
    }

    public String getImportPolicyClassName() {
        throw new UnsupportedOperationException("This method should not be called in OSGi environment, hence not supported");
    }

    public String getLifecyclePolicyClassName() {
        return this.lifecyclePolicyClassName;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public ModuleMetadata getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return this.name + "(" + this.bundleName + ")" + ':' + this.version;
    }

    private static class SerializableManifest
    extends Manifest
    implements Serializable {
        private SerializableManifest() {
        }

        private SerializableManifest(Manifest man) {
            super(man);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            this.write(out);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.read(in);
        }
    }

    private static class BundleJar
    extends Jar {
        private static final String HK2_DESCRIPTOR_LOCATION = "META-INF/hk2-locator";
        private static final String SERVICE_LOCATION = "META-INF/services";
        Bundle b;
        Manifest m;

        private BundleJar(Bundle b) throws IOException {
            this.b = b;
            this.m = new BundleManifest(b);
        }

        public Manifest getManifest() throws IOException {
            return this.m;
        }

        public void loadMetadata(ModuleMetadata result) {
            this.parseServiceDescriptors(result);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseServiceDescriptors(ModuleMetadata result) {
            if (this.b.getEntry(SERVICE_LOCATION) == null) {
                return;
            }
            Enumeration entries = this.b.getEntryPaths(SERVICE_LOCATION);
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    String entry = (String)entries.nextElement();
                    String serviceName = entry.substring(SERVICE_LOCATION.length() + 1);
                    InputStream is = null;
                    URL url = this.b.getEntry(entry);
                    try {
                        is = url.openStream();
                        result.load(url, serviceName, is);
                    }
                    catch (IOException e) {
                        LogHelper.getDefaultLogger().log(Level.SEVERE, "Error reading service provider in " + this.b.getLocation(), e);
                    }
                    finally {
                        if (is == null) continue;
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] loadFully(URL url) throws IOException {
            InputStream in = url.openStream();
            byte[] buf = new byte[]{};
            try {
                int count;
                int chunkSize = 512;
                byte[] chunk = new byte[chunkSize];
                while ((count = in.read(chunk, 0, chunkSize)) != -1) {
                    int curLength = buf.length;
                    byte[] newbuf = new byte[curLength + count];
                    System.arraycopy(buf, 0, newbuf, 0, curLength);
                    System.arraycopy(chunk, 0, newbuf, curLength, count);
                    buf = newbuf;
                }
                byte[] byArray = buf;
                return byArray;
            }
            finally {
                in.close();
            }
        }

        public String getBaseName() {
            throw new UnsupportedOperationException("Method not implemented");
        }

        private static class BundleManifest
        extends Manifest
        implements Serializable {
            private long bundleId;

            private BundleManifest() {
            }

            private BundleManifest(Bundle b) {
                this.bundleId = b.getBundleId();
                this.init(b);
            }

            private void init(Bundle b) {
                Attributes attrs = this.getMainAttributes();
                Dictionary headers = b.getHeaders();
                for (Object o : Collections.list(headers.keys())) {
                    attrs.putValue((String)o, (String)headers.get(o));
                }
            }

            private void writeObject(ObjectOutputStream out) throws IOException {
                out.defaultWriteObject();
            }

            private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
                in.defaultReadObject();
                ClassLoader cl = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return this.getClass().getClassLoader();
                    }
                }) : this.getClass().getClassLoader();
                this.init(((BundleReference)BundleReference.class.cast(cl)).getBundle().getBundleContext().getBundle(this.bundleId));
            }
        }
    }
}

