/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.AbstractOSGiModulesRegistryImpl;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.OSGiModuleDefinition;
import org.jvnet.hk2.osgiadapter.OSGiModuleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class OSGiModulesRegistryImpl
extends AbstractOSGiModulesRegistryImpl
implements SynchronousBundleListener {
    private Map<URI, ModuleDefinition> cachedData = new HashMap<URI, ModuleDefinition>();
    private boolean cacheInvalidated = false;

    OSGiModulesRegistryImpl(BundleContext bctx) {
        super(bctx);
        bctx.addBundleListener((BundleListener)this);
        try {
            this.loadCachedData();
        }
        catch (Exception e) {
            Logger.logger.log(Level.WARNING, "Cannot load cached metadata, will recreate the cache", e);
            this.cachedData.clear();
        }
        for (Bundle b : bctx.getBundles()) {
            if (b.getLocation().equals("System Bundle")) continue;
            try {
                this.add(this.makeModule(b));
            }
            catch (Exception e) {
                Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "OSGiModulesRegistryImpl", "Not able convert bundle [{0}] having location [{1}] to module because of exception: {2}", new Object[]{b, b.getLocation(), e});
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        try {
            Bundle bundle = event.getBundle();
            switch (event.getType()) {
                case 1: {
                    if (!Logger.logger.isLoggable(Level.FINE)) break;
                    Logger.logger.fine("[" + bundle.getBundleId() + "] " + bundle.getSymbolicName() + " installed");
                    break;
                }
                case 32: {
                    OSGiModuleImpl m = this.makeModule(bundle);
                    this.add(m);
                    break;
                }
                case 16: {
                    Module m = this.getModule(bundle);
                    if (m == null) break;
                    this.remove(m);
                    break;
                }
                case 8: {
                    Module m = this.getModule(bundle);
                    if (m != null) {
                        this.remove(m);
                    }
                    this.add(this.makeModule(bundle));
                }
            }
        }
        catch (Exception e) {
            Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "bundleChanged", "e = {0}", new Object[]{e});
        }
    }

    private OSGiModuleImpl makeModule(Bundle bundle) throws IOException, URISyntaxException {
        OSGiModuleDefinition md = this.makeModuleDef(bundle);
        OSGiModuleImpl m = new OSGiModuleImpl(this, bundle, md);
        return m;
    }

    private void loadCachedData() throws Exception {
        String cacheLocation = this.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheLocation == null) {
            return;
        }
        File io = new File(cacheLocation, "inhabitants");
        if (!io.exists()) {
            return;
        }
        if (Logger.logger.isLoggable(Level.FINE)) {
            Logger.logger.logp(Level.INFO, "OSGiModulesRegistryImpl", "loadCachedData", "HK2 cache file = {0}", new Object[]{io});
        }
        ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(io), this.getBufferSize()));
        this.cachedData = (Map)stream.readObject();
        stream.close();
    }

    private void saveCache() throws IOException {
        String cacheLocation = this.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheLocation == null) {
            return;
        }
        File io = new File(cacheLocation, "inhabitants");
        if (Logger.logger.isLoggable(Level.FINE)) {
            Logger.logger.logp(Level.INFO, "OSGiModulesRegistryImpl", "saveCache", "HK2 cache file = {0}", new Object[]{io});
        }
        if (io.exists()) {
            io.delete();
        }
        io.createNewFile();
        HashMap<URI, ModuleDefinition> data = new HashMap<URI, ModuleDefinition>();
        for (Module m : this.modules.values()) {
            data.put(m.getModuleDefinition().getLocations()[0], m.getModuleDefinition());
        }
        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(io), this.getBufferSize()));
        os.writeObject(data);
        os.close();
    }

    private void deleteCache() {
        String cacheLocation = this.getProperty("com.sun.enterprise.hk2.cacheDir");
        if (cacheLocation == null) {
            return;
        }
        File io = new File(cacheLocation, "inhabitants");
        if (io.exists()) {
            if (io.delete()) {
                Logger.logger.logp(Level.FINE, "OSGiModulesRegistryImpl", "deleteCache", "deleted = {0}", new Object[]{io});
            } else {
                Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "deleteCache", "failed to delete = {0}", new Object[]{io});
            }
        }
    }

    private int getBufferSize() {
        int bufsize = 1024;
        try {
            bufsize = Integer.valueOf(this.bctx.getProperty("com.sun.enterprise.hk2.cacheIoBufferSize"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Logger.logger.isLoggable(Level.FINE)) {
            Logger.logger.logp(Level.FINE, "OSGiModulesRegistryImpl", "getBufferSize", "bufsize = {0}", new Object[]{bufsize});
        }
        return bufsize;
    }

    private OSGiModuleDefinition makeModuleDef(Bundle bundle) throws IOException, URISyntaxException {
        URI key = OSGiModuleDefinition.toURI(bundle);
        if (this.cachedData.containsKey(key)) {
            return (OSGiModuleDefinition)OSGiModuleDefinition.class.cast(this.cachedData.get(key));
        }
        this.cacheInvalidated = true;
        return new OSGiModuleDefinition(bundle);
    }

    protected synchronized void add(Module newModule) {
        super.add(newModule);
    }

    @Override
    public synchronized void remove(Module module) {
        super.remove(module);
        URI location = module.getModuleDefinition().getLocations()[0];
        this.cachedData.remove(location);
        this.cacheInvalidated = true;
    }

    protected Module newModule(ModuleDefinition moduleDef) {
        String location = moduleDef.getLocations()[0].toString();
        try {
            File l;
            if (Logger.logger.isLoggable(Level.FINE)) {
                Logger.logger.logp(Level.FINE, "OSGiModulesRegistryImpl", "newModule", "location = {0}", location);
            }
            if ((l = new File(moduleDef.getLocations()[0])).isDirectory()) {
                location = "reference:" + location;
            }
            Bundle bundle = this.bctx.installBundle(location);
            return new OSGiModuleImpl(this, bundle, moduleDef);
        }
        catch (BundleException e) {
            Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "newModule", "Exception {0} while adding location = {1}", new Object[]{e, location});
            return null;
        }
    }

    @Override
    public synchronized void shutdown() {
        for (Module m : this.modules.values()) {
            if (!((OSGiModuleImpl)OSGiModuleImpl.class.cast(m)).isTransientlyActive()) continue;
            m.stop();
        }
        try {
            if (this.cacheInvalidated) {
                this.saveCache();
            }
        }
        catch (IOException e) {
            Logger.logger.log(Level.WARNING, "Cannot save metadata to cache", e);
        }
        this.bctx.removeBundleListener((BundleListener)this);
        super.shutdown();
    }

    protected String getProperty(String property) {
        String value = this.bctx.getProperty(property);
        if (value == null) {
            value = System.getProperty(property);
        }
        return value;
    }
}

