/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.annotation.Annotation;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.AnnotationLiteral;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.BackgroundScheduler;
import org.glassfish.jersey.spi.RuntimeThreadProvider;
import org.jvnet.hk2.annotations.Optional;

public class RuntimeExecutorsBinder
extends AbstractBinder {
    protected void configure() {
        this.bindFactory(BackgroundSchedulerFactory.class).to(ScheduledExecutorService.class).qualifiedBy((Annotation)new BackgroundSchedulerLiteral()).in(Singleton.class);
    }

    public static class BackgroundSchedulerLiteral
    extends AnnotationLiteral<BackgroundScheduler>
    implements BackgroundScheduler {
    }

    private static class BackgroundSchedulerFactory
    implements Factory<ScheduledExecutorService> {
        private final RuntimeThreadProvider runtimeThreadProvider;

        @Inject
        public BackgroundSchedulerFactory(@Optional RuntimeThreadProvider rtp) {
            if (rtp == null) {
                rtp = new RuntimeThreadProvider(){

                    public ThreadFactory getRequestThreadFactory() {
                        return new ThreadFactoryBuilder().setNameFormat("jersey-request-specific-task-thread-%d").build();
                    }

                    public ThreadFactory getBackgroundThreadFactory() {
                        return new ThreadFactoryBuilder().setNameFormat("jersey-background-task-thread-%d").build();
                    }
                };
            }
            this.runtimeThreadProvider = rtp;
        }

        public ScheduledExecutorService provide() {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("jersey-background-task-scheduler-%d").setThreadFactory(this.runtimeThreadProvider.getBackgroundThreadFactory()).build();
            return new ScheduledThreadPoolExecutor(1, threadFactory, new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                }
            });
        }

        public void dispose(ScheduledExecutorService instance) {
            instance.shutdown();
        }
    }
}

