/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.wadl.internal;

import com.sun.research.ws.wadl.Application;
import com.sun.research.ws.wadl.Doc;
import com.sun.research.ws.wadl.Grammars;
import com.sun.research.ws.wadl.Include;
import com.sun.research.ws.wadl.Resource;
import com.sun.research.ws.wadl.Resources;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.ExtendedResourceContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.wadl.WadlApplicationContext;
import org.glassfish.jersey.server.wadl.WadlGenerator;
import org.glassfish.jersey.server.wadl.config.WadlGeneratorConfig;
import org.glassfish.jersey.server.wadl.config.WadlGeneratorConfigLoader;
import org.glassfish.jersey.server.wadl.internal.ApplicationDescription;
import org.glassfish.jersey.server.wadl.internal.WadlBuilder;

public class WadlApplicationContextImpl
implements WadlApplicationContext {
    private static final Logger LOGGER = Logger.getLogger(WadlApplicationContextImpl.class.getName());
    @Context
    private ExtendedResourceContext resourceContext;
    private final ServiceLocator serviceLocator;
    private boolean wadlGenerationEnabled = true;
    private final WadlGeneratorConfig wadlGeneratorConfig;
    private final JAXBContext jaxbContext;

    public WadlApplicationContextImpl(@Context Configuration configuration, @Context ServiceLocator serviceLocator) {
        JAXBContext jaxb;
        this.serviceLocator = serviceLocator;
        this.wadlGeneratorConfig = WadlGeneratorConfigLoader.loadWadlGeneratorsFromConfig(configuration.getProperties());
        WadlGenerator wadlGenerator = this.wadlGeneratorConfig.createWadlGenerator(serviceLocator);
        try {
            ClassLoader contextClassLoader = ReflectionHelper.getContextClassLoader();
            ClassLoader jerseyModuleClassLoader = wadlGenerator.getClass().getClassLoader();
            ReflectionHelper.setContextClassLoader((ClassLoader)jerseyModuleClassLoader);
            jaxb = JAXBContext.newInstance((String)wadlGenerator.getRequiredJaxbContextPath(), (ClassLoader)jerseyModuleClassLoader);
            ReflectionHelper.setContextClassLoader((ClassLoader)contextClassLoader);
        }
        catch (JAXBException ex) {
            try {
                LOGGER.log(Level.FINE, LocalizationMessages.WADL_JAXB_CONTEXT_FALLBACK(), ex);
                jaxb = JAXBContext.newInstance((String)wadlGenerator.getRequiredJaxbContextPath());
            }
            catch (JAXBException innerEx) {
                throw new ProcessingException(LocalizationMessages.ERROR_WADL_JAXB_CONTEXT(), (Throwable)ex);
            }
        }
        this.jaxbContext = jaxb;
    }

    @Override
    public ApplicationDescription getApplication(UriInfo uriInfo) {
        ApplicationDescription applicationDescription = this.getWadlBuilder().generate(this.resourceContext.getResourceModel().getRootResources());
        Application application = applicationDescription.getApplication();
        for (Resources resources : application.getResources()) {
            if (resources.getBase() != null) continue;
            resources.setBase(uriInfo.getBaseUri().toString());
        }
        this.attachExternalGrammar(application, applicationDescription, uriInfo.getRequestUri());
        return applicationDescription;
    }

    @Override
    public Application getApplication(UriInfo info, org.glassfish.jersey.server.model.Resource resource) {
        ApplicationDescription description = this.getApplication(info);
        WadlGenerator wadlGenerator = this.wadlGeneratorConfig.createWadlGenerator(this.serviceLocator);
        Application application = new WadlBuilder(wadlGenerator).generate(description, resource);
        for (Resources resources : application.getResources()) {
            resources.setBase(info.getBaseUri().toString());
        }
        this.attachExternalGrammar(application, description, info.getRequestUri());
        for (Resources resources : application.getResources()) {
            Resource r = resources.getResource().get(0);
            r.setPath(info.getBaseUri().relativize(info.getAbsolutePath()).toString());
            r.getParam().clear();
        }
        return application;
    }

    @Override
    public JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    private WadlBuilder getWadlBuilder() {
        return this.wadlGenerationEnabled ? new WadlBuilder(this.wadlGeneratorConfig.createWadlGenerator(this.serviceLocator)) : null;
    }

    @Override
    public void setWadlGenerationEnabled(boolean wadlGenerationEnabled) {
        this.wadlGenerationEnabled = wadlGenerationEnabled;
    }

    @Override
    public boolean isWadlGenerationEnabled() {
        return this.wadlGenerationEnabled;
    }

    private void attachExternalGrammar(Application application, ApplicationDescription applicationDescription, URI requestURI) {
        try {
            Grammars grammars;
            URI rootURI;
            String root;
            String requestURIPath = requestURI.getPath();
            if (requestURIPath.endsWith("application.wadl")) {
                requestURI = UriBuilder.fromUri((URI)requestURI).replacePath(requestURIPath.substring(0, requestURIPath.lastIndexOf(47) + 1)).build(new Object[0]);
            }
            UriBuilder extendedPath = (root = application.getResources().get(0).getBase()) != null ? UriBuilder.fromPath((String)root).path("/application.wadl/") : UriBuilder.fromPath((String)"./application.wadl/");
            URI uRI = rootURI = root != null ? UriBuilder.fromPath((String)root).build(new Object[0]) : null;
            if (application.getGrammars() != null) {
                LOGGER.info(LocalizationMessages.ERROR_WADL_GRAMMAR_ALREADY_CONTAINS());
                grammars = application.getGrammars();
            } else {
                grammars = new Grammars();
                application.setGrammars(grammars);
            }
            for (String path : applicationDescription.getExternalMetadataKeys()) {
                URI schemaURI = extendedPath.clone().path(path).build(new Object[0]);
                String schemaPath = rootURI != null ? requestURI.relativize(schemaURI).toString() : schemaURI.toString();
                Include include = new Include();
                include.setHref(schemaPath);
                Doc doc = new Doc();
                doc.setLang("en");
                doc.setTitle("Generated");
                include.getDoc().add(doc);
                grammars.getInclude().add(include);
            }
        }
        catch (Exception e) {
            throw new ProcessingException(LocalizationMessages.ERROR_WADL_EXTERNAL_GRAMMAR(), (Throwable)e);
        }
    }
}

