/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.ext.MessageBodyReader;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.client.ChunkedInputReader;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.DefaultClientAsyncExecutorProvider;
import org.glassfish.jersey.internal.ContextResolverFactory;
import org.glassfish.jersey.internal.JaxrsProviders;
import org.glassfish.jersey.internal.JerseyErrorService;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.internal.ServiceFinderBinder;
import org.glassfish.jersey.internal.inject.ContextInjectionResolver;
import org.glassfish.jersey.internal.inject.JerseyClassAnalyzer;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.spi.AutoDiscoverable;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.message.internal.MessageBodyFactory;
import org.glassfish.jersey.message.internal.MessagingBinders;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.spi.ExecutorServiceProvider;

class ClientBinder
extends AbstractBinder {
    private final Map<String, Object> clientRuntimeProperties;

    ClientBinder(Map<String, Object> clientRuntimeProperties) {
        this.clientRuntimeProperties = clientRuntimeProperties;
    }

    protected void configure() {
        this.install(new Binder[]{new RequestScope.Binder(), new JerseyErrorService.Binder(), new ContextInjectionResolver.Binder(), new JerseyClassAnalyzer.Binder(), new MessagingBinders.MessageBodyProviders(this.clientRuntimeProperties, RuntimeType.CLIENT), new MessagingBinders.HeaderDelegateProviders(), new MessageBodyFactory.Binder(), new ContextResolverFactory.Binder(), new JaxrsProviders.Binder(), new ServiceFinderBinder<AutoDiscoverable>(AutoDiscoverable.class, this.clientRuntimeProperties, RuntimeType.CLIENT)});
        this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<ClientConfig>>(){}).in(RequestScoped.class);
        this.bindFactory(RequestContextInjectionFactory.class).to(ClientRequest.class).in(RequestScoped.class);
        this.bindFactory(ReferencingFactory.referenceFactory()).to((TypeLiteral)new TypeLiteral<Ref<ClientRequest>>(){}).in(RequestScoped.class);
        this.bindFactory(PropertiesDelegateFactory.class, Singleton.class).to(PropertiesDelegate.class).in(RequestScoped.class);
        this.bind(ChunkedInputReader.class).to(MessageBodyReader.class).in(Singleton.class);
        int asyncThreadPoolSize = ClientProperties.getValue(this.clientRuntimeProperties, "jersey.config.client.async.threadPoolSize", 0);
        asyncThreadPoolSize = asyncThreadPoolSize < 0 ? 0 : asyncThreadPoolSize;
        this.bind(new DefaultClientAsyncExecutorProvider(asyncThreadPoolSize)).to(ExecutorServiceProvider.class);
    }

    private static class PropertiesDelegateFactory
    implements Factory<PropertiesDelegate> {
        private final Provider<ClientRequest> requestProvider;

        @Inject
        private PropertiesDelegateFactory(Provider<ClientRequest> requestProvider) {
            this.requestProvider = requestProvider;
        }

        public PropertiesDelegate provide() {
            return ((ClientRequest)this.requestProvider.get()).getPropertiesDelegate();
        }

        public void dispose(PropertiesDelegate instance) {
        }
    }

    private static class RequestContextInjectionFactory
    extends ReferencingFactory<ClientRequest> {
        @Inject
        public RequestContextInjectionFactory(Provider<Ref<ClientRequest>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

