/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.Encoded;
import jersey.repackaged.com.google.common.base.Predicate;
import jersey.repackaged.com.google.common.collect.Sets;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

public abstract class ParamInjectionResolver<A extends Annotation>
implements InjectionResolver<A> {
    @Inject
    private ServiceLocator locator;
    private final Predicate<ValueFactoryProvider> concreteValueFactoryClassFilter;

    public ParamInjectionResolver(final Class<? extends ValueFactoryProvider> valueFactoryProviderClass) {
        this.concreteValueFactoryClassFilter = new Predicate<ValueFactoryProvider>(){

            public boolean apply(ValueFactoryProvider input) {
                return valueFactoryProviderClass.isInstance(input);
            }
        };
    }

    public Object resolve(Injectee injectee, ServiceHandle<?> root) {
        Parameter parameter;
        AnnotatedElement annotated = injectee.getParent();
        Annotation[] annotations = annotated.getClass().equals(Constructor.class) ? ((Constructor)annotated).getParameterAnnotations()[injectee.getPosition()] : annotated.getDeclaredAnnotations();
        Class componentClass = injectee.getInjecteeClass();
        Type genericType = injectee.getRequiredType();
        boolean isHk2Factory = ReflectionHelper.isSubClassOf(genericType, Factory.class);
        Type targetGenericType = isHk2Factory ? ReflectionHelper.getTypeArgument(genericType, 0) : genericType;
        Class targetType = ReflectionHelper.erasure(targetGenericType);
        Set providers = Sets.filter(Providers.getProviders(this.locator, ValueFactoryProvider.class), this.concreteValueFactoryClassFilter);
        ValueFactoryProvider valueFactoryProvider = (ValueFactoryProvider)providers.iterator().next();
        Factory<?> valueFactory = valueFactoryProvider.getValueFactory(parameter = Parameter.create(componentClass, componentClass, this.hasEncodedAnnotation(injectee), targetType, targetGenericType, annotations));
        if (valueFactory != null) {
            if (isHk2Factory) {
                return valueFactory;
            }
            return valueFactory.provide();
        }
        return null;
    }

    private boolean hasEncodedAnnotation(Injectee injectee) {
        AnnotatedElement element = injectee.getParent();
        boolean isConstructor = element instanceof Constructor;
        boolean isMethod = element instanceof Method;
        if (isConstructor || isMethod) {
            Annotation[] annotations = isMethod ? ((Method)element).getParameterAnnotations()[injectee.getPosition()] : ((Constructor)element).getParameterAnnotations()[injectee.getPosition()];
            for (Annotation annotation : annotations) {
                if (!annotation.annotationType().equals(Encoded.class)) continue;
                return true;
            }
        }
        if (element.isAnnotationPresent(Encoded.class)) {
            return true;
        }
        Class clazz = injectee.getInjecteeClass();
        return clazz.isAnnotationPresent(Encoded.class);
    }

    public boolean isConstructorParameterIndicator() {
        return true;
    }

    public boolean isMethodParameterIndicator() {
        return false;
    }
}

