/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import javax.json.bind.JsonbException;
import org.eclipse.yasson.internal.Unmarshaller;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractNumberDeserializer;

public class BigDecimalTypeDeserializer
extends AbstractNumberDeserializer<BigDecimal> {
    BigDecimalTypeDeserializer(JsonBindingModel model) {
        super(BigDecimal.class, model);
    }

    @Override
    public BigDecimal deserialize(String jsonValue, Unmarshaller unmarshaller, Type rtType) {
        return this.deserializeFormatted(jsonValue, false, unmarshaller.getJsonbContext()).map(num -> new BigDecimal(num.toString())).orElseGet(() -> {
            try {
                return new BigDecimal(jsonValue);
            }
            catch (NumberFormatException e) {
                throw new JsonbException(Messages.getMessage(MessageKeys.DESERIALIZE_VALUE_ERROR, BigDecimal.class));
            }
        });
    }
}

