/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model.customization.ordering;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.model.customization.ordering.PropOrderStrategy;

public class PropertyOrdering {
    private PropOrderStrategy propertyOrderStrategy;

    public PropertyOrdering(PropOrderStrategy propertyOrderStrategy) {
        Objects.requireNonNull(propertyOrderStrategy);
        this.propertyOrderStrategy = propertyOrderStrategy;
    }

    public List<PropertyModel> orderProperties(Map<String, Property> properties, ClassModel classModel, JsonbContext jsonbContext) {
        String[] order = classModel.getClassCustomization().getPropertyOrder();
        if (order != null) {
            ArrayList<PropertyModel> sortedProperties = new ArrayList<PropertyModel>();
            for (String propName : order) {
                Property remove = properties.remove(propName);
                if (remove == null) continue;
                sortedProperties.add(new PropertyModel(classModel, remove, jsonbContext));
            }
            for (Map.Entry entry : properties.entrySet()) {
                sortedProperties.add(new PropertyModel(classModel, (Property)entry.getValue(), jsonbContext));
            }
            return sortedProperties;
        }
        return this.propertyOrderStrategy.sortProperties(properties.values().stream().map(prop -> new PropertyModel(classModel, (Property)prop, jsonbContext)).collect(Collectors.toList()));
    }

    public PropOrderStrategy getPropertyOrderStrategy() {
        return this.propertyOrderStrategy;
    }
}

