/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal;

import com.google.common.collect.Iterables;
import java.util.LinkedList;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.AbstractContainerLifecycleListener;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;

public final class ConfigHelper {
    private ConfigHelper() {
    }

    public static ContainerLifecycleListener getContainerLifecycleListener(final ApplicationHandler applicationHandler) {
        final AbstractContainerLifecycleListener appPreDestroyInvoker = new AbstractContainerLifecycleListener(){

            @Override
            public void onShutdown(Container container) {
                applicationHandler.getServiceLocator().preDestroy((Object)ConfigHelper.getWrappedApplication(applicationHandler.getConfiguration()));
            }
        };
        final Iterable listeners = Iterables.concat(Providers.getAllProviders(applicationHandler.getServiceLocator(), ContainerLifecycleListener.class), (Iterable)new LinkedList<ContainerLifecycleListener>(){
            {
                this.add(appPreDestroyInvoker);
            }
        });
        return new ContainerLifecycleListener(){

            @Override
            public void onStartup(Container container) {
                for (ContainerLifecycleListener listener : listeners) {
                    listener.onStartup(container);
                }
            }

            @Override
            public void onReload(Container container) {
                for (ContainerLifecycleListener listener : listeners) {
                    listener.onReload(container);
                }
            }

            @Override
            public void onShutdown(Container container) {
                for (ContainerLifecycleListener listener : listeners) {
                    listener.onShutdown(container);
                }
            }
        };
    }

    public static Application getWrappedApplication(Application app) {
        Application wrappedApplication;
        while (app instanceof ResourceConfig && (wrappedApplication = ((ResourceConfig)app).getApplication()) != app) {
            app = wrappedApplication;
        }
        return app;
    }
}

