/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.process.RespondingContext;
import org.glassfish.jersey.server.internal.routing.CombinedClientServerMediaType;
import org.glassfish.jersey.server.internal.routing.MethodAcceptorPair;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.model.ResourceMethod;

final class MethodSelectingRouter
implements Router {
    private static final Logger LOGGER = Logger.getLogger(MethodSelectingRouter.class.getName());
    private final Provider<RespondingContext> respondingContextFactory;
    private final MessageBodyWorkers workers;
    private final Map<String, List<ConsumesProducesAcceptor>> consumesProducesAcceptors;
    private final Router router;

    private MethodSelectingRouter(Provider<RespondingContext> respondingContextFactory, MessageBodyWorkers msgWorkers, List<MethodAcceptorPair> methodAcceptorPairs) {
        this.respondingContextFactory = respondingContextFactory;
        this.workers = msgWorkers;
        this.consumesProducesAcceptors = new HashMap<String, List<ConsumesProducesAcceptor>>();
        HashSet httpMethods = Sets.newHashSet();
        for (MethodAcceptorPair methodAcceptorPair : methodAcceptorPairs) {
            String httpMethod = methodAcceptorPair.model.getHttpMethod();
            httpMethods.add(httpMethod);
            List<ConsumesProducesAcceptor> httpMethodBoundAcceptors = this.consumesProducesAcceptors.get(httpMethod);
            if (httpMethodBoundAcceptors == null) {
                httpMethodBoundAcceptors = new LinkedList<ConsumesProducesAcceptor>();
                this.consumesProducesAcceptors.put(httpMethod, httpMethodBoundAcceptors);
            }
            this.addAllConsumesProducesCombinations(httpMethodBoundAcceptors, methodAcceptorPair);
        }
        for (String httpMethod : httpMethods) {
            Collections.sort(this.consumesProducesAcceptors.get(httpMethod), new Comparator<ConsumesProducesAcceptor>(){

                @Override
                public int compare(ConsumesProducesAcceptor o1, ConsumesProducesAcceptor o2) {
                    ResourceMethod model1 = ((ConsumesProducesAcceptor)o1).methodAcceptorPair.model;
                    ResourceMethod model2 = ((ConsumesProducesAcceptor)o2).methodAcceptorPair.model;
                    int compared = this.compare(model2.getConsumedTypes(), model1.getConsumedTypes());
                    if (compared == 0 && (compared = this.compare(model2.getProducedTypes(), model1.getProducedTypes())) == 0 && (compared = MediaTypes.MEDIA_TYPE_COMPARATOR.compare(o1.consumes.getMediaType(), o2.consumes.getMediaType())) == 0) {
                        compared = MediaTypes.MEDIA_TYPE_COMPARATOR.compare(o1.produces.getMediaType(), o2.produces.getMediaType());
                    }
                    return compared;
                }

                @Override
                private int compare(List<MediaType> mediaTypeList1, List<MediaType> mediaTypeList2) {
                    mediaTypeList1 = mediaTypeList1.isEmpty() ? MediaTypes.GENERAL_MEDIA_TYPE_LIST : mediaTypeList1;
                    mediaTypeList2 = mediaTypeList2.isEmpty() ? MediaTypes.GENERAL_MEDIA_TYPE_LIST : mediaTypeList2;
                    return MediaTypes.MEDIA_TYPE_LIST_COMPARATOR.compare(mediaTypeList2, mediaTypeList1);
                }
            });
        }
        this.router = !this.consumesProducesAcceptors.containsKey("HEAD") ? this.createHeadEnrichedRouter() : this.createInternalRouter();
    }

    private Router createInternalRouter() {
        return new Router(){

            @Override
            public Router.Continuation apply(ContainerRequest requestContext) {
                return Router.Continuation.of(requestContext, MethodSelectingRouter.this.getMethodRouter(requestContext));
            }
        };
    }

    @Override
    public Router.Continuation apply(ContainerRequest requestContext) {
        return this.router.apply(requestContext);
    }

    private void addAllConsumesProducesCombinations(List<ConsumesProducesAcceptor> acceptors, MethodAcceptorPair methodAcceptorPair) {
        ResourceMethod resourceMethod = methodAcceptorPair.model;
        LinkedHashSet<MediaType> effectiveInputTypes = new LinkedHashSet<MediaType>();
        boolean consumesFromWorkers = this.fillMediaTypes(effectiveInputTypes, resourceMethod, resourceMethod.getConsumedTypes(), true);
        LinkedHashSet<MediaType> effectiveOutputTypes = new LinkedHashSet<MediaType>();
        boolean producesFromWorkers = this.fillMediaTypes(effectiveOutputTypes, resourceMethod, resourceMethod.getProducedTypes(), false);
        HashSet acceptorSet = Sets.newHashSet();
        for (MediaType consumes : effectiveInputTypes) {
            for (MediaType produces : effectiveOutputTypes) {
                acceptorSet.add(new ConsumesProducesAcceptor(new CombinedClientServerMediaType.EffectiveMediaType(consumes, consumesFromWorkers), new CombinedClientServerMediaType.EffectiveMediaType(produces, producesFromWorkers), methodAcceptorPair));
            }
        }
        acceptors.addAll(acceptorSet);
    }

    private boolean fillMediaTypes(Set<MediaType> effectiveTypes, ResourceMethod resourceMethod, List<MediaType> methodTypes, boolean inputTypes) {
        if (methodTypes.size() > 1 || !methodTypes.contains(MediaType.WILDCARD_TYPE)) {
            effectiveTypes.addAll(methodTypes);
        }
        boolean mediaTypesFromWorkers = effectiveTypes.isEmpty();
        if (this.workers != null && mediaTypesFromWorkers) {
            Invocable invocableMethod = resourceMethod.getInvocable();
            if (inputTypes) {
                this.fillInputTypesFromWorkers(effectiveTypes, invocableMethod);
            } else {
                this.fillOutputTypesFromWorkers(effectiveTypes, invocableMethod.getRawResponseType());
            }
            boolean bl = mediaTypesFromWorkers = !effectiveTypes.isEmpty();
            if (!mediaTypesFromWorkers) {
                if (inputTypes) {
                    effectiveTypes.addAll(this.workers.getMessageBodyReaderMediaTypesByType(Object.class));
                } else {
                    effectiveTypes.addAll(this.workers.getMessageBodyWriterMediaTypesByType(Object.class));
                }
                mediaTypesFromWorkers = true;
            }
        }
        return mediaTypesFromWorkers;
    }

    private void fillOutputTypesFromWorkers(Set<MediaType> effectiveOutputTypes, Class<?> returnEntityType) {
        effectiveOutputTypes.addAll(this.workers.getMessageBodyWriterMediaTypesByType(returnEntityType));
    }

    private void fillInputTypesFromWorkers(Set<MediaType> effectiveInputTypes, Invocable invocableMethod) {
        for (Parameter p : invocableMethod.getParameters()) {
            if (p.getSource() != Parameter.Source.ENTITY) continue;
            effectiveInputTypes.addAll(this.workers.getMessageBodyReaderMediaTypesByType(p.getRawType()));
            break;
        }
    }

    private Parameter getEntityParam(Invocable invocable) {
        for (Parameter parameter : invocable.getParameters()) {
            if (parameter.getSource() != Parameter.Source.ENTITY || ContainerRequestContext.class.isAssignableFrom(parameter.getRawType())) continue;
            return parameter;
        }
        return null;
    }

    private List<Router> getMethodRouter(ContainerRequest requestContext) {
        List<ConsumesProducesAcceptor> acceptors = this.consumesProducesAcceptors.get(requestContext.getMethod());
        if (acceptors == null) {
            throw new NotAllowedException(Response.status(Response.Status.METHOD_NOT_ALLOWED).allow(this.consumesProducesAcceptors.keySet()).build());
        }
        LinkedList<ConsumesProducesAcceptor> satisfyingAcceptors = new LinkedList<ConsumesProducesAcceptor>();
        Set differentInvokableMethods = Sets.newIdentityHashSet();
        for (ConsumesProducesAcceptor cpi : acceptors) {
            if (!cpi.isConsumable(requestContext)) continue;
            satisfyingAcceptors.add(cpi);
            differentInvokableMethods.add(((ConsumesProducesAcceptor)cpi).methodAcceptorPair.model);
        }
        if (satisfyingAcceptors.isEmpty()) {
            throw new NotSupportedException();
        }
        final List<MediaType> acceptableMediaTypes = requestContext.getAcceptableMediaTypes();
        MediaType requestContentType = requestContext.getMediaType();
        MediaType effectiveContentType = requestContentType == null ? MediaType.WILDCARD_TYPE : requestContentType;
        final MethodSelector methodSelector = this.selectMethod(acceptableMediaTypes, satisfyingAcceptors, effectiveContentType, differentInvokableMethods.size() == 1);
        if (methodSelector.selected != null) {
            RequestSpecificConsumesProducesAcceptor selected = methodSelector.selected;
            if (methodSelector.sameFitnessAcceptors != null) {
                this.reportMethodSelectionAmbiguity(acceptableMediaTypes, methodSelector.selected, methodSelector.sameFitnessAcceptors);
            }
            ((RespondingContext)this.respondingContextFactory.get()).push(new Function<ContainerResponse, ContainerResponse>(){

                public ContainerResponse apply(ContainerResponse responseContext) {
                    if (responseContext.getMediaType() == null && (responseContext.hasEntity() || "HEAD".equals(responseContext.getRequestContext().getMethod()))) {
                        MediaType effectiveResponseType = MethodSelectingRouter.this.determineResponseMediaType(responseContext.getEntityClass(), responseContext.getEntityType(), methodSelector.selected, acceptableMediaTypes);
                        if (MethodSelectingRouter.this.isWildcard(effectiveResponseType)) {
                            if (effectiveResponseType.isWildcardType() || effectiveResponseType.getType().equalsIgnoreCase("application")) {
                                effectiveResponseType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
                            } else {
                                throw new NotAcceptableException();
                            }
                        }
                        responseContext.setMediaType(effectiveResponseType);
                    }
                    return responseContext;
                }
            });
            return selected.methodAcceptorPair.router;
        }
        throw new NotAcceptableException();
    }

    private MediaType determineResponseMediaType(Class<?> entityClass, Type entityType, RequestSpecificConsumesProducesAcceptor selectedMethod, List<MediaType> acceptableMediaTypes) {
        if (this.usePreSelectedMediaType(selectedMethod, acceptableMediaTypes)) {
            return selectedMethod.produces.getCombinedMediaType();
        }
        ResourceMethod resourceMethod = selectedMethod.methodAcceptorPair.model;
        Invocable invocable = resourceMethod.getInvocable();
        Class<?> responseEntityClass = entityClass == null ? invocable.getRawRoutingResponseType() : entityClass;
        Method handlingMethod = invocable.getHandlingMethod();
        CombinedClientServerMediaType selected = null;
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            for (MessageBodyWriter writer : this.workers.getMessageBodyWritersForType(responseEntityClass)) {
                for (MediaType writerProduces : MediaTypes.createFrom(writer.getClass().getAnnotation(Produces.class))) {
                    if (!writerProduces.isCompatible(acceptableMediaType)) continue;
                    ArrayList methodProducesTypes = !resourceMethod.getProducedTypes().isEmpty() ? resourceMethod.getProducedTypes() : Lists.newArrayList((Object[])new MediaType[]{MediaType.WILDCARD_TYPE});
                    for (MediaType methodProducesType : methodProducesTypes) {
                        CombinedClientServerMediaType.EffectiveMediaType effectiveProduces;
                        CombinedClientServerMediaType candidate;
                        if (!methodProducesType.isCompatible(writerProduces) || (candidate = CombinedClientServerMediaType.create(acceptableMediaType, effectiveProduces = new CombinedClientServerMediaType.EffectiveMediaType(MediaTypes.mostSpecific(methodProducesType, writerProduces), false))).getCombinedMediaType() == null || selected != null && CombinedClientServerMediaType.COMPARATOR.compare(candidate, selected) <= 0 || !writer.isWriteable(responseEntityClass, entityType, handlingMethod.getDeclaredAnnotations(), candidate.getCombinedMediaType())) continue;
                        selected = candidate;
                    }
                }
            }
        }
        if (selected != null) {
            return selected.getCombinedMediaType();
        }
        return selectedMethod.produces.getCombinedMediaType();
    }

    private boolean isWriteable(RequestSpecificConsumesProducesAcceptor candidate) {
        Invocable invocable = candidate.methodAcceptorPair.model.getInvocable();
        Class responseType = Primitives.wrap(invocable.getRawRoutingResponseType());
        if (Response.class.isAssignableFrom(responseType) || Void.class.isAssignableFrom(responseType)) {
            return true;
        }
        Type genericType = invocable.getRoutingResponseType();
        Type genericReturnType = genericType instanceof GenericType ? ((GenericType)((Object)genericType)).getType() : genericType;
        for (MessageBodyWriter writer : this.workers.getMessageBodyWritersForType(responseType)) {
            if (!writer.isWriteable(responseType, genericReturnType, invocable.getHandlingMethod().getDeclaredAnnotations(), candidate.produces.getCombinedMediaType())) continue;
            return true;
        }
        return false;
    }

    private boolean isReadable(RequestSpecificConsumesProducesAcceptor candidate) {
        Invocable invocable = candidate.methodAcceptorPair.model.getInvocable();
        Method handlingMethod = invocable.getHandlingMethod();
        Parameter entityParam = this.getEntityParam(invocable);
        if (entityParam == null) {
            return true;
        }
        Class<?> entityType = entityParam.getRawType();
        for (MessageBodyReader reader : this.workers.getMessageBodyReadersForType(entityType)) {
            if (!reader.isReadable(entityType, entityParam.getType(), handlingMethod.getDeclaredAnnotations(), candidate.consumes.getCombinedMediaType())) continue;
            return true;
        }
        return false;
    }

    private boolean usePreSelectedMediaType(RequestSpecificConsumesProducesAcceptor selectedMethod, List<MediaType> acceptableMediaTypes) {
        if (!selectedMethod.producesFromProviders && selectedMethod.methodAcceptorPair.model.getProducedTypes().size() == 1) {
            return true;
        }
        return acceptableMediaTypes.size() == 1 && !this.isWildcard(acceptableMediaTypes.get(0));
    }

    private MethodSelector selectMethod(List<MediaType> acceptableMediaTypes, List<ConsumesProducesAcceptor> satisfyingAcceptors, MediaType effectiveContentType, boolean singleInvokableMethod) {
        MethodSelector method = new MethodSelector(null);
        MethodSelector alternative = new MethodSelector(null);
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            for (ConsumesProducesAcceptor satisfiable : satisfyingAcceptors) {
                if (!satisfiable.produces.getMediaType().isCompatible(acceptableMediaType)) continue;
                CombinedClientServerMediaType produces = CombinedClientServerMediaType.create(acceptableMediaType, satisfiable.getProduces());
                CombinedClientServerMediaType consumes = CombinedClientServerMediaType.create(effectiveContentType, satisfiable.getConsumes());
                RequestSpecificConsumesProducesAcceptor candidate = new RequestSpecificConsumesProducesAcceptor(consumes, satisfiable.getConsumes().isDerived(), produces, satisfiable.getProduces().isDerived(), satisfiable.methodAcceptorPair);
                if (singleInvokableMethod) {
                    return new MethodSelector(candidate);
                }
                if (candidate.compareTo(method.selected) <= 0) continue;
                if (method.selected == null || candidate.methodAcceptorPair.model != method.selected.methodAcceptorPair.model) {
                    if (this.isReadable(candidate) && this.isWriteable(candidate)) {
                        method.consider(candidate);
                        continue;
                    }
                    alternative.consider(candidate);
                    continue;
                }
                method.consider(candidate);
            }
        }
        return method.selected != null ? method : alternative;
    }

    private boolean isWildcard(MediaType effectiveResponseType) {
        return effectiveResponseType.isWildcardType() || effectiveResponseType.isWildcardSubtype();
    }

    private void reportMethodSelectionAmbiguity(List<MediaType> acceptableTypes, RequestSpecificConsumesProducesAcceptor selected, List<RequestSpecificConsumesProducesAcceptor> sameFitnessAcceptors) {
        if (LOGGER.isLoggable(Level.WARNING)) {
            StringBuilder msgBuilder = new StringBuilder(LocalizationMessages.AMBIGUOUS_RESOURCE_METHOD(acceptableTypes)).append('\n');
            msgBuilder.append('\t').append(selected.methodAcceptorPair.model).append('\n');
            HashSet reportedMethods = Sets.newHashSet();
            reportedMethods.add(selected.methodAcceptorPair.model);
            for (RequestSpecificConsumesProducesAcceptor i : sameFitnessAcceptors) {
                if (!reportedMethods.contains(i.methodAcceptorPair.model)) {
                    msgBuilder.append('\t').append(i.methodAcceptorPair.model).append('\n');
                }
                reportedMethods.add(i.methodAcceptorPair.model);
            }
            LOGGER.log(Level.WARNING, msgBuilder.toString());
        }
    }

    private Router createHeadEnrichedRouter() {
        return new Router(){

            @Override
            public Router.Continuation apply(ContainerRequest requestContext) {
                if ("HEAD".equals(requestContext.getMethod())) {
                    requestContext.setMethodWithoutException("GET");
                    ((RespondingContext)MethodSelectingRouter.this.respondingContextFactory.get()).push(new Function<ContainerResponse, ContainerResponse>(){

                        public ContainerResponse apply(ContainerResponse responseContext) {
                            responseContext.getRequestContext().setMethodWithoutException("HEAD");
                            return responseContext;
                        }
                    });
                }
                return Router.Continuation.of(requestContext, MethodSelectingRouter.this.getMethodRouter(requestContext));
            }
        };
    }

    private static class MethodSelector {
        RequestSpecificConsumesProducesAcceptor selected;
        List<RequestSpecificConsumesProducesAcceptor> sameFitnessAcceptors;

        MethodSelector(RequestSpecificConsumesProducesAcceptor i) {
            this.selected = i;
            this.sameFitnessAcceptors = null;
        }

        void consider(RequestSpecificConsumesProducesAcceptor i) {
            int theGreaterTheBetter = i.compareTo(this.selected);
            if (theGreaterTheBetter > 0) {
                this.selected = i;
                this.sameFitnessAcceptors = null;
            } else if (theGreaterTheBetter == 0 && this.selected.methodAcceptorPair != i.methodAcceptorPair) {
                this.getSameFitnessList().add(i);
            }
        }

        List<RequestSpecificConsumesProducesAcceptor> getSameFitnessList() {
            if (this.sameFitnessAcceptors == null) {
                this.sameFitnessAcceptors = new LinkedList<RequestSpecificConsumesProducesAcceptor>();
            }
            return this.sameFitnessAcceptors;
        }
    }

    private static class RequestSpecificConsumesProducesAcceptor
    implements Comparable {
        CombinedClientServerMediaType consumes;
        CombinedClientServerMediaType produces;
        MethodAcceptorPair methodAcceptorPair;
        boolean consumesFromProviders;
        boolean producesFromProviders;

        RequestSpecificConsumesProducesAcceptor(CombinedClientServerMediaType consumes, boolean consumesFromProviders, CombinedClientServerMediaType produces, boolean producesFromProviders, MethodAcceptorPair methodAcceptorPair) {
            this.methodAcceptorPair = methodAcceptorPair;
            this.consumes = consumes;
            this.produces = produces;
            this.consumesFromProviders = consumesFromProviders;
            this.producesFromProviders = producesFromProviders;
        }

        public String toString() {
            return String.format("%s->%s:%s", this.consumes, this.produces, this.methodAcceptorPair);
        }

        public int compareTo(Object o) {
            if (o == null) {
                return 1;
            }
            if (!(o instanceof RequestSpecificConsumesProducesAcceptor)) {
                return 1;
            }
            RequestSpecificConsumesProducesAcceptor other = (RequestSpecificConsumesProducesAcceptor)o;
            int consumedComparison = CombinedClientServerMediaType.COMPARATOR.compare(this.consumes, other.consumes);
            return consumedComparison != 0 ? consumedComparison : CombinedClientServerMediaType.COMPARATOR.compare(this.produces, other.produces);
        }
    }

    private static class ConsumesProducesAcceptor {
        private CombinedClientServerMediaType.EffectiveMediaType consumes;
        private CombinedClientServerMediaType.EffectiveMediaType produces;
        private MethodAcceptorPair methodAcceptorPair;

        private ConsumesProducesAcceptor(CombinedClientServerMediaType.EffectiveMediaType consumes, CombinedClientServerMediaType.EffectiveMediaType produces, MethodAcceptorPair methodAcceptorPair) {
            this.methodAcceptorPair = methodAcceptorPair;
            this.consumes = consumes;
            this.produces = produces;
        }

        public CombinedClientServerMediaType.EffectiveMediaType getConsumes() {
            return this.consumes;
        }

        public CombinedClientServerMediaType.EffectiveMediaType getProduces() {
            return this.produces;
        }

        boolean isConsumable(ContainerRequest requestContext) {
            MediaType contentType = requestContext.getMediaType();
            return contentType == null || this.consumes.getMediaType().isCompatible(contentType);
        }

        public String toString() {
            return String.format("%s->%s:%s", this.consumes.getMediaType(), this.produces.getMediaType(), this.methodAcceptorPair);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConsumesProducesAcceptor)) {
                return false;
            }
            ConsumesProducesAcceptor that = (ConsumesProducesAcceptor)o;
            if (this.consumes != null ? !this.consumes.equals(that.consumes) : that.consumes != null) {
                return false;
            }
            if (this.methodAcceptorPair != null ? !this.methodAcceptorPair.equals(that.methodAcceptorPair) : that.methodAcceptorPair != null) {
                return false;
            }
            return !(this.produces != null ? !this.produces.equals(that.produces) : that.produces != null);
        }

        public int hashCode() {
            int result = this.consumes != null ? this.consumes.hashCode() : 0;
            result = 31 * result + (this.produces != null ? this.produces.hashCode() : 0);
            result = 31 * result + (this.methodAcceptorPair != null ? this.methodAcceptorPair.hashCode() : 0);
            return result;
        }
    }

    static class Builder {
        @Inject
        private Provider<RespondingContext> respondingContextFactory;

        Builder() {
        }

        public MethodSelectingRouter build(MessageBodyWorkers workers, List<MethodAcceptorPair> methodAcceptorPairs) {
            return new MethodSelectingRouter(this.respondingContextFactory, workers, methodAcceptorPairs);
        }
    }
}

