/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.model.internal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.PrivilegedAction;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.ValidationException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.SubjectSecurityContext;
import org.glassfish.jersey.server.internal.LocalizationMessages;
import org.glassfish.jersey.server.internal.ServerTraceEvent;
import org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import org.glassfish.jersey.server.internal.process.MappableException;
import org.glassfish.jersey.server.model.Invocable;
import org.glassfish.jersey.server.spi.internal.ResourceMethodDispatcher;

abstract class AbstractJavaResourceMethodDispatcher
implements ResourceMethodDispatcher {
    @Inject
    private Provider<ConfiguredValidator> validatorProvider;
    @Inject
    private Provider<ContainerRequest> request;
    private final Method method;
    private final InvocationHandler methodHandler;
    private Invocable resourceMethod;

    AbstractJavaResourceMethodDispatcher(Invocable resourceMethod, InvocationHandler methodHandler) {
        this.method = resourceMethod.getDefinitionMethod();
        this.methodHandler = methodHandler;
        this.resourceMethod = resourceMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Response dispatch(Object resource, ContainerRequest request) throws ProcessingException {
        Response response = null;
        try {
            response = this.doDispatch(resource, request);
        }
        catch (Throwable throwable) {
            TracingLogger.getInstance(request).log(ServerTraceEvent.DISPATCH_RESPONSE, response);
            throw throwable;
        }
        TracingLogger.getInstance(request).log(ServerTraceEvent.DISPATCH_RESPONSE, response);
        return response;
    }

    protected abstract Response doDispatch(Object var1, Request var2) throws ProcessingException;

    final Object invoke(final Object resource, final Object ... args) throws ProcessingException {
        try {
            Object invocationResult;
            ConfiguredValidator validator = (ConfiguredValidator)this.validatorProvider.get();
            if (validator != null) {
                validator.validateResourceAndInputParams(resource, this.resourceMethod, args);
            }
            final ContainerRequest containerRequest = (ContainerRequest)this.request.get();
            PrivilegedAction invokeMethodAction = new PrivilegedAction(){

                /*
                 * Loose catch block
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public Object run() {
                    Object object;
                    TracingLogger tracingLogger = TracingLogger.getInstance(containerRequest);
                    long timestamp = tracingLogger.timestamp(ServerTraceEvent.METHOD_INVOKE);
                    try {
                        object = AbstractJavaResourceMethodDispatcher.this.methodHandler.invoke(resource, AbstractJavaResourceMethodDispatcher.this.method, args);
                    }
                    catch (IllegalAccessException ex) {
                        try {
                            throw new ProcessingException(LocalizationMessages.ERROR_RESOURCE_JAVA_METHOD_INVOCATION(), ex);
                            catch (IllegalArgumentException ex2) {
                                throw new ProcessingException(LocalizationMessages.ERROR_RESOURCE_JAVA_METHOD_INVOCATION(), ex2);
                            }
                            catch (UndeclaredThrowableException ex3) {
                                throw new ProcessingException(LocalizationMessages.ERROR_RESOURCE_JAVA_METHOD_INVOCATION(), ex3);
                            }
                            catch (InvocationTargetException ex4) {
                                throw AbstractJavaResourceMethodDispatcher.mapTargetToRuntimeEx(ex4.getCause());
                            }
                            catch (Throwable t) {
                                throw new ProcessingException(t);
                            }
                        }
                        catch (Throwable throwable) {
                            tracingLogger.logDuration(ServerTraceEvent.METHOD_INVOKE, timestamp, resource, AbstractJavaResourceMethodDispatcher.this.method);
                            throw throwable;
                        }
                    }
                    tracingLogger.logDuration(ServerTraceEvent.METHOD_INVOKE, timestamp, resource, AbstractJavaResourceMethodDispatcher.this.method);
                    return object;
                }
            };
            SecurityContext securityContext = containerRequest.getSecurityContext();
            Object object = invocationResult = securityContext instanceof SubjectSecurityContext ? ((SubjectSecurityContext)securityContext).doAsSubject(invokeMethodAction) : invokeMethodAction.run();
            if (validator != null) {
                validator.validateResult(resource, this.resourceMethod, invocationResult);
            }
            return invocationResult;
        }
        catch (ValidationException ex) {
            throw new MappableException(ex);
        }
    }

    private static RuntimeException mapTargetToRuntimeEx(Throwable throwable) {
        if (throwable instanceof WebApplicationException) {
            return (WebApplicationException)throwable;
        }
        return new MappableException(throwable);
    }

    public String toString() {
        return this.method.toString();
    }
}

