/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;

public class JsonbRiParser
implements JsonParser,
JsonbParser {
    private final JsonParser jsonParser;
    private final Deque<LevelContext> level = new ArrayDeque<LevelContext>();

    public JsonbRiParser(JsonParser jsonParser) {
        this.jsonParser = jsonParser;
        this.level.push(new LevelContext(null));
    }

    public boolean hasNext() {
        return this.jsonParser.hasNext();
    }

    public long getLong() {
        return this.jsonParser.getLong();
    }

    public int getInt() {
        return this.jsonParser.getInt();
    }

    public JsonParser.Event next() {
        JsonParser.Event next = this.jsonParser.next();
        this.level.peek().setLastEvent(next);
        switch (next) {
            case START_ARRAY: 
            case START_OBJECT: {
                LevelContext newLevel = new LevelContext(this.level.peek());
                newLevel.setLastEvent(next);
                this.level.push(newLevel);
                break;
            }
            case END_ARRAY: 
            case END_OBJECT: {
                this.level.pop().finish();
                break;
            }
            case KEY_NAME: {
                this.getCurrentLevel().setLastKeyName(this.jsonParser.getString());
                break;
            }
        }
        return next;
    }

    public boolean isIntegralNumber() {
        return this.jsonParser.isIntegralNumber();
    }

    public BigDecimal getBigDecimal() {
        return this.jsonParser.getBigDecimal();
    }

    public JsonLocation getLocation() {
        return this.jsonParser.getLocation();
    }

    public void close() {
        this.jsonParser.close();
    }

    public String getString() {
        return this.jsonParser.getString();
    }

    @Override
    public void moveTo(JsonParser.Event required) {
        if (!this.level.isEmpty() && this.level.peek().getLastEvent() == required) {
            return;
        }
        JsonParser.Event next = this.next();
        if (next == required) {
            return;
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Event " + required + " not found." + this.getLastDataMsg()));
    }

    @Override
    public JsonParser.Event moveToValue() {
        return this.moveTo(JsonParser.Event.VALUE_STRING, JsonParser.Event.VALUE_NUMBER, JsonParser.Event.VALUE_FALSE, JsonParser.Event.VALUE_TRUE, JsonParser.Event.VALUE_NULL);
    }

    @Override
    public JsonParser.Event moveToStartStructure() {
        return this.moveTo(JsonParser.Event.START_OBJECT, JsonParser.Event.START_ARRAY);
    }

    private JsonParser.Event moveTo(JsonParser.Event ... events) {
        if (!this.level.isEmpty() && this.contains(events, this.level.peek().getLastEvent())) {
            return this.level.peek().getLastEvent();
        }
        JsonParser.Event next = this.next();
        if (this.contains(events, next)) {
            return next;
        }
        throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, "Parser event [" + Arrays.toString(events) + "] not found." + this.getLastDataMsg()));
    }

    private boolean contains(JsonParser.Event[] events, JsonParser.Event candidate) {
        for (JsonParser.Event event : events) {
            if (event != candidate) continue;
            return true;
        }
        return false;
    }

    private String getLastDataMsg() {
        StringBuilder builder = new StringBuilder();
        LevelContext currentLevel = this.getCurrentLevel();
        builder.append(" Last data: [").append("EVENT: ").append(currentLevel.getLastEvent()).append(" KEY_NAME: ").append(currentLevel.getLastKeyName()).append("]");
        return builder.toString();
    }

    @Override
    public LevelContext getCurrentLevel() {
        return this.level.peek();
    }

    @Override
    public void skipJsonStructure() {
        LevelContext currentLevel = this.level.peek();
        switch (currentLevel.getLastEvent()) {
            case START_ARRAY: 
            case START_OBJECT: {
                while (!currentLevel.isParsed()) {
                    this.next();
                }
                return;
            }
        }
    }

    public JsonObject getObject() {
        JsonObject object = this.jsonParser.getObject();
        this.level.pop();
        return object;
    }

    public JsonValue getValue() {
        return this.jsonParser.getValue();
    }

    public JsonArray getArray() {
        JsonArray result = this.jsonParser.getArray();
        this.level.pop();
        return result;
    }

    public Stream<JsonValue> getArrayStream() {
        return this.jsonParser.getArrayStream();
    }

    public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
        return this.jsonParser.getObjectStream();
    }

    public Stream<JsonValue> getValueStream() {
        return this.jsonParser.getValueStream();
    }

    public void skipArray() {
        this.jsonParser.skipArray();
        this.level.pop();
    }

    public void skipObject() {
        this.jsonParser.skipObject();
        this.level.pop();
    }

    public JsonParser.Event getLastEvent() {
        return this.level.peek().getLastEvent();
    }

    public static class LevelContext {
        private final LevelContext parent;
        private JsonParser.Event lastEvent;
        private String lastKeyName;
        private boolean parsed;

        public LevelContext(LevelContext parent) {
            this.parent = parent;
        }

        public JsonParser.Event getLastEvent() {
            return this.lastEvent;
        }

        private void setLastEvent(JsonParser.Event lastEvent) {
            this.lastEvent = lastEvent;
        }

        public String getLastKeyName() {
            return this.lastKeyName;
        }

        private void setLastKeyName(String lastKeyName) {
            Objects.requireNonNull(lastKeyName);
            this.lastKeyName = lastKeyName;
        }

        public LevelContext getParent() {
            return this.parent;
        }

        public boolean isParsed() {
            return this.parsed;
        }

        private void finish() {
            if (this.parsed) {
                throw new IllegalStateException("Level already parsed");
            }
            this.parsed = true;
        }
    }
}

