/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.logging;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.logging.LoggingInterceptor;
import org.glassfish.jersey.message.MessageUtils;

@ConstrainedTo(value=RuntimeType.CLIENT)
@PreMatching
@Priority(value=0x7FFFFFFF)
final class ClientLoggingFilter
extends LoggingInterceptor
implements ClientRequestFilter,
ClientResponseFilter {
    public ClientLoggingFilter(Logger logger, Level level, LoggingFeature.Verbosity verbosity, int maxEntitySize) {
        super(logger, level, verbosity, maxEntitySize);
    }

    public void filter(ClientRequestContext context) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        long id = this._id.incrementAndGet();
        context.setProperty(LOGGING_ID_PROPERTY, (Object)id);
        StringBuilder b = new StringBuilder();
        this.printRequestLine(b, "Sending client request", id, context.getMethod(), context.getUri());
        this.printPrefixedHeaders(b, id, "> ", (MultivaluedMap<String, String>)context.getStringHeaders());
        if (context.hasEntity() && ClientLoggingFilter.printEntity(this.verbosity, context.getMediaType())) {
            LoggingInterceptor.LoggingStream stream = new LoggingInterceptor.LoggingStream(this, b, context.getEntityStream());
            context.setEntityStream((OutputStream)stream);
            context.setProperty(ENTITY_LOGGER_PROPERTY, (Object)stream);
        } else {
            this.log(b);
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (!this.logger.isLoggable(this.level)) {
            return;
        }
        Object requestId = requestContext.getProperty(LOGGING_ID_PROPERTY);
        long id = requestId != null ? ((Long)requestId).longValue() : this._id.incrementAndGet();
        StringBuilder b = new StringBuilder();
        this.printResponseLine(b, "Client response received", id, responseContext.getStatus());
        this.printPrefixedHeaders(b, id, "< ", (MultivaluedMap<String, String>)responseContext.getHeaders());
        if (responseContext.hasEntity() && ClientLoggingFilter.printEntity(this.verbosity, responseContext.getMediaType())) {
            responseContext.setEntityStream(this.logInboundEntity(b, responseContext.getEntityStream(), MessageUtils.getCharset(responseContext.getMediaType())));
        }
        this.log(b);
    }
}

