[//]: # " Copyright (c) 2015, 2018 Oracle and/or its affiliates. All rights reserved. "
[//]: # " "
[//]: # " This program and the accompanying materials are made available under the "
[//]: # " terms of the Eclipse Distribution License v. 1.0, which is available at "
[//]: # " http://www.eclipse.org/org/documents/edl-v10.php. "
[//]: # " "
[//]: # " SPDX-License-Identifier: BSD-3-Clause "

Extended WADL WebApp Example
============================

This example demonstrates how to get an extended WADL generated by
jersey.

Contents
--------

The description of what's done here you'll find in the [jersey 1
wiki](https://wikis.oracle.com/display/Jersey/HowToConfigureExtendedWADL).

The difference in configuration against jersey 1.x is in property
configuring the custom WadlGeneratorConfig. Instead of property key
'com.sun.jersey.config.property.WadlGeneratorConfig' use the property
key 'jersey.config.server.wadl.generatorConfig'. Also check pom.xml of
this sample to see other configuration differences.

Just as a pointer at which files you might have a look:

-   pom.xml
-   src/main/webapp/WEB-INF/web.xml
-   src/main/resources/\*
-   src/main/xsd/schema.xsd
-   org.glassfish.jersey.examples.extendedwadl.SampleWadlGeneratorConfig

The mapping of the URI path space is presented in the following table:

URI path                        | Resource class   | HTTP methods   | Description
------------------------------- | ---------------- | -------------- | ---------------------------------------------------------------------------------------------------------------
**_/items_**                    | ItemsResource    | POST           | Creates a new item and allocates a new unique URI for it, the new URI is returned back in the Location header
**_/items/{id}_**               | ItemResource     | GET            | Returns an item with the id={id}
**_/items/{id}/value/{val}_**   | ItemResource     | PUT            | Updates the value of the item with the id={id} with the new value {val}

Running the Example
-------------------

If you are working with Jersey GlassFish update center module installed
into your existing GlassFish instance, you will need to follow
instructions at [the module README file](../../README.html) in order to
deploy the example.

Otherwise, you can run the example using embedded GlassFish as follows:

You can run the example using Grizzly as follows:

>     mvn clean package exec:java

Get the generated wadl via curl:

>     curl http://localhost:8080/extended-wadl-webapp/application.wadl

Or from a web browser, visit:

>     http://localhost:8080/extended-wadl-webapp/application.wadl
