/*
 * Copyright (c) 2010, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package org.glassfish.jersey.examples.jackson;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

/**
 * TODO javadoc.
 *
 * @author Jakub Podlesak
 */
@Path("/emptyArrayResource")
public class EmptyArrayResource {

    // the resource JSON representation will be serialized by Jackson JAX-RS provider,
    // while the XML will still be generated by JAXB
    @GET
    @Produces({MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML})
    public EmptyArrayBean getIt() {
        return new EmptyArrayBean();
    }
}
