/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.apache.connector;

import com.google.common.util.concurrent.MoreExecutors;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.VersionInfo;
import org.glassfish.jersey.apache.connector.LocalizationMessages;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.ReaderWriter;
import org.glassfish.jersey.message.internal.Statuses;

public class ApacheConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(ApacheConnector.class.getName());
    private final HttpClient client;
    private CookieStore cookieStore = null;
    private boolean preemptiveBasicAuth = false;
    private static final VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)DefaultHttpClient.class.getClassLoader());
    private static final String release = vi != null ? vi.getRelease() : "UNAVAILABLE";

    public ApacheConnector(Configuration config) {
        Object connectionManager = null;
        Object httpParams = null;
        if (config != null) {
            connectionManager = config.getProperties().get("jersey.config.apache.client.connectionManager");
            if (connectionManager != null && !(connectionManager instanceof ClientConnectionManager)) {
                LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.connectionManager", connectionManager.getClass().getName(), ClientConnectionManager.class.getName()));
                connectionManager = null;
            }
            if ((httpParams = (Object)config.getProperties().get("jersey.config.apache.client.httpParams")) != null && !(httpParams instanceof HttpParams)) {
                LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache.client.httpParams", httpParams.getClass().getName(), HttpParams.class.getName()));
                httpParams = null;
            }
        }
        this.client = new DefaultHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpParams);
        if (config != null) {
            Boolean preemptiveBasicAuthProperty;
            Object proxyUri;
            Object credentialsProvider;
            this.client.getParams().setIntParameter("http.connection.timeout", ((Integer)PropertiesHelper.getValue((Map)config.getProperties(), (String)"jersey.config.client.connectTimeout", (Object)0)).intValue());
            this.client.getParams().setIntParameter("http.socket.timeout", ((Integer)PropertiesHelper.getValue((Map)config.getProperties(), (String)"jersey.config.client.readTimeout", (Object)0)).intValue());
            for (Map.Entry entry : config.getProperties().entrySet()) {
                this.client.getParams().setParameter((String)entry.getKey(), entry.getValue());
            }
            Boolean disableCookies = (Boolean)config.getProperties().get("jersey.config.apache.client.handleCookies");
            disableCookies = disableCookies != null ? disableCookies : false;
            if (disableCookies.booleanValue()) {
                this.client.getParams().setParameter("http.protocol.cookie-policy", (Object)"ignoreCookies");
            }
            if ((credentialsProvider = config.getProperty("jersey.config.apache.client.credentialsProvider")) != null && credentialsProvider instanceof CredentialsProvider) {
                ((DefaultHttpClient)this.client).setCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            if ((proxyUri = config.getProperties().get("jersey.config.apache.client.proxyUri")) != null) {
                URI u = ApacheConnector.getProxyUri(proxyUri);
                HttpHost proxy = new HttpHost(u.getHost(), u.getPort(), u.getScheme());
                if (config.getProperties().containsKey("jersey.config.apache.client.proxyUsername") && config.getProperties().containsKey("jersey.config.apache.client.proxyPassword")) {
                    ((DefaultHttpClient)this.client).getCredentialsProvider().setCredentials(new AuthScope(u.getHost(), u.getPort()), (Credentials)new UsernamePasswordCredentials(config.getProperty("jersey.config.apache.client.proxyUsername").toString(), config.getProperty("jersey.config.apache.client.proxyPassword").toString()));
                }
                this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            }
            boolean bl = this.preemptiveBasicAuth = (preemptiveBasicAuthProperty = (Boolean)config.getProperties().get("jersey.config.apache.client.preemptiveBasicAuthentication")) != null ? preemptiveBasicAuthProperty : false;
        }
        if (this.client.getParams().getParameter("http.protocol.cookie-policy") == null || !this.client.getParams().getParameter("http.protocol.cookie-policy").equals("ignoreCookies")) {
            this.cookieStore = new BasicCookieStore();
            ((DefaultHttpClient)this.client).setCookieStore(this.cookieStore);
        }
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    private static URI getProxyUri(Object proxy) {
        if (proxy instanceof URI) {
            return (URI)proxy;
        }
        if (proxy instanceof String) {
            return URI.create((String)proxy);
        }
        throw new ProcessingException(LocalizationMessages.WRONG_PROXY_URI_TYPE("jersey.config.apache.client.proxyUri"));
    }

    public ClientResponse apply(ClientRequest clientRequest) throws ProcessingException {
        HttpUriRequest request = this.getUriHttpRequest(clientRequest);
        this.writeOutBoundHeaders((MultivaluedMap<String, Object>)clientRequest.getHeaders(), request);
        try {
            Header[] respHeaders;
            HttpResponse response;
            if (this.preemptiveBasicAuth) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicScheme = new BasicScheme();
                authCache.put(this.getHost(request), (AuthScheme)basicScheme);
                BasicHttpContext localContext = new BasicHttpContext();
                localContext.setAttribute("http.auth.auth-cache", (Object)authCache);
                response = this.client.execute(this.getHost(request), (HttpRequest)request, (HttpContext)localContext);
            } else {
                response = this.client.execute(this.getHost(request), (HttpRequest)request);
            }
            ClientResponse responseContext = new ClientResponse(Statuses.from((int)response.getStatusLine().getStatusCode()), clientRequest);
            for (Header header : respHeaders = response.getAllHeaders()) {
                ArrayList<String> list = (ArrayList<String>)responseContext.getHeaders().get((Object)header.getName());
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(header.getValue());
                responseContext.getHeaders().addAll((Object)header.getName(), list);
            }
            try {
                responseContext.setEntityStream((InputStream)new HttpClientResponseInputStream(response));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, null, e);
            }
            if (!responseContext.hasEntity()) {
                responseContext.bufferEntity();
                responseContext.close();
            }
            return responseContext;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public Future<?> apply(final ClientRequest request, final AsyncConnectorCallback callback) {
        return MoreExecutors.sameThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.response(ApacheConnector.this.apply(request));
                }
                catch (ProcessingException ex) {
                    callback.failure((Throwable)ex);
                }
                catch (Throwable t) {
                    callback.failure(t);
                }
            }
        });
    }

    public String getName() {
        return "Apache HttpClient " + release;
    }

    public void close() {
        this.client.getConnectionManager().shutdown();
    }

    private HttpHost getHost(HttpUriRequest request) {
        return new HttpHost(request.getURI().getHost(), request.getURI().getPort(), request.getURI().getScheme());
    }

    private HttpUriRequest getUriHttpRequest(ClientRequest clientRequest) {
        final String strMethod = clientRequest.getMethod();
        final URI uri = clientRequest.getUri();
        HttpEntity entity = this.getHttpEntity(clientRequest);
        Object request = strMethod.equals("GET") ? new HttpGet(uri) : (strMethod.equals("POST") ? new HttpPost(uri) : (strMethod.equals("PUT") ? new HttpPut(uri) : (strMethod.equals("DELETE") ? new HttpDelete(uri) : (strMethod.equals("HEAD") ? new HttpHead(uri) : (strMethod.equals("OPTIONS") ? new HttpOptions(uri) : (strMethod.equals("PATCH") ? new HttpPatch(uri) : (strMethod.equals("TRACE") ? new HttpTrace(uri) : new HttpEntityEnclosingRequestBase(){

            public String getMethod() {
                return strMethod;
            }

            public URI getURI() {
                return uri;
            }
        })))))));
        request.getParams().setBooleanParameter("http.protocol.handle-redirects", ((Boolean)PropertiesHelper.getValue((Map)clientRequest.getConfiguration().getProperties(), (String)"jersey.config.client.followRedirects", (Object)true)).booleanValue());
        if (entity != null && request instanceof HttpEntityEnclosingRequestBase) {
            ((HttpEntityEnclosingRequestBase)request).setEntity(entity);
        } else if (entity != null) {
            throw new ProcessingException(LocalizationMessages.ENTITY_NOT_SUPPORTED(clientRequest.getMethod()));
        }
        return request;
    }

    private HttpEntity getHttpEntity(final ClientRequest clientRequest) {
        Object entity = clientRequest.getEntity();
        if (entity == null) {
            return null;
        }
        return new AbstractHttpEntity(){

            public boolean isRepeatable() {
                return false;
            }

            public long getContentLength() {
                return -1L;
            }

            public InputStream getContent() throws IOException, IllegalStateException {
                return null;
            }

            public void writeTo(final OutputStream outputStream) throws IOException {
                clientRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return outputStream;
                    }
                });
                clientRequest.writeEntity();
            }

            public boolean isStreaming() {
                return false;
            }
        };
    }

    private void writeOutBoundHeaders(MultivaluedMap<String, Object> headers, HttpUriRequest request) {
        for (Map.Entry e : headers.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                request.addHeader((String)e.getKey(), vs.get(0).toString());
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (Object v : (List)e.getValue()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(v);
            }
            request.addHeader((String)e.getKey(), b.toString());
        }
    }

    private static InputStream getInputStream(HttpResponse response) throws IOException {
        if (response.getEntity() == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        InputStream i = response.getEntity().getContent();
        if (i.markSupported()) {
            return i;
        }
        return new BufferedInputStream(i, ReaderWriter.BUFFER_SIZE);
    }

    private static final class HttpClientResponseInputStream
    extends FilterInputStream {
        HttpClientResponseInputStream(HttpResponse response) throws IOException {
            super(ApacheConnector.getInputStream(response));
        }

        @Override
        public void close() throws IOException {
            super.close();
        }
    }
}

