
package org.glassfish.jersey.apache.connector;

import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("org.glassfish.jersey.apache.connector.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableIGNORING_VALUE_OF_PROPERTY(Object arg0, Object arg1, Object arg2) {
        return messageFactory.getMessage("ignoring.value.of.property", arg0, arg1, arg2);
    }

    /**
     * Ignoring value of property "{0}" ("{1}") - not instance of "{2}".
     * 
     */
    public static String IGNORING_VALUE_OF_PROPERTY(Object arg0, Object arg1, Object arg2) {
        return localizer.localize(localizableIGNORING_VALUE_OF_PROPERTY(arg0, arg1, arg2));
    }

    public static Localizable localizableWRONG_PROXY_URI_TYPE(Object arg0) {
        return messageFactory.getMessage("wrong.proxy.uri.type", arg0);
    }

    /**
     * The proxy URI ("{0}") property MUST be an instance of String or URI.
     * 
     */
    public static String WRONG_PROXY_URI_TYPE(Object arg0) {
        return localizer.localize(localizableWRONG_PROXY_URI_TYPE(arg0));
    }

    public static Localizable localizableENTITY_NOT_SUPPORTED(Object arg0) {
        return messageFactory.getMessage("entity.not.supported", arg0);
    }

    /**
     * Adding entity to http method {0} is not supported.
     * 
     */
    public static String ENTITY_NOT_SUPPORTED(Object arg0) {
        return localizer.localize(localizableENTITY_NOT_SUPPORTED(arg0));
    }

}
