/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.apache5.connector;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ConnectionReuseStrategy;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.io.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TextUtils;
import org.apache.hc.core5.util.Timeout;
import org.apache.hc.core5.util.VersionInfo;
import org.glassfish.jersey.apache5.connector.Apache5ConnectionClosingStrategy;
import org.glassfish.jersey.apache5.connector.Apache5HttpClientBuilderConfigurator;
import org.glassfish.jersey.apache5.connector.LocalizationMessages;
import org.glassfish.jersey.client.ClientProperties;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.innate.ClientProxy;
import org.glassfish.jersey.client.innate.http.SSLParamConfigurator;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.innate.io.InputStreamWrapper;
import org.glassfish.jersey.internal.PropertiesResolver;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.message.internal.HeaderUtils;
import org.glassfish.jersey.message.internal.OutboundMessageContext;
import org.glassfish.jersey.message.internal.ReaderWriter;
import org.glassfish.jersey.message.internal.Statuses;

class Apache5Connector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(Apache5Connector.class.getName());
    private static final String JERSEY_REQUEST_ATTR_NAME = "JerseyRequestAttribute";
    private static final VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.hc.client5", (ClassLoader)HttpClientBuilder.class.getClassLoader());
    private static final String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
    private final CloseableHttpClient client;
    private final CookieStore cookieStore;
    private final boolean preemptiveBasicAuth;
    private final RequestConfig requestConfig;

    Apache5Connector(Client client, Configuration config) {
        Object retryHandler;
        Object reqConfig;
        Object reuseStrategy;
        Object keepAliveStrategy;
        Object connectionManager = config.getProperties().get("jersey.config.apache5.client.connectionManager");
        if (connectionManager != null && !(connectionManager instanceof HttpClientConnectionManager)) {
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache5.client.connectionManager", connectionManager.getClass().getName(), HttpClientConnectionManager.class.getName()));
        }
        if ((keepAliveStrategy = config.getProperties().get("jersey.config.apache5.client.keepAliveStrategy")) != null && !(keepAliveStrategy instanceof ConnectionKeepAliveStrategy)) {
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache5.client.keepAliveStrategy", keepAliveStrategy.getClass().getName(), ConnectionKeepAliveStrategy.class.getName()));
            keepAliveStrategy = null;
        }
        if ((reuseStrategy = config.getProperties().get("jersey.config.apache5.client.reuseStrategy")) != null && !(reuseStrategy instanceof ConnectionReuseStrategy)) {
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache5.client.reuseStrategy", reuseStrategy.getClass().getName(), ConnectionReuseStrategy.class.getName()));
            reuseStrategy = null;
        }
        if ((reqConfig = config.getProperties().get("jersey.config.apache5.client.requestConfig")) != null && !(reqConfig instanceof RequestConfig)) {
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache5.client.requestConfig", reqConfig.getClass().getName(), RequestConfig.class.getName()));
            reqConfig = null;
        }
        boolean useSystemProperties = PropertiesHelper.isProperty((Map)config.getProperties(), (String)"jersey.config.apache5.client.useSystemProperties");
        SSLContext sslContext = client.getSslContext();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (useSystemProperties) {
            clientBuilder.useSystemProperties();
        }
        clientBuilder.setConnectionManager(this.getConnectionManager(client, config, sslContext, useSystemProperties));
        clientBuilder.setConnectionManagerShared(((Boolean)PropertiesHelper.getValue((Map)config.getProperties(), (String)"jersey.config.apache5.client.connectionManagerShared", (Object)false, null)).booleanValue());
        if (keepAliveStrategy != null) {
            clientBuilder.setKeepAliveStrategy((ConnectionKeepAliveStrategy)keepAliveStrategy);
        }
        if (reuseStrategy != null) {
            clientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)reuseStrategy);
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        Object credentialsProvider = config.getProperty("jersey.config.apache5.client.credentialsProvider");
        if (credentialsProvider != null && credentialsProvider instanceof CredentialsProvider) {
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        if ((retryHandler = config.getProperties().get("jersey.config.apache5.client.retryStrategy")) != null && retryHandler instanceof HttpRequestRetryStrategy) {
            clientBuilder.setRetryStrategy((HttpRequestRetryStrategy)retryHandler);
        }
        Optional proxy = ClientProxy.proxyFromConfiguration((Configuration)config);
        proxy.ifPresent(clientProxy -> {
            URI u = clientProxy.uri();
            HttpHost proxyHost = new HttpHost(u.getScheme(), u.getHost(), u.getPort());
            if (clientProxy.userName() != null && clientProxy.password() != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(u.getHost(), u.getPort()), (Credentials)new UsernamePasswordCredentials(clientProxy.userName(), clientProxy.password().toCharArray()));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            clientBuilder.setProxy(proxyHost);
        });
        Boolean preemptiveBasicAuthProperty = (Boolean)config.getProperties().get("jersey.config.apache5.client.preemptiveBasicAuthentication");
        this.preemptiveBasicAuth = preemptiveBasicAuthProperty != null ? preemptiveBasicAuthProperty : false;
        boolean ignoreCookies = PropertiesHelper.isProperty((Map)config.getProperties(), (String)"jersey.config.apache5.client.handleCookies");
        if (reqConfig != null) {
            RequestConfig.Builder reqConfigBuilder = RequestConfig.copy((RequestConfig)((RequestConfig)reqConfig));
            if (ignoreCookies) {
                reqConfigBuilder.setCookieSpec("ignore");
            }
            this.requestConfig = reqConfigBuilder.build();
        } else {
            if (ignoreCookies) {
                requestConfigBuilder.setCookieSpec("ignore");
            }
            this.requestConfig = requestConfigBuilder.build();
        }
        if (this.requestConfig.getCookieSpec() == null || !this.requestConfig.getCookieSpec().equals("ignore")) {
            this.cookieStore = new BasicCookieStore();
            clientBuilder.setDefaultCookieStore(this.cookieStore);
        } else {
            this.cookieStore = null;
        }
        clientBuilder.setDefaultRequestConfig(this.requestConfig);
        LinkedList contracts = config.getInstances().stream().filter(Apache5HttpClientBuilderConfigurator.class::isInstance).collect(Collectors.toCollection(LinkedList::new));
        HttpClientBuilder configuredBuilder = clientBuilder;
        for (Object configurator : contracts) {
            configuredBuilder = ((Apache5HttpClientBuilderConfigurator)configurator).configure(configuredBuilder);
        }
        this.client = configuredBuilder.build();
    }

    private HttpClientConnectionManager getConnectionManager(Client client, Configuration config, SSLContext sslContext, boolean useSystemProperties) {
        Object cmObject = config.getProperties().get("jersey.config.apache5.client.connectionManager");
        if (cmObject != null) {
            if (cmObject instanceof HttpClientConnectionManager) {
                return (HttpClientConnectionManager)cmObject;
            }
            LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache5.client.connectionManager", cmObject.getClass().getName(), HttpClientConnectionManager.class.getName()));
        }
        return this.createConnectionManager(client, config, sslContext, useSystemProperties);
    }

    private HttpClientConnectionManager createConnectionManager(Client client, Configuration config, SSLContext sslContext, boolean useSystemProperties) {
        String s;
        String[] supportedProtocols = useSystemProperties ? Apache5Connector.split(System.getProperty("https.protocols")) : null;
        String[] supportedCipherSuites = useSystemProperties ? Apache5Connector.split(System.getProperty("https.cipherSuites")) : null;
        HostnameVerifier hostnameVerifier = client.getHostnameVerifier();
        SniSSLConnectionSocketFactory sslSocketFactory = sslContext != null ? new SniSSLConnectionSocketFactory(sslContext, supportedProtocols, supportedCipherSuites, hostnameVerifier) : (useSystemProperties ? new SniSSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), supportedProtocols, supportedCipherSuites, hostnameVerifier) : new SniSSLConnectionSocketFactory(SSLContexts.createDefault(), hostnameVerifier));
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        Integer chunkSize = (Integer)ClientProperties.getValue((Map)config.getProperties(), (String)"jersey.config.client.chunkedEncodingSize", (Object)4096, Integer.class);
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry, (HttpConnectionFactory)new ConnectionFactory(chunkSize));
        if (useSystemProperties && "true".equalsIgnoreCase(s = System.getProperty("http.keepAlive", "true"))) {
            s = System.getProperty("http.maxConnections", "5");
            int max = Integer.parseInt(s);
            connectionManager.setDefaultMaxPerRoute(max);
            connectionManager.setMaxTotal(2 * max);
        }
        return connectionManager;
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s.split(" *, *");
    }

    public HttpClient getHttpClient() {
        return this.client;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public ClientResponse apply(ClientRequest clientRequest) throws ProcessingException {
        HttpUriRequest request = this.getUriHttpRequest(clientRequest);
        Map<String, String> clientHeadersSnapshot = Apache5Connector.writeOutBoundHeaders(clientRequest, request);
        try {
            HttpClientContext context = HttpClientContext.create();
            HttpHost httpHost = this.getHost(request);
            CredentialsProvider credentialsProvider = (CredentialsProvider)clientRequest.resolveProperty("jersey.config.apache5.client.credentialsProvider", CredentialsProvider.class);
            if (credentialsProvider != null) {
                context.setCredentialsProvider(credentialsProvider);
            }
            if (this.preemptiveBasicAuth) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicScheme = new BasicScheme();
                AuthScope authScope = new AuthScope(httpHost);
                basicScheme.initPreemptive(credentialsProvider.getCredentials(authScope, (HttpContext)context));
                context.resetAuthExchange(httpHost, (AuthScheme)basicScheme);
                authCache.put(httpHost, (AuthScheme)basicScheme);
                context.setAuthCache((AuthCache)authCache);
            }
            context.setAttribute(JERSEY_REQUEST_ATTR_NAME, (Object)clientRequest);
            CloseableHttpResponse response = this.client.execute(httpHost, (ClassicHttpRequest)request, (HttpContext)context);
            HeaderUtils.checkHeaderChanges(clientHeadersSnapshot, (MultivaluedMap)clientRequest.getHeaders(), (String)this.getClass().getName(), (Configuration)clientRequest.getConfiguration());
            Response.StatusType status = response.getReasonPhrase() == null ? Statuses.from((int)response.getCode()) : Statuses.from((int)response.getCode(), (String)response.getReasonPhrase());
            ClientResponse responseContext = new ClientResponse(status, clientRequest);
            List redirectLocations = context.getRedirectLocations().getAll();
            if (redirectLocations != null && !redirectLocations.isEmpty()) {
                responseContext.setResolvedRequestUri((URI)redirectLocations.get(redirectLocations.size() - 1));
            }
            Header[] respHeaders = response.getHeaders();
            MultivaluedMap headers = responseContext.getHeaders();
            for (Header header : respHeaders) {
                String headerName = header.getName();
                ArrayList<String> list = (ArrayList<String>)headers.get((Object)headerName);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(header.getValue());
                headers.put((Object)headerName, list);
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (headers.get((Object)"Content-Length") == null && entity.getContentLength() >= 0L) {
                    headers.add((Object)"Content-Length", (Object)String.valueOf(entity.getContentLength()));
                }
                String contentEncoding = entity.getContentEncoding();
                if (headers.get((Object)"Content-Encoding") == null && contentEncoding != null && !contentEncoding.isEmpty()) {
                    headers.add((Object)"Content-Encoding", (Object)contentEncoding);
                }
            }
            try {
                ConnectionClosingMechanism closingMechanism = new ConnectionClosingMechanism(clientRequest, request);
                responseContext.setEntityStream(Apache5Connector.getInputStream(response, closingMechanism, () -> clientRequest.isCancelled()));
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, null, e);
            }
            return responseContext;
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public Future<?> apply(ClientRequest request, AsyncConnectorCallback callback) {
        try {
            ClientResponse response = this.apply(request);
            callback.response(response);
            return CompletableFuture.completedFuture(response);
        }
        catch (Throwable t) {
            callback.failure(t);
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(t);
            return future;
        }
    }

    public String getName() {
        return "Apache HttpClient " + release;
    }

    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new ProcessingException(LocalizationMessages.FAILED_TO_STOP_CLIENT(), (Throwable)e);
        }
    }

    private HttpHost getHost(HttpUriRequest request) throws URISyntaxException {
        return new HttpHost(request.getUri().getScheme(), request.getUri().getHost(), request.getUri().getPort());
    }

    private HttpUriRequest getUriHttpRequest(ClientRequest clientRequest) {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.copy((RequestConfig)this.requestConfig);
        int connectTimeout = (Integer)clientRequest.resolveProperty("jersey.config.client.connectTimeout", (Object)-1);
        int socketTimeout = (Integer)clientRequest.resolveProperty("jersey.config.client.readTimeout", (Object)-1);
        if (connectTimeout >= 0) {
            requestConfigBuilder.setConnectTimeout(Timeout.ofMilliseconds((long)connectTimeout));
        }
        if (socketTimeout >= 0) {
            requestConfigBuilder.setResponseTimeout(Timeout.ofMilliseconds((long)socketTimeout));
        }
        Boolean redirectsEnabled = (Boolean)clientRequest.resolveProperty("jersey.config.client.followRedirects", (Object)this.requestConfig.isRedirectsEnabled());
        requestConfigBuilder.setRedirectsEnabled(redirectsEnabled.booleanValue());
        Boolean bufferingEnabled = clientRequest.resolveProperty("jersey.config.client.request.entity.processing", RequestEntityProcessing.class) == RequestEntityProcessing.BUFFERED;
        HttpEntity entity = this.getHttpEntity(clientRequest, bufferingEnabled);
        HttpUriRequestBase httpUriRequestBase = new HttpUriRequestBase(clientRequest.getMethod(), clientRequest.getUri());
        httpUriRequestBase.setConfig(requestConfigBuilder.build());
        httpUriRequestBase.setEntity(entity);
        return httpUriRequestBase;
    }

    private HttpEntity getHttpEntity(final ClientRequest clientRequest, final boolean bufferingEnabled) {
        Object entity = clientRequest.getEntity();
        if (entity == null) {
            return null;
        }
        if (HttpEntity.class.isInstance(entity)) {
            return this.wrapHttpEntity(clientRequest, (HttpEntity)entity);
        }
        String contentType = clientRequest.getHeaderString("Content-Type");
        String contentEncoding = clientRequest.getHeaderString("Content-Encoding");
        AbstractHttpEntity httpEntity = new AbstractHttpEntity(contentType, contentEncoding){

            public void close() throws IOException {
            }

            public boolean isRepeatable() {
                return false;
            }

            public long getContentLength() {
                return -1L;
            }

            public InputStream getContent() throws IOException, IllegalStateException {
                if (bufferingEnabled) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream(512);
                    this.writeTo(buffer);
                    return new ByteArrayInputStream(buffer.toByteArray());
                }
                return null;
            }

            public void writeTo(final OutputStream outputStream) throws IOException {
                clientRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return outputStream;
                    }
                });
                clientRequest.writeEntity();
            }

            public boolean isStreaming() {
                return false;
            }
        };
        return Apache5Connector.bufferEntity((HttpEntity)httpEntity, bufferingEnabled);
    }

    private HttpEntity wrapHttpEntity(final ClientRequest clientRequest, final HttpEntity originalEntity) {
        boolean bufferingEnabled = BufferedHttpEntity.class.isInstance(originalEntity);
        try {
            clientRequest.setEntity((Object)originalEntity.getContent());
        }
        catch (IOException e) {
            throw new ProcessingException(LocalizationMessages.ERROR_READING_HTTPENTITY_STREAM(e.getMessage()), (Throwable)e);
        }
        AbstractHttpEntity httpEntity = new AbstractHttpEntity(originalEntity.getContentType(), originalEntity.getContentEncoding(), originalEntity.isChunked()){

            public void close() throws IOException {
            }

            public boolean isRepeatable() {
                return originalEntity.isRepeatable();
            }

            public long getContentLength() {
                return originalEntity.getContentLength();
            }

            public InputStream getContent() throws IOException, IllegalStateException {
                return originalEntity.getContent();
            }

            public void writeTo(final OutputStream outputStream) throws IOException {
                clientRequest.setStreamProvider(new OutboundMessageContext.StreamProvider(){

                    public OutputStream getOutputStream(int contentLength) throws IOException {
                        return outputStream;
                    }
                });
                clientRequest.writeEntity();
            }

            public boolean isStreaming() {
                return originalEntity.isStreaming();
            }
        };
        return Apache5Connector.bufferEntity((HttpEntity)httpEntity, bufferingEnabled);
    }

    private static HttpEntity bufferEntity(HttpEntity httpEntity, boolean bufferingEnabled) {
        if (bufferingEnabled) {
            try {
                return new BufferedHttpEntity(httpEntity);
            }
            catch (IOException e) {
                throw new ProcessingException(LocalizationMessages.ERROR_BUFFERING_ENTITY(), (Throwable)e);
            }
        }
        return httpEntity;
    }

    private static Map<String, String> writeOutBoundHeaders(ClientRequest clientRequest, HttpUriRequest request) {
        Map stringHeaders = HeaderUtils.asStringHeadersSingleValue((MultivaluedMap)clientRequest.getHeaders(), (Configuration)clientRequest.getConfiguration());
        for (Map.Entry e : stringHeaders.entrySet()) {
            request.addHeader((String)e.getKey(), e.getValue());
        }
        return stringHeaders;
    }

    private static InputStream getInputStream(CloseableHttpResponse response, ConnectionClosingMechanism closingMechanism, Supplier<Boolean> isCancelled) throws IOException {
        CancellableInputStream i;
        Object inputStream = response.getEntity() == null ? new ByteArrayInputStream(new byte[0]) : (((InputStream)((Object)(i = new CancellableInputStream(response.getEntity().getContent(), isCancelled)))).markSupported() ? i : new BufferedInputStream((InputStream)((Object)i), ReaderWriter.BUFFER_SIZE));
        return closingMechanism.getEntityStream(inputStream, response);
    }

    private static class CancellableInputStream
    extends InputStreamWrapper {
        private final InputStream in;
        private final Supplier<Boolean> isCancelled;

        private CancellableInputStream(InputStream in, Supplier<Boolean> isCancelled) {
            this.in = in;
            this.isCancelled = isCancelled;
        }

        protected InputStream getWrapped() {
            return this.in;
        }

        protected InputStream getWrappedIOE() throws IOException {
            if (this.isCancelled.get().booleanValue()) {
                throw new IOException(new CancellationException());
            }
            return this.in;
        }
    }

    private static final class SniSSLConnectionSocketFactory
    extends SSLConnectionSocketFactory {
        private final ThreadLocal<HttpContext> httpContexts = new ThreadLocal();

        public SniSSLConnectionSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier) {
            super(sslContext, supportedProtocols, supportedCipherSuites, hostnameVerifier);
        }

        public SniSSLConnectionSocketFactory(SSLSocketFactory socketFactory, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier) {
            super(socketFactory, supportedProtocols, supportedCipherSuites, hostnameVerifier);
        }

        public SniSSLConnectionSocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
            super(sslContext, hostnameVerifier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
            this.httpContexts.set(context);
            try {
                Socket socket2 = super.createLayeredSocket(socket, target, port, context);
                return socket2;
            }
            finally {
                this.httpContexts.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket createLayeredSocket(Socket socket, String target, int port, Object attachment, HttpContext context) throws IOException {
            this.httpContexts.set(context);
            try {
                Socket socket2 = super.createLayeredSocket(socket, target, port, attachment, context);
                return socket2;
            }
            finally {
                this.httpContexts.remove();
            }
        }

        protected void prepareSocket(SSLSocket socket) throws IOException {
            Object objectRequest;
            HttpContext context = this.httpContexts.get();
            if (context != null && (objectRequest = context.getAttribute(Apache5Connector.JERSEY_REQUEST_ATTR_NAME)) != null) {
                ClientRequest clientRequest = (ClientRequest)objectRequest;
                SSLParamConfigurator sniConfig = SSLParamConfigurator.builder().request(clientRequest).setSNIHostName((PropertiesResolver)clientRequest).build();
                sniConfig.setSNIServerName(socket);
                int socketTimeout = (Integer)((ClientRequest)objectRequest).resolveProperty("jersey.config.client.readTimeout", (Object)-1);
                if (socketTimeout >= 0) {
                    socket.setSoTimeout(socketTimeout);
                }
            }
        }
    }

    private static class ConnectionFactory
    extends ManagedHttpClientConnectionFactory {
        private ConnectionFactory(int chunkSize) {
            super(Http1Config.custom().setChunkSizeHint(chunkSize).build(), null, null, null, (ContentLengthStrategy)DefaultContentLengthStrategy.INSTANCE, (ContentLengthStrategy)DefaultContentLengthStrategy.INSTANCE);
        }
    }

    private final class ConnectionClosingMechanism {
        private Apache5ConnectionClosingStrategy connectionClosingStrategy = null;
        private final ClientRequest clientRequest;
        private final HttpUriRequest apacheRequest;

        private ConnectionClosingMechanism(ClientRequest clientRequest, HttpUriRequest apacheRequest) {
            this.clientRequest = clientRequest;
            this.apacheRequest = apacheRequest;
            Object closingStrategyProperty = clientRequest.resolveProperty("jersey.config.apache5.client.connectionClosingStrategy", Object.class);
            if (closingStrategyProperty != null) {
                if (Apache5ConnectionClosingStrategy.class.isInstance(closingStrategyProperty)) {
                    this.connectionClosingStrategy = (Apache5ConnectionClosingStrategy)closingStrategyProperty;
                } else {
                    LOGGER.log(Level.WARNING, LocalizationMessages.IGNORING_VALUE_OF_PROPERTY("jersey.config.apache5.client.connectionClosingStrategy", closingStrategyProperty, Apache5ConnectionClosingStrategy.class.getName()));
                }
            }
            if (this.connectionClosingStrategy == null) {
                this.connectionClosingStrategy = Apache5ConnectionClosingStrategy.Apache5GracefulClosingStrategy.INSTANCE;
            }
        }

        private InputStream getEntityStream(InputStream inputStream, final CloseableHttpResponse response) {
            FilterInputStream filterStream = new FilterInputStream(inputStream){

                @Override
                public void close() throws IOException {
                    ConnectionClosingMechanism.this.connectionClosingStrategy.close(ConnectionClosingMechanism.this.clientRequest, ConnectionClosingMechanism.this.apacheRequest, response, this.in);
                }
            };
            return filterStream;
        }
    }
}

