
package org.glassfish.jersey.apache5.connector;

import java.util.Locale;
import java.util.ResourceBundle;
import org.glassfish.jersey.internal.l10n.Localizable;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import org.glassfish.jersey.internal.l10n.LocalizableMessageFactory.ResourceBundleSupplier;
import org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static String BUNDLE_NAME = "org.glassfish.jersey.apache5.connector.localization";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new LocalizationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableINVALID_CONFIGURABLE_COMPONENT_TYPE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("invalid.configurable.component.type", arg0);
    }

    /**
     * The supplied component "{0}" is not assignable from JerseyClient or JerseyWebTarget.
     * 
     */
    public static String INVALID_CONFIGURABLE_COMPONENT_TYPE(Object arg0) {
        return LOCALIZER.localize(localizableINVALID_CONFIGURABLE_COMPONENT_TYPE(arg0));
    }

    public static Localizable localizableEXPECTED_CONNECTOR_PROVIDER_NOT_USED() {
        return MESSAGE_FACTORY.getMessage("expected.connector.provider.not.used");
    }

    /**
     * The supplied component is not configured to use a ApacheConnectorProvider.
     * 
     */
    public static String EXPECTED_CONNECTOR_PROVIDER_NOT_USED() {
        return LOCALIZER.localize(localizableEXPECTED_CONNECTOR_PROVIDER_NOT_USED());
    }

    public static Localizable localizableFAILED_TO_STOP_CLIENT() {
        return MESSAGE_FACTORY.getMessage("failed.to.stop.client");
    }

    /**
     * Failed to stop the client.
     * 
     */
    public static String FAILED_TO_STOP_CLIENT() {
        return LOCALIZER.localize(localizableFAILED_TO_STOP_CLIENT());
    }

    public static Localizable localizableIGNORING_VALUE_OF_PROPERTY(Object arg0, Object arg1, Object arg2) {
        return MESSAGE_FACTORY.getMessage("ignoring.value.of.property", arg0, arg1, arg2);
    }

    /**
     * Ignoring value of property "{0}" ("{1}") - not instance of "{2}".
     * 
     */
    public static String IGNORING_VALUE_OF_PROPERTY(Object arg0, Object arg1, Object arg2) {
        return LOCALIZER.localize(localizableIGNORING_VALUE_OF_PROPERTY(arg0, arg1, arg2));
    }

    public static Localizable localizableERROR_BUFFERING_ENTITY() {
        return MESSAGE_FACTORY.getMessage("error.buffering.entity");
    }

    /**
     * Error buffering the entity.
     * 
     */
    public static String ERROR_BUFFERING_ENTITY() {
        return LOCALIZER.localize(localizableERROR_BUFFERING_ENTITY());
    }

    public static Localizable localizableERROR_READING_HTTPENTITY_STREAM(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.reading.httpentity.stream", arg0);
    }

    /**
     * Error reading InputStream from HttpEntity: "{0}"
     * 
     */
    public static String ERROR_READING_HTTPENTITY_STREAM(Object arg0) {
        return LOCALIZER.localize(localizableERROR_READING_HTTPENTITY_STREAM(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
