/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly.connector;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.RequestWriter;
import org.glassfish.jersey.process.Inflector;

public class GrizzlyConnector
extends RequestWriter
implements Inflector<Request, Response> {
    private AsyncHttpClient client;
    private AsyncHttpClientConfig config;
    private final ExecutorService executorService;
    private static final int DEFAULT_TIMEOUT = 10000;

    public GrizzlyConnector(Configuration configuration) {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        if (configuration != null) {
            Object threadpoolSize = configuration.getProperties().get("jersey.config.client.async.threadPoolSize");
            this.executorService = threadpoolSize != null && threadpoolSize instanceof Integer && (Integer)threadpoolSize > 0 ? Executors.newFixedThreadPool((Integer)threadpoolSize) : Executors.newCachedThreadPool();
            builder = builder.setExecutorService(this.executorService);
            Integer timeout = (Integer)configuration.getProperties().get("jersey.config.client.connectTimeout");
            builder = timeout != null ? builder.setConnectionTimeoutInMs(timeout.intValue()) : builder.setConnectionTimeoutInMs(10000);
        } else {
            this.executorService = Executors.newCachedThreadPool();
            builder.setExecutorService(this.executorService);
        }
        this.config = builder.setAllowPoolingConnection(true).build();
        this.client = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(this.config), this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response apply(Request jerseyRequest) {
        com.ning.http.client.Response ningResponse = null;
        try {
            com.ning.http.client.Request grizzlyRequest = this.getRequest(jerseyRequest);
            ListenableFuture respFuture = this.client.executeRequest(grizzlyRequest);
            ningResponse = (com.ning.http.client.Response)respFuture.get();
        }
        catch (Exception ex) {
            Logger.getLogger(GrizzlyConnector.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.client.close();
        }
        Response resp = this.getClientResponse(ningResponse);
        return resp;
    }

    private Response getClientResponse(com.ning.http.client.Response original) {
        Response r = null;
        try {
            Response.ResponseBuilder builder = Response.status((int)original.getStatusCode()).entity((Object)original.getResponseBody());
            builder = this.insertHeaders(builder, original);
            r = builder.build();
        }
        catch (IOException ex) {
            Logger.getLogger(GrizzlyConnector.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!r.hasEntity()) {
            r.bufferEntity();
            r.close();
        }
        return r;
    }

    private Response.ResponseBuilder insertHeaders(Response.ResponseBuilder builder, com.ning.http.client.Response response) {
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            builder.header(entry.toString(), entry.getValue());
        }
        return builder;
    }

    private com.ning.http.client.Request getRequest(Request request) {
        String strMethod = request.getMethod();
        URI uri = request.getUri();
        RequestBuilder builder = new RequestBuilder(strMethod).setUrl(uri.toString());
        Request.EntityWriter entity = this.getHttpEntity(request);
        if (entity != null) {
            builder = builder.setBody(entity);
        }
        com.ning.http.client.Request result = builder.build();
        GrizzlyConnector.writeOutBoundHeaders((MultivaluedMap<String, String>)request.getHeaders().asMap(), result);
        return result;
    }

    protected static void writeOutBoundHeaders(MultivaluedMap<String, String> headers, com.ning.http.client.Request request) {
        for (Map.Entry e : headers.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                request.getHeaders().add((String)e.getKey(), new String[]{(String)vs.get(0)});
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (String v : (List)e.getValue()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append((Object)v);
            }
            request.getHeaders().add((String)e.getKey(), new String[]{b.toString()});
        }
    }

    private Request.EntityWriter getHttpEntity(Request jerseyRequest) {
        Object entity = jerseyRequest.getEntity();
        if (entity == null) {
            return null;
        }
        final RequestWriter.RequestEntityWriter rew = this.getRequestEntityWriter(jerseyRequest);
        return new Request.EntityWriter(){

            public void writeEntity(OutputStream out) throws IOException {
                rew.writeRequestEntity(out);
            }
        };
    }
}

