/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly.connector;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.Response;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.client.Configuration;
import javax.ws.rs.client.InvocationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.RequestWriter;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.process.Inflector;

public class GrizzlyConnector
extends RequestWriter
implements Inflector<ClientRequest, ClientResponse> {
    private AsyncHttpClient client;
    private AsyncHttpClientConfig config;
    private final ExecutorService executorService;

    public GrizzlyConnector(Configuration configuration) {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        if (configuration != null) {
            Object threadpoolSize = configuration.getProperties().get("jersey.config.client.async.threadPoolSize");
            this.executorService = threadpoolSize != null && threadpoolSize instanceof Integer && (Integer)threadpoolSize > 0 ? Executors.newFixedThreadPool((Integer)threadpoolSize) : Executors.newCachedThreadPool();
            builder = builder.setExecutorService(this.executorService);
            builder.setConnectionTimeoutInMs(((Integer)PropertiesHelper.getValue((Map)configuration.getProperties(), (String)"jersey.config.client.connectTimeout", (Object)0)).intValue());
            builder.setRequestTimeoutInMs(((Integer)PropertiesHelper.getValue((Map)configuration.getProperties(), (String)"jersey.config.client.readTimeout", (Object)0)).intValue());
        } else {
            this.executorService = Executors.newCachedThreadPool();
            builder.setExecutorService(this.executorService);
        }
        this.config = builder.setAllowPoolingConnection(true).build();
        this.client = new AsyncHttpClient((AsyncHttpProvider)new GrizzlyAsyncHttpProvider(this.config), this.config);
    }

    public ClientResponse apply(ClientRequest requestContext) {
        Response ningResponse = null;
        try {
            Request grizzlyRequest = this.getRequest(requestContext);
            ListenableFuture respFuture = this.client.executeRequest(grizzlyRequest);
            ningResponse = (Response)respFuture.get();
        }
        catch (ExecutionException ex) {
            Throwable e = ex.getCause() == null ? ex : ex.getCause();
            throw new InvocationException(e.getMessage(), e);
        }
        catch (Exception ex) {
            throw new InvocationException(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.client.close();
        }
        ClientResponse responseContext = this.getClientResponse(requestContext, ningResponse);
        return responseContext;
    }

    private ClientResponse getClientResponse(ClientRequest requestContext, final Response original) {
        ClientResponse responseContext = new ClientResponse(new Response.StatusType(){

            public int getStatusCode() {
                return original.getStatusCode();
            }

            public Response.Status.Family getFamily() {
                return Response.Status.Family.familyOf((int)original.getStatusCode());
            }

            public String getReasonPhrase() {
                return original.getStatusText();
            }
        }, requestContext);
        for (Map.Entry entry : original.getHeaders().entrySet()) {
            for (String value : (List)entry.getValue()) {
                responseContext.getHeaders().add(entry.getKey(), (Object)value);
            }
        }
        try {
            responseContext.setEntityStream(original.getResponseBodyAsStream());
        }
        catch (IOException e) {
            Logger.getLogger(GrizzlyConnector.class.getName()).log(Level.SEVERE, null, e);
        }
        return responseContext;
    }

    private Request getRequest(ClientRequest requestContext) {
        String strMethod = requestContext.getMethod();
        URI uri = requestContext.getUri();
        RequestBuilder builder = new RequestBuilder(strMethod).setUrl(uri.toString());
        builder.setFollowRedirects(((Boolean)PropertiesHelper.getValue((Map)requestContext.getConfiguration().getProperties(), (String)"jersey.config.client.followRedirects", (Object)true)).booleanValue());
        Request.EntityWriter entity = this.getHttpEntity(requestContext);
        if (entity != null) {
            builder = builder.setBody(entity);
        }
        Request result = builder.build();
        GrizzlyConnector.writeOutBoundHeaders((MultivaluedMap<String, Object>)requestContext.getHeaders(), result);
        return result;
    }

    protected static void writeOutBoundHeaders(MultivaluedMap<String, Object> headers, Request request) {
        for (Map.Entry e : headers.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                request.getHeaders().add((String)e.getKey(), new String[]{vs.get(0).toString()});
                continue;
            }
            StringBuilder b = new StringBuilder();
            for (Object v : (List)e.getValue()) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append(v);
            }
            request.getHeaders().add((String)e.getKey(), new String[]{b.toString()});
        }
    }

    private Request.EntityWriter getHttpEntity(ClientRequest requestContext) {
        Object entity = requestContext.getEntity();
        if (entity == null) {
            return null;
        }
        final RequestWriter.RequestEntityWriter rew = this.getRequestEntityWriter(requestContext);
        return new Request.EntityWriter(){

            public void writeEntity(OutputStream out) throws IOException {
                rew.writeRequestEntity(out);
            }
        };
    }
}

